#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int count, wordresult;
FILE *sourcefile, *targetfile;
char tmpchar;

void print_help (void)

{
  
  printf ("\n\tcrypto 1.0\n");
  printf ("\t(c) Nur Amijaya <amijaya@softhome.net>\n");
  printf ("\n\tUsage :\n");
  printf ("\t  - encrypt file : crypto -e <source file> <target file> <password>\n");
  printf ("\t  - decrypt file : crypto -d <source file> <target file> <password>\n");
  printf ("\t  - version      : crypto -v\n");
  printf ("\t  - help         : crypto -h\n\n");
  
}

void print_version (void)

{

  printf ("\n\tcrypto 1.0\n");
  printf ("\t(c) Nur Amijaya <amijaya@softhome.net>\n");
  printf ("\t    2002-02-22\n\n");
  printf ("\tThe program was compiled on %s %s \n", __DATE__, __TIME__);
  printf ("\twith %s from file %s\n",__VERSION__, __FILE__);
  printf ("\tThis program is GPL and comes with ABSOLUTELY NO WARRANTY\n\n");

}

int encrypt(char chin, int key)
{
  char chout;
  chout = ( chin - count + ( 3 * key ) - ( key * key ) + key );
  count = ( count * count - 2 * count );
  return chout;
}

int decrypt(char chin, int key)
{
  char chout;
  chout = ( chin + count - ( 3 * key ) + ( key * key ) - key );
  count = ( count * count - 2 * count);
  return chout;
}

int sumkeyword(char* strpasswd)
{
    int a=0;
    int b=0;
    int all=0;
    for(; a<=strlen(strpasswd); a++)
    {
        for(; b<=strlen(strpasswd); b++)
        {
            all = ( all + strpasswd[a] ) + (strpasswd[b]) - ( strpasswd[( strlen( strpasswd ) - 2 )]*(strlen( strpasswd ) + 3));
        }
    }
    return abs(all);
}

int main(int argc, char *argv[])

{

 if (!(argc == 2 || argc == 5))
    {
     print_help();
     return (0);
    }
    else if (!strcmp (argv[1], "-h") || !strcmp (argv[1], "-?"))
       {
        print_help();
        return (0);
       }
       else if (!strcmp (argv[1], "-v")) { print_version(); return(0); }
          
 if (argc == 5 && !strcmp (argv[1], "-e"))
    {
     print_version ();
     sourcefile = fopen (argv[2], "r");
     if (!sourcefile)
       {
        printf ("\n\tcouldn't open source file !\n\n");
        return(1);
       }
     targetfile = fopen (argv[3], "w");
     if (!targetfile)
       {
        fclose (sourcefile);
        printf ("\n\tcouldn't open target file !\n\n");
        return;
       }
  
     count = 1;
     wordresult = sumkeyword (argv[4]);

     if (feof (sourcefile))  return(1);
     while (!feof (sourcefile))
       {
        tmpchar = encrypt (fgetc (sourcefile), wordresult);
        if (feof (sourcefile))
          {
           fclose (sourcefile);
           fclose (targetfile);
           printf ("\n\tSuccess !\n\n");
           return(0);
          }
        fputc (tmpchar, targetfile);
       }
     return(1);
   }
   
 if (argc == 5 && !strcmp (argv[1], "-d"))
   {
    print_version ();
    sourcefile = fopen (argv[2], "r");
    if (!sourcefile)
      {
       printf ("\n\tcouldn't open source file !\n\n");
       return;
      }
    targetfile = fopen (argv[3], "w");
    if (!targetfile)
      {
       fclose (sourcefile);
       printf ("\n\tcouldn't open target file !\n\n");
       return;
      }
  
    count = 1;
    wordresult = sumkeyword (argv[4]);

    if (feof (sourcefile))  return;
    while (!feof (sourcefile))
      {
       tmpchar = decrypt (fgetc (sourcefile), wordresult);
       if (feof (sourcefile))
         {
          fclose (sourcefile);
          fclose (targetfile);
          printf ("\n\tSuccess !\n\n");
          return;
         }
       fputc (tmpchar, targetfile);
      }
    return (0);
   }
    else print_help ();

}

