/* ----------------------------------------------------------------------------
 * Copyright (C) 2000-2005 by Karim Kaschani
 * 
 * This file is part of the software xIncode developed to support the design
 * of interconnects in semiconductor technologies.
 * 
 * xIncode is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * xIncode is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ------------------------------------------------------------------------- */





/* ----------------------------------------------------------------------------
 * xincode.h - xIncode header file
 * ------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <errno.h>
#include <Xm/XmAll.h>

#define	TRUE			1
#define	FALSE			0

#define MAX_CHARS		1024

#define	MENU_EXIT		100
#define	MENU_LOAD		101
#define	MENU_SAVE		102
#define	MENU_READ		103
#define	MENU_MINIMIZE		104

#define DIALOG_WAIT		200
#define DIALOG_OK		201
#define DIALOG_CANCEL		202
#define DIALOG_HELP		203

#define	LAST_NONE		300
#define	LAST_CURRENT		301
#define	LAST_WIDTH		302
#define	LAST_XSIZE		303
#define	LAST_YSIZE		304

#define	METAL			0
#define	POLY			1

#define	CONTACTHOLE		0
#define	VIA			1

#define NONPLANARIZED		0
#define PLANARIZED		1

#define	MAX(a,b)		((a>b) ? a : b)
#define	MIN(a,b)		((a<b) ? a : b)

/* ----------------------------------------------------------------- typedefs*/

typedef	char	line[MAX_CHARS];

typedef struct {
	line	*label;		/* database selection label */
	line	*file;		/* database technology file name */
	int	size;		/* number of available technology files */
} DBData;

typedef struct {
	char	*name;		/* name of metallization layer */
	int	material;	/* 0 = metal, 1 = poly silicon */
	int	viatype;	/* 0 = contact hole, 1 = via */
	double	thickness;	/* thickness of metallization layer */
	double	minlayerwidth;	/* minimum width of metallization layer */
	double	minviasize;	/* minimum size of contact or via */
	double  viacoefficient;	/* via/contact type coefficient */
	double	t50n;		/* normalized mean time to failure */
	double	refcur;		/* reference current density */
	double	reftemp;	/* reference temperature */
	double	refwidth;	/* reference width of metallization */
	double	maxcurratio;	/* maximum current density ratio for
				 * validity of Black's equation */
	double	mincurratio;	/* minimum current density ratio for
				 * validity of Black's equation */
	double	sigma;		/* sigma of probability density function */
	double	energy;		/* activation energy */
	double	exp;		/* exponent used in Black's equation */
	double	rho;		/* specific resistance of metallization */
	double	tc;		/* temperature coefficient of rho */
	double	dist2si;	/* total thickness of isolation layers */
	double	lambda;		/* effective thermal conductivity
				 * of isolation layers */
	double	templimit;	/* overheating threshold temperature */
	double	maxpower;	/* maximum power density */
} LAYData;

typedef struct {
	char	*name;		/* name of technology */
	int	type;		/* type of technology (planarized or not) */
	int	layers;		/* number of metallization layers */
	LAYData	*layer;		/* metallization layer pointer */
} TECData;

typedef struct {
	int	nL;		/* number of selected layers */
	int	*sL;		/* pointer to selected layer numbers */
	double	fit;		/* failure rate [FIT] */
	double	lifetime;	/* maximum lifetime of operation */
	double	temp;		/* maximum operating temperature */
	double	current;	/* metallization line current */
	double	width;		/* width of metallization line */
	double	xsize;		/* x size of via */
	double	ysize;		/* y size of via */
} MIGRData;

typedef struct {
	double	current;	/* current flowing across metallization line */
	double	width;		/* width of metallization line */
	double	temp;		/* estimated temperature increase of
				 * metallization line */
	double	templimit;	/* overheating threshold (default = 0) */
} RESDataL;

typedef struct {
	double	xsize;		/* x size of via */
	double	ysize;		/* y size of via */
	double	viacurr;	/* current flowing across via */
} RESDataV;

/* ----------------------------------------------------------------- globals */

XtAppContext	app_context;
Widget		app_shell, main_win, main_form;
char		tmp1[MAX_CHARS];	/* temporary strings */
char		tmp2[MAX_CHARS];	/* temporary strings */
TECData		Tec;			/* Technology data structure */
MIGRData	C;			/* Migration data structure */
int		DEBUG;			/* Debugging flag */
int		LOG;			/* Logging flag for debugging */
