%{
/* ----------------------------------------------------------------------------
 * Copyright (C) 2000-2005 by Karim Kaschani
 * 
 * This file is part of the software xIncode developed to support the design
 * of interconnects in semiconductor technologies.
 * 
 * xIncode is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * xIncode is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ------------------------------------------------------------------------- */

#include "xincode.h"

extern	TECData	Tec;
extern	int	DEBUG;

%}

%union {
	int	ival;
	double	dval;
	char	*sval;
}

%token <sval> STRING
%token <dval> NUMBER
%token <ival> SUBSTANCE
%token <ival> CONTACT
%token <ival> TECHTYPE
%token DEFINITION
%token TECHNOLOGY TITLE TYPE
%token LAYER MATERIAL INTERCONNECTION THICKNESS MINLAYERWIDTH MINVIASIZE
%token VIACOEFFICIENT T50N REFCUR REFTEMP REFWIDTH
%token MAXCURRATIO MINCURRATIO SIGMA ENERGY EXP
%token RHO TC DIST2SI LAMBDA TEMPLIMIT MAXPOWER

%%

tech_def:	TECHNOLOGY tech_br
	;

tech_br:	'{' tech_body '}'
	|	'(' tech_body ')'
	|	'[' tech_body ']'
	;

tech_body:	/* empty for recursion termination */
	|	tech_body TITLE DEFINITION STRING	/* left recursion! */
		{
		  if (!DEBUG) Tec.name = $4;
		}
	|	tech_body TYPE DEFINITION TECHTYPE	/* left recursion! */
		{
		  if (!DEBUG) Tec.type = $4;
		}
	|	tech_body LAYER layer_br
		{
		  if (!DEBUG) {
		     Tec.layers++;
		     Tec.layer = (LAYData *) realloc(Tec.layer, 
		                 sizeof(LAYData) * (Tec.layers + 1));
		  }
		}
	;

layer_br:	'{' layer_body '}'
	|	'(' layer_body ')'
	|	'[' layer_body ']'
	;

layer_body:	/* empty for recursion termination */
	|	layer_body TITLE DEFINITION STRING	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].name = $4;
		}
	|	layer_body MATERIAL DEFINITION SUBSTANCE /* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].material = $4;
		}
	|	layer_body THICKNESS DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].thickness = $4;
		}
	|	layer_body INTERCONNECTION DEFINITION CONTACT	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].viatype = $4;
		}
	|	layer_body MINLAYERWIDTH DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].minlayerwidth = $4;
		}
	|	layer_body MINVIASIZE DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].minviasize = $4;
		}
	|	layer_body VIACOEFFICIENT DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].viacoefficient = $4;
		}
	|	layer_body T50N DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].t50n = $4;
		}
	|	layer_body REFCUR DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].refcur = $4;
		}
	|	layer_body REFTEMP DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].reftemp = $4;
		}
	|	layer_body REFWIDTH DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].refwidth = $4;
		}
	|	layer_body MAXCURRATIO DEFINITION NUMBER /* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].maxcurratio = $4;
		}
	|	layer_body MINCURRATIO DEFINITION NUMBER /* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].mincurratio = $4;
		}
	|	layer_body SIGMA DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].sigma = $4;
		}
	|	layer_body ENERGY DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].energy = $4;
		}
	|	layer_body EXP DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].exp = $4;
		}
	|	layer_body RHO DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].rho = $4;
		}
	|	layer_body TC DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].tc = $4;
		}
	|	layer_body DIST2SI DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].dist2si = $4;
		}
	|	layer_body LAMBDA DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].lambda = $4;
		}
	|	layer_body TEMPLIMIT DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].templimit = $4;
		}
	|	layer_body MAXPOWER DEFINITION NUMBER	/* left recursion! */
		{
		  if (!DEBUG) Tec.layer[Tec.layers].maxpower = $4;
		}
	;

%%
