%{
/* ----------------------------------------------------------------------------
 * Copyright (C) 2000-2005 by Karim Kaschani
 * 
 * This file is part of the software xIncode developed to support the design
 * of interconnects in semiconductor technologies.
 * 
 * xIncode is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * xIncode is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ------------------------------------------------------------------------- */

#include "xincode.h"
#include "misc.h"
#include "y.tab.h"





int lineNo = 1;
void yyerror(char *s);

%}

%%

	/* -------------------------------------------------- keyword tokens */

Technology		return TECHNOLOGY;

Layer			return LAYER;

Name			return TITLE;

Material		return MATERIAL;

TechnologyType		return TYPE;

InterconnectionType	return INTERCONNECTION;

Thickness		return THICKNESS;

MinimumLayerWidth	return MINLAYERWIDTH;

MinimumViaSize		return MINVIASIZE;

ViaCoefficient		return VIACOEFFICIENT;

T50N			return T50N;

ReferenceCurrent	return REFCUR;

ReferenceTemperature	return REFTEMP;

ReferenceWidth		return REFWIDTH;

MaximumCurrentRatio	return MAXCURRATIO;

MinimumCurrentRatio	return MINCURRATIO;

Sigma			return SIGMA;

ActivationEnergy	return ENERGY;

Exponent		return EXP;

SpecificResistance	return RHO;

TemperatureCoefficient	return TC;

IsolationThickness	return DIST2SI;

ThermalConductivity	return LAMBDA;

OverheatingThreshold	return TEMPLIMIT;

MaximumPowerDensity	return MAXPOWER;

	/* ----------------------------------------------------- punctuation */

[=:]			return DEFINITION;
[\{\}\(\)\[\]]		return yytext[0];

	/* -------------------------------------------------------- techtype */

Planarized |
NonPlanarized		{
			  if (!DEBUG) {
			     if (StrCmp(yytext, "NonPlanarized") == 0)
			        yylval.ival = NONPLANARIZED;
			     else
			        yylval.ival = PLANARIZED;
			  }
			  return TECHTYPE;
			}

	/* -------------------------------------------------------- material */

Metal |
Poly |
PolySilicon		{
			  if (!DEBUG) {
			     if (StrCmp(yytext, "Metal") == 0)
			        yylval.ival = METAL;
			     else
			        yylval.ival = POLY;
			  }
			  return SUBSTANCE;
			}

	/* --------------------------------------------------------- contact */

ContactHole |
Via			{
			  if (!DEBUG) {
			     if (StrCmp(yytext, "ContactHole") == 0)
			        yylval.ival = CONTACTHOLE;
			     else
			        yylval.ival = VIA;
			  }
			  return CONTACT;
			}

	/* ---------------------------------------------------------- number */

[-+]?([0-9]+)|(([0-9]+(\.[0-9]+)?)([eE][-+]?[0-9]+)?)[afpnum kMGTPE]? {
			  if (!DEBUG) 
			     yylval.dval = str2ENG(yytext, (char **) NULL);
			  return NUMBER;
			}

	/* ------------------------------------------------------------ name */

\".*\"			{
			  if (!DEBUG) {
			     char	*s;

			     s = yytext; s++;
			     yylval.sval = strdup(s);
			     StrNCpy(yylval.sval, s, StrLen(s)-1);
			  }
			  return STRING;
			}

	/* ----------------------------------------------- ignore whitespace */

[ \t\r]+		;

	/* --------------------------------------------------- EOL character */

\n			lineNo++;

	/* --------------------------------------------------------- comment */

"#".*			;

	/* --------------------------------------------- any other character */

.			{
			  yyerror("invalid character");
			  yyrestart(yyin);
			}


%%
