/* ----------------------------------------------------------------------------
 * Copyright (C) 2000-2005 by Karim Kaschani
 * 
 * This file is part of the software xIncode developed to support the design
 * of conduction lines in semiconductor technologies.
 * 
 * xIncode is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * xIncode is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ------------------------------------------------------------------------- */





#define NUMHELP		6		/* number of help menu entries */

static char *HelpTitle[NUMHELP] = {
    "Version",
    "Introduction",
    "Configuration",
    "User Interface",
    "Parameters & Units",
    "Examples"
};

static char *HelpText[NUMHELP] = {
"xIncode Version 1.0\n\
-------------------\n\
Copyright (C) 2000-2005 by Karim Kaschani\n\
\n\
This file is part of the software xIncode developed to support the design\n\
of interconnects in semiconductor technologies.\n\
\n\
xIncode is free software; you can redistribute it and/or modify\n\
it under the terms of the GNU General Public License as published by\n\
the Free Software Foundation; either version 2 of the License, or\n\
(at your option) any later version.\n\
\n\
xIncode is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License\n\
along with this program; if not, write to the Free Software\n\
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.",

"Introduction\n\
------------\n\
xIncode is a tool to support the design of interconnects in semiconductor\n\
technologies, which are subject to electromigration or electrical over-\n\
stress. It accounts not only for single lines but also for arbitrary\n\
numbers of coupled lines in planarized and non-planarized technologies\n\
as well as for contact holes and vias. Some of its most important features\n\
are:\n\
\n\
   + Metal and polysilicon lines are accounted for\n\
   + No limitation in sigma specification\n\
   + Arbitrary combination of layers is possible\n\
   + Applicable to planarized and non-planarized technologies\n\
   + Contact holes and vias are accounted for\n\
   + Extensive on-line help available\n\
\n\
   Enjoy,\n\
\n\
   Karim Kaschani",

"Configuration\n\
-------------\n\
xIncode can be configured in 4 different ways:\n\
\n\
1. Technology Database Files\n\
\n\
   xIncode uses two kinds of technology database files. The first is named\n\
   'xIncode.db' and covers information on the name and the location of\n\
   each special technology file. The location of 'xIncode.db' is defined\n\
   at compilation time. The second kind of technology file (the special\n\
   one) holds all parameters, which are required to characterize a special\n\
   technology. The syntax of both files is explained in detail in the man\n\
   page xincode(5). The underlying theory is briefly surveyed in\n\
   xincode(7).\n\
\n\
2. Parameter Defaults\n\
\n\
   Usually the parameters 'FIT', 'Lifetime' and 'Temp.' remain constant\n\
   for a certain project. Therefore, these parameters can be saved in a\n\
   user-specific resource file '.xIncoderc' to be read the next time\n\
   xIncode is run. Unless the environment variable XINCODERCPATH is\n\
   undefined, this resource file is located in the user's HOME directory.\n\
\n\
3. Environment Variables\n\
\n\
   In order to accelerate the data entry two environment variables are\n\
   provided:\n\
\n\
   XINCODETECHFILE   defines the name and location of the special\n\
                     technology file. If this variable is defined\n\
                     (correctly), this technology file is loaded\n\
                     automatically each time xIncode is started.\n\
\n\
   XINCODERCPATH     defines the directory of the user-specific resource\n\
                     file '.xIncoderc'. If the resource file exists, it is\n\
                     loaded automatically each time xIncode is started.\n\
\n\
4. X11 Resources\n\
\n\
   The look of the user interface is set by the application defaults in\n\
   'xIncode'. These can be overridden by means of user-specific settings\n\
   in '.Xdefaults' or '.Xressources'. A detailed description is given in\n\
   the man page xincode(1).",

"User Interface\n\
--------------\n\
The user interface is divided into the menu bar and the dialog.\n\
\n\
Menu Bar\n\
--------\n\
The menu bar consists of two menus, the 'File' menu on the left and the\n\
'Help' menu on the right. While the 'File' menu is used to load a special\n\
technology file, to read and save parameter defaults to minimize and to\n\
terminate the programm, the 'Help' menu provides help for different tasks.\n\
\n\
Dialog\n\
------\n\
The dialog is divided into the 'Layer' selection field on the upper left,\n\
the parameter fields 'FIT', 'Lifetime', 'Temp.' on the upper right and the\n\
calculation fields 'Current', 'Width', 'Temp. Inc.', 'X/Y-Size', 'Y-Size',\n\
'Current', 'Calculate' on the bottom.\n\
\n\
Layer         This selection field holds all available layers of the\n\
              respective technology. Calculation is performed for each\n\
              layer that is selected. All selected layers are assumed to\n\
              share the same length and width. If none is selected all of\n\
              the other fields are disabled.\n\
\n\
FIT\n\
Lifetime\n\
Temp.         These are the reliability parameters, which are basic for\n\
              each calculation of metal lines. Validity of each entry is\n\
              checked before each calculation. Typical values are:\n\
\n\
                    0.1 < FIT      <    100\n\
                 1000   < Lifetime < 150000\n\
                   85   < Temp.    <    150\n\
\n\
Current\n\
Width\n\
Temp. Inc.    These fields are used for the design of conduction lines.\n\
              While the latter only displays the resulting temperature\n\
              increase with respect to the silicon surface due to thermal\n\
              heating, the former are both entry and display fields.\n\
              Depending on the field, which has the focus prior to hitting\n\
              'Calculate' (or RETURN) the minimum width or the maximum\n\
              current is calculated. Consequently, either 'Current' or\n\
              'Width' have to be specified (not both of them). For correct\n\
              parameter entry please have a look at 'Parameters & Units'.\n\
              If either the field 'Current' or 'Width' is cleared prior to\n\
              hitting 'Calculate' (or RETURN) all three fields are\n\
              cleared.\n\
\n\
X/Y-Size\n\
Y-Size\n\
Current       These fields are used for contact hole and via design. All\n\
              contact holes or vias are assumed to be connecting a layer,\n\
              which is nearer to the silicon surface than the selected\n\
              layer. If multiple layers are selected, calculation is\n\
              performed for that one, which is closest to the silicon\n\
              surface. Contact holes and vias are automatically recognized\n\
              by corresponding flags in the technology file. 'Current'\n\
              displays the maximum current that is allowed to flow across\n\
              the contact hole or via respectively. 'X/Y-Size' specifies\n\
              the extension in x AND y, if the calculation is started\n\
              immediately after specifying this parameter. To account for\n\
              rectangular not quadratic contact holes (vias) 'Y-Size' has\n\
              to be specified differently before hitting 'Calculate' (or\n\
              RETURN). For correct parameter entry please have a look at\n\
              'Parameters & Units'. If either the field 'X/Y-Size' or\n\
              'Y-Size' is cleared prior to hitting 'Calculate' (or RETURN)\n\
              all three fields are cleared.\n\
\n\
Calculate     This button triggers the calculation. Since the kind of\n\
              calculation depends on the calculation field, which has the\n\
              input focus prior to hitting 'Calculate' (or RETURN), this\n\
              field is remembered and the focus is returned to this field\n\
              after the calculation has concluded!\n\
\n\
In case an illegal value has been entered, xIncode pops up a corresponding\n\
error message. Furthermore, the foreground color of the corresponding text\n\
field is replaced by its highlighting color. All of the other text fields,\n\
however, remain unaffected.",

"Parameters & Units\n\
------------------\n\
Generally, calculation parameters are based on SI units. Consequently,\n\
the following specifications have to be concidered:\n\
\n\
   Distances         [m]\n\
   Current densities [A/m]\n\
\n\
Exceptions to this rule are:\n\
\n\
   Time              [h]\n\
   Temperatures      [C]\n\
   Energies          [eV]\n\
\n\
The input fields of the dialog have to be specified as follows:\n\
\n\
   Technology        []     Name of current technology,\n\
   Layer             []     Names of selectable layers,\n\
\n\
   FIT               [1]    Maximum tolerated failures in time,\n\
   Lifetime          [h]    Maximum lifetime of respective product,\n\
   Temp.             [C]   Maximum junction temperature,\n\
\n\
   Current           [A]    Effective current of selected layer,\n\
   Width             [m]    Layer width,\n\
   Temp. Inc.        [K]    Temperature increase of selected layer due to\n\
                            self-heating,\n\
   X/Y-/Y-Size       [m]    Contact hole (via) extension in x or y\n\
\n\
Nevertheless, to simplify the specification of numbers the following\n\
suffices common to engineering sciences may be used:\n\
\n\
   'a'               =      number x 1e-18\n\
   'f'               =      number x 1e-15\n\
   'p'               =      number x 1e-12\n\
   'n'               =      number x 1e-09\n\
   'u' or ''        =      number x 1e-06\n\
   'm'               =      number x 1e-03\n\
   'k'               =      number x 1e+03\n\
   'M'               =      number x 1e+06\n\
   'G'               =      number x 1e+09\n\
   'T'               =      number x 1e+12\n\
   'P'               =      number x 1e+15\n\
   'E'               =      number x 1e+18\n\
  ('?'               =      exponent out of range)\n\
\n\
In order to be accepted these suffices have to follow immediately the\n\
respective number. Any space between the number and its suffix in NOT\n\
permitted!",

"Examples\n\
-------\n\
Calculation of metal or polysilicon lines:\n\
\n\
1. Select Technology\n\
\n\
   Unless the environment variable XINCODETECHFILE is not specified before\n\
   start-up, first a technology file has to be loaded. This is achieved\n\
   by clicking on the item 'Load Technology' of the 'File' menu. Con-\n\
   sequently, a selection dialog pops up, which shows all technologies,\n\
   which are known to the program. Choose your technology by clicking on\n\
   the respective item and confirm by clicking on 'OK'.\n\
\n\
2. Select Layer(s)\n\
\n\
   The different layers of your technology are displayed in the scrolled\n\
   list 'Layer'. Choose one or more of them by scrolling and clicking on\n\
   the respective items.\n\
\n\
3. Specify Reliability Parameters\n\
\n\
   As soon as a layer is selected all other parameters are enabled. Unless\n\
   you have not saved defaults before, enter suitable values for each\n\
   reliability parameter. To traverse between the three fields use the TAB\n\
   key or your mouse cursor.\n\
\n\
4. Specify Calculation Parameters\n\
\n\
   The 3 calculation parameters 'Current', 'Width' and 'Temp. Inc.' are\n\
   purely used for design of metal or polysilicon lines. While 'Temp.\n\
   Inc.' is solely for information purposes 'Current' and 'Width' serve\n\
   either for data entry or for displaying results.\n\
\n\
   If you wish to calculate the minimum layer width for a given current,\n\
   enter the respective current in the field 'Current' and enter RETURN.\n\
   The resulting width is displayed in the field 'Width'.\n\
\n\
   However, if you want to calculate the maximum current for a given layer\n\
   width, enter the respective width in the field 'Width' and then enter\n\
   RETURN. The resulting current is now displayed in the field 'Current'.\n\
\n\
Calculation of contact holes and vias:\n\
\n\
   Follow the items 1 to 3 as described above.\n\
\n\
4. Specify Calculation Parameters\n\
\n\
   The 3 calculation parameters 'X/Y-Size', 'Y-Size' and 'Current' are\n\
   purely used for contact hole and via design. While 'Current' displays\n\
   the resulting maximum current 'X/Y-Size' and 'Y-Size' serve either for\n\
   data entry or for displaying purposes.\n\
\n\
   If you wish to calculate the maximum current for a quadratic contact\n\
   hole (via) simply enter the length of its edge in the field 'X/Y-Size'\n\
   and enter RETURN. As a result your input is copied to the field\n\
   'Y-Size' and the resulting current is displayed in the field 'Current'.\n\
\n\
   If you wish to calculate the maximum current for a rectangular contact\n\
   hole or via enter both edges first specify the field 'X/Y-Size' and\n\
   then specify the field 'Y-Size'. Make sure that 'Y-Size' has the focus\n\
   before entering RETURN! The resulting current is displayed in the field\n\
   'Current'."
};
