/* ----------------------------------------------------------------------------
 * Copyright (C) 2000-2005 by Karim Kaschani
 * 
 * This file is part of the software xIncode developed to support the design
 * of interconnects in semiconductor technologies.
 * 
 * xIncode is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * xIncode is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ------------------------------------------------------------------------- */





/* ----------------------------------------------------------------------------
 * calc.h - calculation functions
 * ------------------------------------------------------------------------- */

extern double	nlog10(double);
extern double	rho(double, double, double);
extern double	InvGauss(double, double);
extern double	FailureRate2MTF(double, double, double);
extern double	MaxCurrentDensity(LAYData, double, MIGRData);
extern RESDataL	computeMaxCurrent(TECData, MIGRData);
extern RESDataL	computeMinLayerWidth(TECData, MIGRData);
extern double	computeViaCurrent(TECData, MIGRData);
