/* this header file needs:
     math.h
     eqslvinc.h
     matrix.h
     stringn.h
*/

#include "truth.h"

//global variables

//vertical and horizontal characters
#ifdef _DOS_PLAT
char vbar = 179, hbar = 196, vhbar = 197;  //dos machine
#else
char vbar = '|', hbar = '-', vhbar = '+';  //unix or other platform
#endif

//order string only contain boolean operations to minimize overhead
char orderOp[] = "~`=!`&`|";
char trueOrder[] = "|`&`=`!`~";
char orderReplace[] = "||`&&`==`!=`!";

char *Matrix2Char(Matrix<char> *charMat)
{
  char *matrixString, tmpchar;
  int row, col, i, j, count = 0;

  row = charMat->getRow();
  col = charMat->getCol();
  matrixString = newStringAlloc( row * (col + 1) + 1);

  for (i = 0; i < row; i++)
    {
      for (j = 0; j < col; j++)
	{
	  charMat->getElement(i, j, tmpchar);
  	  matrixString[count] = tmpchar;
	  count++;
	}
      matrixString[count] = '\n';
      count++;
    }
  matrixString[count] = 0;

  return matrixString;
}

//this procedure converts base 10 number to base 2.
//parameter: string to minipulate, decimal number, size of char array
void dec2bin(char *returnBin, int decimal, int const size)
{
  int count, i;

  for (i = 0; i < size; i++) returnBin[i] = ' ';   //clear out string
  returnBin[size] = 0;													 //add terminator

  //starting from the right, count will decrement right after 0
  count = size - 1;

  //this while loop uses the division by base (2)
  //remainder (given by modulas) is the binary number
  while (decimal) {
    returnBin[count] = (char)((decimal % 2) + '0');
    decimal = decimal / 2;
    count--;
  }

  //put 0's in all the left over spaces
  for (count = 0; returnBin[count] == ' '; count++) returnBin[count] = '0';

}

Matrix<int> *createComboMatrix(int const digits)
{
  int combinations, i, j;
  char *result;
  Matrix<int> *pMat;

  combinations = (int)pow(2, digits);
  pMat = new Matrix<int>(combinations, digits);
  result = new char[digits + 1];

  for (i = 0; i < combinations; i++) {
    dec2bin(result, i, digits);
    for (j = 0; j < digits; j++)
      pMat->setElement(i, j, result[j] - '0');
  }

  delete [] result;

  return pMat;
}

//=--------------

TruthTable::TruthTable(char *orderP)
{
  comboMat = resultMat = 0;
  prepareEquationsDone = prepareMatricesDone = numEquations = 0;
  masterVarList = 0;

  if (orderP) strcpy(order.user, orderP);
  else strcpy(order.user, usrDefOrDBool);

  strcpy(order.order, orderDBool);
  strcpy(order.real, realDefOrDBool);

  equList = new EquList<equNode>;
  newObjectAlloc(vars);
}

TruthTable::~TruthTable()
{
  if (comboMat) delete comboMat;
  if (resultMat) delete resultMat;
  if (masterVarList) delete [] masterVarList;
  delete equList;
}

int TruthTable::prepareEquations(equFormatType format, char const *expression)
{
  int i, equalPos;
  char *expTok, *expN, *endExp = 0;

  expTok = newStringCopy(expression);
  removeWhiteSpace(expTok);

  expN = strtok(expTok, ";");//findChar(expression, ';');

  for (i = 1; expN; i++)
    {
      equalPos = findChar(expN, '=', 0);

      //skip logical ==;
      if ((equalPos != -1) && (expN[equalPos + 1] == '=')) equalPos = -1;

      //if = sign is not in letter = equation format
      if ( (equalPos != -1) && (equalPos != 1) )
	{
	  char *tmp;
	  tmp = nonFatalErr("Variable must be letter.\n", expN, 1);
  	  errorMsg << tmp;
	  delete [] tmp;
	  return 1;
	}

      //if found an = sign or format is short type
      if ( (format == SHORTEQU) || (equalPos != -1) )
  	{
	  char *tmpExp = 0, passVar[5];

	  if (equalPos == 1)		//did find an equal sign
	    {
	      tmpExp = newStringCopy(expN);
	      passVar[0] = expN[0];//varible to view in truth table
	      passVar[1] = 0;

	      deleteChar(tmpExp, 0);				//delete variable letter
	      deleteChar(tmpExp, 0);				//delete equal sign
	    }
	  if (format == SHORTEQU)					//short format
	    {
	      passVar[0] = 'E';							//make generic variable EXX (xx = int)

	      if (i > 9)
		{
		  passVar[1] = '1';
		  passVar[2] = '0' + i - 10;
		  passVar[3] = 0;
		}
	      else
		{
		  passVar[1] = i + '0';
		  passVar[2] = 0;
		}
	    }

	  //make node and pass variable name
	  //append new string to end expression
	  if (!tmpExp)           								//if did find an equal sign
	    {
	      appendString(endExp, expN);
	      insertNode(expN, passVar);
	    }
	  else																	//if no equal sign was found
	    {
	      appendString(endExp, tmpExp);
	      insertNode(tmpExp, passVar);
	    }

	  //if (tmpExp) delete [] tmpExp;
	} //end if
      else  //if no equal sign was found and this is in long equation type
	{
	  insertNode(expN, expN);
	  appendString(endExp, expN);
	}

      numEquations++;
      expN = strtok(0, ";");
    }

  masterVarList = extractVariables(endExp);
  vars->initialize((unsigned char *)masterVarList, NONCONST);

  if (parseNodes()) return 1;

  prepareEquationsDone = 1;

  delete [] expTok;
  //delete [] endExp;

  return 0;
}

int TruthTable::prepareMatrices()
{
  int row, col, j, varsWidth, matLength;
  equNode *scanNode = equList->head;
  int tmpVar;

  prepareMatricesDone = 0;

  if (!prepareEquationsDone)
    {
      errorMsg << "Equation(s) are not yet pre-evaluated.\n";
      return 1;
    }

  //set length vars,
  varsWidth = strlen(masterVarList);
  comboMat = createComboMatrix(varsWidth);

  matLength = comboMat->getRow();

  resultMat = new Matrix<int>(matLength, numEquations);

  for (row = 0; row < matLength; row++) //row = row
    {
      //set variables
      for (j = 0; j < varsWidth; j++)
	{
	  comboMat->getElement(row, j, tmpVar);
	  vars->setValue(masterVarList[j], tmpVar);
	}

      //solve each equation in this row (going across column)
      scanNode = equList->head;
      for (col = 0; col < numEquations; col++)
	{
	  scanNode->solveEquation(tmpVar);
	  resultMat->setElement(row, col, tmpVar);
	  scanNode = scanNode->next;
	}
    }

  prepareMatricesDone = 1;

  return 0;
}

//return error level
int TruthTable::parseNodes()
{
  int i, maxNodes = equList->getNodeCount();
  equNode *scanNode = equList->head;

  for (i = 0; i < maxNodes; i++)
    {
      //equ->getNode(tmpNode, i);
      if (!scanNode->parseEquation()) return 1;
      scanNode = scanNode->next;
    }
  return 0;
}

void TruthTable::insertNode(char *expression, char *equName)
{
	equNode *newNode;

	if (!(newNode = new EquSolveBool<int>(expression, vars, &errorMsg,
	  &order, equName) )) fatalErr ();

	equList->insertNodeAtEnd(newNode);
}

Matrix<char> *TruthTable::makeCharMatrix(int start, int end)
{
  Matrix<char> *charTable;
  //StringNode *scanName = equNameHead, *nameHead;
  equNode *scanNode = equList->head, *equHead;
  StringNode tmpString;

  int i, j, col, row, comboMarker, *varMark, varMax, count, oldpos, midpos, tmpVar;
  char *tmpEqu;

  col = 0;
  numEquations = end - start;
  equHead = equList->getNodePtr(start);

  //find column width needed for new character matrix
  for (i = 0; i < numEquations; i++)
    {
      scanNode->getEquName(tmpString);
      col += tmpString.doStrlen() + 3;
      scanNode = scanNode->next;
    }

  varMax = strlen(masterVarList);
  varMark = new int[numEquations];
  comboMarker = comboMat->getCol() * 2; //* 2 for vbars
  row = comboMat->getRow();
  col += comboMarker - 1;		    //add on space for combo vars

  //new it with 2 rows extra for equations and horizontal line
  charTable = new Matrix<char>(row + 2, col);

  //setup variable portion of first line of char matrix with variable names
  //(or short names)and second line which is a bar with apropriate characters
  for (i = 0; i < varMax; i++)
    {
      charTable->setElement(0, i * 2, masterVarList[i]);
      charTable->setElement(0, i * 2 + 1, vbar);

      //character bar underneath variable names
      charTable->setElement(1, i * 2, hbar);
      charTable->setElement(1, i * 2 + 1, vhbar);
    }

  count = comboMarker;
  scanNode = equHead;

  //write expression strings in char matrix with virtical bars inbetween
  for (i = 0; i < numEquations; i++)
    {
      scanNode->getEquName(tmpString);
      tmpEqu = tmpString.getString();
      insertChar(tmpEqu, ' ', strlen(tmpEqu));
      insertChar(tmpEqu, ' ', 0);

      for (j = 0; (size_t)j < strlen(tmpEqu); j++)
	{
	  charTable->setElement(0, count, tmpEqu[j]);
	  charTable->setElement(1, count, hbar);
	  count++;
	}

      charTable->setElement(0, count, vbar);
      charTable->setElement(1, count, vhbar);
      varMark[i] = count;
      count++;
      scanNode = scanNode->next;
      delete [] tmpEqu;
    }

  //write combo values in char matrix
  for (i = 0; i < row; i++) {
    for (j = 0; j < varMax; j++)
      {
    	comboMat->getElement(i, j, tmpVar);
	charTable->setElement(i + 2, j * 2, tmpVar + '0');
	charTable->setElement(i + 2, j * 2 + 1, vbar);
      }
  }

  //write out result data to char matrix
  for (i = 0; i < row; i++)
    {
      //put spaces to cover the NULL's on result section of matrix
      for (j = comboMarker; j < col; j++)
	charTable->setElement(i + 2, j, ' ');

      oldpos = comboMarker - 1;
      for (j = 0; j < numEquations; j++)
	{
	  midpos = (varMark[j] - oldpos) / 2;

	  resultMat->getElement(i, j + start, tmpVar);
	  charTable->setElement(i + 2, midpos + oldpos, tmpVar + '0');

	  charTable->setElement(i + 2, varMark[j], vbar);
	  oldpos = varMark[j];
	}
    }

  delete [] varMark;
  return charTable;
}

char *TruthTable::getTruthTable(int screen_width = DEFAULT_SCREEN_WIDTH)
{
  Matrix<char> *charMatrix;
  //EquSolveBool<int> *scanNode = equHead;
  //StringNode *scanNode = equNameHead, stringHolder;
  equNode *scanNode = equList->head;
  char *tmpString;
  StringNode tmpStrNode, stringHolder;

  int i, countCol, start = 0, varMax, numNodes;

  if (!prepareMatricesDone)
    {
      errorMsg << "Matricies are not prepared.\n";
      return 0;
    }

  varMax = strlen(masterVarList);
  countCol = varMax * 2;

  //for (numNodes = 0; scanNode; numNodes++) scanNode = scanNode->next;
  //scanNode = equNameHead;
  numNodes = equList->getNodeCount();


  //find column width needed for new character matrix
  for (i = 0; i < numNodes; i++)
    {
      scanNode->getEquName(tmpStrNode);
      countCol += tmpStrNode.doStrlen() + 3;

      if (countCol > screen_width)
	{
	  charMatrix = makeCharMatrix(start, i);

	  tmpString = Matrix2Char(charMatrix);
	  stringHolder << tmpString;
	  delete [] tmpString;
	  delete charMatrix;

	  start = i;

	  scanNode->getEquName(tmpStrNode);
	  countCol = varMax * 2 + tmpStrNode.doStrlen() + 3;
	}

      scanNode = scanNode->next;
    }

  charMatrix = makeCharMatrix(start, i);
  tmpString = Matrix2Char(charMatrix);
  stringHolder << tmpString;
  delete [] tmpString;

  delete charMatrix;
  return stringHolder.getString();
}
