//Program: trfunc.cc
//Written by Paul Landes (landes@jove.acs.unt.edu)
//on Wed 10/15/97 22:45:52

//Copyright (C) 1997, 1998 by Paul Landes. This code/program is free
//software; you can redistribute it and/or modify it under the terms
//of the GNU General Public License as published by the Free Software
//Foundation; either version 2 of the License, or (at your option) any
//later version.

#include <trtab.h>

main(int argc, char **argv)
{
  char *equationPtr, *usroperators;
  trtabOp op(argv);

  usroperators = setupFiles(&op);
  if (op.quiet == false) printIntro();

  if (op.batchFn.empty() == false) {
    if (op.quiet == false) 
      cout << "processing file " << op.batchFn << endl;
    return executeFile(op.batchFn.c_str(), usroperators, &op);
  }

  if (op.equation.empty() == false) {
    if (op.quiet == false) 
      cout << "processing equation(s) " << op.equation << endl;
    doEquation((char*)op.equation.c_str(), usroperators, &op);
    return 0;
  }
  read_historyAlias((char*)op.historyFn.c_str());

  for(;;) {
    equationPtr = getEqus(op.prompt);
    if (strlen(equationPtr) == 0) continue;
    else if (strcasecmp(equationPtr, "warranty") == 0) {
      printWarranty();
      free(equationPtr);
      continue;
    }
    else if ( (strcasecmp(equationPtr, "quit") == 0) ||
	 (strcasecmp(equationPtr, "bye") == 0) ||
	 (strcasecmp(equationPtr, "exit") == 0) ) break;
    else if (strcasecmp(equationPtr, "help") == 0) {
      printHelp();
      continue;
    }

    doEquation(equationPtr, usroperators, &op);
    add_historyAlias(equationPtr);
  }

  write_historyAlias((char*)op.historyFn.c_str());

  return 0;
}

