#include "strmanip.h"

//This function deletes the character at 'pos' in *oldString.
//The function deletes the old string and changes a pointer to it.
//CAUTION: ONLY use this function with string pointers that CAN be deleted!
void deleteChar(char *&oldString, int pos)
{
  int i, maxLen;
  char *newString;

  //for run-time programming errors
  if (pos > (int)strlen(oldString))		
    fatalErr ("pos > length of oldString in 'deleteChar'");

  //create space for new string
  maxLen = strlen(oldString);
  newString = newStringAlloc(maxLen);

  //copy first part (0 - 'pos')
  for(i = 0; i < pos; i++) newString[i] = oldString[i];

  //copy second part ('pos' - end of string)
  for(i = pos; oldString[i] != 0; i++) newString[i] = oldString[i + 1];
  //newString[maxLen - 1] = 0;

  delete [] oldString;  		//delete old string
  oldString = newString;    //re-assign oldString to NEWed string
}

//This function inserts the character at 'pos' in *oldString.
//CAUTION: ONLY use this function with string pointers that CAN be deleted!
void insertChar(char *&oldString, char insertChar, int pos)
{
  if ((size_t)pos > strlen(oldString))
    fatalErr ("pos > length of oldString in 'insertChar'");

  int i, maxLen;
  char *newString;

  maxLen = strlen(oldString);
  newString = new char[maxLen + 3]; //is this really spose to be '+3'?

  for(i = 0; i < pos; i++) newString[i] = oldString[i];
  newString[pos] = insertChar;
  for(i = pos; oldString[i] != 0; i++) newString[i + 1] = oldString[i];
  newString[maxLen + 1] = 0;

  delete [] oldString;
  oldString = newString;
}

//function finds 'character' in *string starting at pos
//return value is position of found char on success; -1 on failure
int findChar(char const *string, char const character, int const pos)
{
  int i;
  for (i = pos; (string[i] != character); i++)
    if (string[i] == 0) return -1;

  return i;
}

//Function finds *lookfor in *string starting at element pos and returns the
//position in it is found.  If it does not find it, return value is -1.
int findString(char const *string, char const *lookfor, int pos)
{
  int maxlen = strlen(string), i;

  //programmer's run-time error
  if (pos > maxlen) fatalErr("pos > maxlen in findString().");

  //look for the matching string up to the end of *string
  while (pos < maxlen)
    {
      //check to see if *string starting at pos matches lookfor
      for (i = 0; string[pos + i] == lookfor[i]; i++);
      //if NULL then end of lookfor was reached the the string matches
      if (lookfor[i] == 0) return pos;

      //if the first characters did not match advance position by 1
      //otherwise, advance position where the strings differed
      if (i == 0) pos++;
      else pos += i;
    }

  return -1;			//return exit failure
}

//this function returns a 1 if the char passed is a number or 0 if not
int checkNumeric(char e)
{
  if ( e == '.' || (e >= '0') && (e <= '9') ) return 1; //number
  return 0;		//not a number
}

//Function returns a char pointer to NEWed space allocated (0 on fail) that
//contains a character representation of a positive float.  *e is an
//expression that contains the float, pos is the position in e of the float
char *extractValChar(char const *e, int &pos)
{
  int i, maxlen;
  char *newString;

  for (i = pos; checkNumeric(e[i]) ; i++)  //find length of number (maxlen)
    maxlen = i - pos + 1;

  //return fail if not a number or number is only 1 digit
  if (maxlen <= 1) return 0;
  newString = newStringAlloc(maxlen + 1);

  //copy over string
  for (i = 0; i < maxlen; i++) newString[i] = e[pos + i];
  newString[i] = 0;													//add null terminating char
  //pos = last position of number in e
  pos = i;

  return newString;
}

//return -1 on fail, long string representation on success
//pos will be set to the index in the string after the current number
int extractInt(char *str, int &pos)
{
  char *getInt;
  int returnVal, oldPos = pos;

  //exit fail if not a vailid starting char representation of a double
  if ( (str[pos] < '0') || (str[pos] > '9') ) return -1;
    
  getInt = extractValChar(str, pos);
  if (!getInt) {
    returnVal = (int)(str[pos] - '0');
    pos = 1;
  }
  else returnVal = (int)strtod(getInt, 0);

  delete [] getInt;
  pos += oldPos;
  return returnVal;
}

//__________________less used functions________________________

//same as CheckAlpha but checks for numerical chars also
int checkAlphaN(char const character)
{
    if ( ((character >= 'A') && (character <= 'Z')) ||
	 ((character >= 'a' ) && (character <= 'z')) ||
	 ((character >= '0') && (character <= '9')) ) return 1;
    else return 0;
}

//This function returns a 1 if the passed char is part of the alphabet.
//Else, it returns a 0.
int checkAlpha(char const character)
{
    if ( ((character >= 'A' ) && (character <= 'Z')) ||
	 ((character >= 'a' ) && (character <= 'z')) )
	return 1;

    else return 0;  //exit failure--not alpha
}

//Function replaces N characters in one string with another string
//parameters: oldString = string to be modified; toReplace = source;
//startPos = position to start replacing, endPos = end position to replace
//CAUTION: ONLY use this function with string pointers that CAN be deleted!
void replaceBlock(char *&oldString,
  char const *toReplace, int startPos, int endPos)
{
  int i, maxReplace, maxNewString;
  char *newString;

  //find new length of the string that will be modified
  maxReplace = strlen(toReplace);
  maxNewString = startPos + strlen(toReplace) +
    (strlen(oldString) - endPos);

  newString = newStringAlloc(maxNewString);

  //copy first part of string
  for (i = 0; i < startPos; i++) newString[i] = oldString[i];
  //copy add on string that is being inserted
  for (i = 0; i < maxReplace; i++) newString[i + startPos] = toReplace[i];
  //copy the rest of string (from endPos to end of oldstring)
  for (i = 0; oldString[i + endPos] != 0; i++)
    newString[i + startPos + maxReplace] = oldString[i + endPos + 1];

  newString[maxNewString] = 0;	//add null termininating char
  delete [] oldString;					//free space
  oldString = newString;				//re-assign string
}

//same as the other replaceBlock function, except this function allows
//replacing a char in a string
//CAUTION: ONLY use this function with string pointers that CAN be deleted!
void replaceBlock(char *&oldString, char toReplace, int startPos, int endPos)
{
  char tmpStr[2];
  tmpStr[0] = toReplace;
  tmpStr[1] = 0;
  replaceBlock(oldString, tmpStr, startPos, endPos);
}

//This function removes spaces from a string and modifies the pointer passed
//to point at a NEWed string.
//CAUTION: ONLY use this function with string pointers that CAN be deleted!
void removeWhiteSpace(char *&oldString)
{
  char *newString;
  int pos = 0;

  //delete blank characters found
  while ( (pos = findChar(oldString, ' ', pos)) != -1)
    deleteChar(oldString, pos);

  newString = newStringCopy(oldString);	//copy over the string
  delete [] oldString;                  //free space
  oldString = newString;	//re-assign pointer (call by ref.)
}
