#include "stringn.h"

//put this function in a different include
//this function returns the number of digits passed to it
int computeNumDigits(const long num)
{
  if (num == 0) return 0;
  return computeNumDigits(num / 10) + 1;
}

//converts the integer passed to a NEWed string.
char *int2str(long i)
{
  int count, remainder, size;
  char *cNum, neg;
  //size -= 1;

  //convert i to a pos number and record it if a neg number
  if (i < 0)
    {
      neg = 1;
      i *= -1;
    }
  else neg = 0;

  size = computeNumDigits((long)i) + neg;
  cNum = newStringAlloc(size);
  cNum[0] = ' ';

  //if i = 0, return a "0" for string
  if (i == 0) {
    cNum[0] = '0';
    cNum[1] = 0;
    return cNum;
  }

  //clear out string and set last character to NULL
  for (count = 0; count < size - 1; count++) cNum[count] = ' ';
  cNum[size] = 0;

  //put digits in string from right to left starting at the end
  for (count = size - 1; i != 0; count--)
    {
      remainder = i % 10;
      i = i / 10;
      cNum[count] = '0' + remainder;  //convert digit to character
    }
  if (neg) cNum[0] = '-';

  //move the digits in character string to start of string
  i = count;
  //for (count2 = i; cNum[0] == ' '; count2--)
  //for (count = 0; cNum[count] != NULL; count++)
  //cNum[count] = cNum[count + 1];

  return cNum;
}

//This function appends one string to another like strcat execpt it does
//it dynamically. return value: 1 = exit success; 0 = exit failure
//destination = *appendTo; source = *toCopy.
//CAUTION: ONLY use this function with string pointers that CAN be deleted!
int appendString(char *&appendTo, const char *toCopy)
{
  char *tmpString;

  if (!toCopy) return 0;		//exit failure if source is NULL

  //if the destination is empty, copy source to dest (append nothing)
  if (appendTo == 0) appendTo = newStringCopy(toCopy);
  else	//else add on source to destination
    {
      //new the string with lengths of both strings
      tmpString = newStringAlloc(strlen(appendTo) + strlen(toCopy) + 1);

      //copy source to tmp string, add on destination
      strcpy(tmpString, appendTo);
      strcat(tmpString, toCopy);

      delete [] appendTo;	 //delete old string
      appendTo = tmpString;	 //re-assign new string (called by reference)
    }
  return 1;			 //exit success
}

//constructor sets string pointers to NULL
StringNode::StringNode(const char *beginString)
{
  if (beginString) String = newStringCopy(beginString);
  else String = 0;
  next = 0;
}

//destructor frees up memory
StringNode::~StringNode()
{
  if (String) delete [] String;
}

//function sets *String to passed *newString
void StringNode::setString(char const *newString)
{
  if (String) delete [] String;
  String = newStringCopy(newString);
}

//function creates a string from the char passed and sets String to it
void StringNode::setString(const char toCopy)
{
  char tmp[2];
  tmp[0] = toCopy;
  tmp[1] = 0;
  setString(tmp);
}

//returns a pointer to a COPY of internal data
char *StringNode::getString() const
{
  return newStringCopy(String);
}

//function is used with << operators.  Adds to the string
void StringNode::appendStringNode(const char *toCopy)
{
  appendString(String, toCopy);
}

//function adds a char to the end of String
void StringNode::appendStringNode(const char toCopy)
{
  char tmp[2];
  tmp[0] = toCopy;
  tmp[1] = 0;
  appendStringNode(tmp);
}

//overloaded operator for StringNode << char *;
StringNode &StringNode::operator<<(char const *addString)
{
  appendStringNode(addString);
  return *this;			//for concatenation purposes
}

//overloaded operator for StringNode << char;
StringNode &StringNode::operator<<(char const addString)
{
  appendStringNode(addString);
  return *this;
}

//overloaded operator for StringNode = StringNode;
StringNode &StringNode::operator=(StringNode const &toCopyFrom)
{
  //clears THIS string and copies from toCopyFrm
  char *tmp;
  tmp = toCopyFrom.getString();
  setString(tmp);
  delete [] tmp;
  return *this;  //enables concatination
}

//enables strType = ["string" | *string;]
StringNode &StringNode::operator=(const char *newString)
{
  setString(newString);
  return *this;
}

//enables StringNode = long = ...
StringNode &StringNode::operator=(const long number)
{
  char *string;
  if (!number)
    {
      if (String)
	{
	  delete [] String;
	  String = 0;
	}
    }
  else
    {
      string = int2str(number);
      setString(string);
      delete [] string;
    }
  return *this;
}

//enables StringNode << long << ...
StringNode &StringNode::operator<<(const long number)
{
  char *string;
  string = int2str(number);

  appendStringNode(string);
  delete [] string;
  return *this;
}

//overloaded stream extraction/insertion operators for StringNode
StringNode &operator<<(StringNode &appendTo, StringNode const &copyFrom)
{
  appendTo.appendStringNode(copyFrom.getString());
  return appendTo;	          	//enables concatenation
}

//overloaded stream extraction/insertion operators for cin >> and cout <<
ostream &operator<<(ostream &coutObject, StringNode &outStringNode)
{
  coutObject << outStringNode.String;
  return coutObject;    //enables concatenation
}

//overloaded stream extraction/insertion operators for cin >> and cout <<
ostream &operator<<(ostream &coutObject, StringNode *outStringNode)
{
  //output private data string
  if (outStringNode)
    coutObject << *outStringNode;
  return coutObject;         //enables concatenation
}
