#ifndef _VARLIST_H
#define _VARLIST_H

#include <erralloc.h>

enum constType { CONST, NONCONST, NONE };

//variable node
template <class T>
struct evalVariables
{
	unsigned char letter;
	T value;
};

//no error checking here! watchout! if letter = NULL, toChange.letter
//are untouched
template <class T>
void copyPtr2EvalVar(const evalVariables<T> *toChange, int pos, int end,
	const char *letters, const T *values)
{
  int i;

  for (i = pos; i < end; i++) {
	if (letters) {
	  toChange[i].letter = letters[i];
	  toChange[index].value = values[i];
	}
	else toChange[i].tmpVars = 0;
	
	if (type != NOSET) {
	  if (type == CONST) toChange[i].constant == 1;
	  else toChange[i].constant == 0;
	}

  }
}

//_______________________________class VarList_____________________
template <class T>
class VarList
{
	public:
	VarList();
	~VarList();

	VarList<T> &operator=(VarList<T> const &);
	int initialize(const unsigned char *, constType, const T * = 0);

	//const object can call this function
	int getValue(const unsigned char, T &toGet) const;

	//no data can be changed with const objects
	const int setValue(const char *, const T *);
	const int setValue(const char, const T &);

	constType getConstType(const unsigned char) const;
	//unsigned char getNextHighConstVar();


	private:
	int findLetterIndex(const unsigned char, constType = NONE) const;

	evalVariables<T> *var;
	evalVariables<T> *varConst;
	int numVars, numVarsConst;
};

template <class T>
VarList<T>::VarList()
{
	var = 0;
	varConst = 0;
}

template <class T>
VarList<T>::~VarList()
{
 if (var) delete [] var;
 if (varConst) delete [] varConst;
}

//returns a 0 on success, 1 on fail
template <class T>
int VarList<T>::initialize(const unsigned char *letters, constType type,
	const T *values)
{
	int i;

	if (type == NONCONST)
	{
		if (var) return 1; 						//return fail
		//for (numVars = 0; letters[numVars] != 0; numVars++); //this is strlen
		numVars = strlen((char *)letters);
		//newObjectAlloc(var, numVars);
    var = new evalVariables<T>[numVars];

		for (i = 0; i < numVars; i++)
		{
			//return fail if variable already exists as a constant variable
			if ( (varConst) && ( findLetterIndex(letters[i], CONST) != -1 ) ) return 1;
			var[i].letter = letters[i];
			if (values) var[i].value = values[i];
			else var[i].value = 0;
		}
	}
	else if (type == CONST)
	{
		if (varConst) return 1; 			//return fail
		//for (numVarsConst = 0; letters[i] != 0; numVarsConst++);
		numVarsConst = strlen((char *)letters);
		//newObjectAlloc(varConst, numVarsConst);
    varConst = new evalVariables<T>[numVarsConst];

		for (i = 0; i < numVarsConst; i++)
		{
			//return fail if variable already exists as a volitile variable
			if ( (var) && ( findLetterIndex(letters[i], NONCONST) != -1 ) ) return 1;
			varConst[i].letter = letters[i];
			if (values) varConst[i].value = values[i];
			else varConst[i].value = 0;
		}
	}
	else return 1;

	return 0;												//exit sucess
}

template <class T>
VarList<T> &VarList<T>::operator=(VarList<T> const &copyFrom)
{
	int i;
	numVars = copyFrom.numVars;
  if (var) delete [] var;
	//newObjectAlloc(var, numVars);
  if (!(var = new evalVariables<T>[numVars])) fatalErr();
  for (i = 0; i < numVars; i++) var[i] = copyFrom.var[i];
  return *this;		//for concatenation
}

//returns a 0 on success, 1 on fail
template <class T>
int VarList<T>::getValue(const unsigned char letter, T &toGet) const
{
  int index;

  index = findLetterIndex(letter, CONST);

  if (index != -1) toGet = varConst[index].value;
  else
    {
      index = findLetterIndex(letter, NONCONST);
      if (index != -1) toGet = var[index].value;
      else return 1;
    }

  return 0;
}

//return 0 on success, 1 on failure.
template <class T>
const int VarList<T>::setValue(const char *letters, const T *values)
{
	int i, err, maxLetters;

	maxLetters = strlen(letters);

	for (i = 0; i < maxLetters; i++)
	{
		err = findLetterIndex(letters[i], NONCONST);

		//if variable does not exist, exit fail
		if (err == -1) return 1;
		else var[err].value = values[i];
	}

	return 0;
}

//return 0 on success, 1 on failure.
template <class T>
const int VarList<T>::setValue(const char letter, const T &value)
{
	char *tmpChar;
	int err;

	tmpChar = new char[2];
	tmpChar[0] = letter;
	tmpChar[1] = 0;

	err = setValue(tmpChar, &value);

	delete [] tmpChar;

	return err;
}

//returns a -1 on fail, index on success
template <class T>
int VarList<T>::findLetterIndex(const unsigned char letter, constType type) const
{
	int i;

	if ( ((type == NONCONST) || (type == NONE)) && (var) )
	{
		for (i = 0; i < numVars; i++)
			if (var[i].letter == letter) return i;
	}
	if ( ((type == CONST) || (type == NONE)) && (varConst) )
	{
		for (i = 0; i < numVarsConst; i++)
			if (varConst[i].letter == letter) return i;
	}

	return -1;
}

template <class T>
constType VarList<T>::getConstType(const unsigned char letter) const
{
	int i;

	for (i = 0; i < numVars; i++)
		if (var[i].letter == letter) return NONCONST;

	for (i = 0; i < numVarsConst; i++)
		if (varConst[i].letter == letter) return CONST;

  return NONE;
}

/*template <class T>
unsigned char VarList<T>::getNextHighConstVar()
{
	unsigned char lookFor = 255;

	while (findLetterIndex(lookFor, CONST) != -1)
		lookFor--;
	return lookFor;
}*/


#endif


/*
template <class T>
int VarList<T>::appendVar(const char *letters, const T *values,
  evalVariables<T> &appendTo constType type)
{
	int numLetters, numTotal, index;
  evalVariables<T> *tmpVars;

  for(numLetters = 0; letters[numLetters] != 0; numLetters++);

  if (vars)  //append variables
	{
		newObjectAlloc(tmpVars, numVars + numLetters);
		copyEvalVariables(letters, values, NOSET, tmpVars, vars, 0, numVars);
		copyEvalVariables(letters, values, type,
		  tmpVars, vars, numVars, numVars + numLetters);
  }
  else			//variables already exist
	{
		newObjectAlloc(tmpVars, numLetters);
		copyEvalVariables(letters, values, type, tmpVars, vars, 0, numLetters);
	}

  if (vars) delete vars;
  vars = tmpVars;
}
*/
