/*
------------------------------------------------------------
Header file: truth.h
Written by Paul Landes (landes@jove.acs.unt.edu)
on Sat 10/4/97 19:44:59

Copyright (C) 1997 by Paul Landes. This code/program is free 
software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software 
Foundation; either version 2 of the License, or (at your option) any 
later version. 

This header file contains 

Unless otherwise stated at the beginning of each member function,
all functions return standard error status: 1 on fail, 0 on success.
------------------------------------------------------------
*/

#ifndef _TRUTH_H
#define _TRUTH_H

#include <math.h>
#include <matrix.h>
#include <stringn.h>
#include <equsolve.h>
#include <linkedl.h>

//screen width for displaying truth tables default
#define DEFAULT_SCREEN_WIDTH 79

//enumerated values
enum equFormatType { LONGEQU, SHORTEQU };

char *Matrix2Char(Matrix<char> *charMat);
void dec2bin(char *returnBin, int decimal, int const size);
Matrix<int> *createComboMatrix(int const digits);


//typedef EquSolveBool<int> equNode;
#define equNode EquSolveBool<int> 

class TruthTable;

template <class T>
class EquList : public LinearLinkedList<T>
{
  friend TruthTable;
public:
  EquList():LinearLinkedList<T>() {};
};

//___________________________class TruthTable__________________________
//template <class equNode>
class TruthTable
{
public:
  TruthTable(char * = 0);
  ~TruthTable();
  char *getErrorMsg() { return errorMsg.getString(); }
  int prepareEquations(equFormatType, const char *);
  int prepareMatrices();
  int parseNodes();
  char *getTruthTable(int = DEFAULT_SCREEN_WIDTH);

private:
  Matrix<char> *makeCharMatrix(int, int);
  void insertNode(char *, char *);

  int prepareEquationsDone, prepareMatricesDone, numEquations;
  char *masterVarList;

  orderDef order;
  StringNode errorMsg;
  EquList<equNode> *equList;
  Matrix<int> *comboMat, *resultMat;
  VarList<int> *vars;
};


#endif
