/*
------------------------------------------------------------
Header file: trtab.h
Written by Paul Landes (landes@jove.acs.unt.edu)
on Wed 10/15/97 22:45:19

Copyright (C) 1997 by Paul Landes. This code/program is free 
software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software 
Foundation; either version 2 of the License, or (at your option) any 
later version. 

This header file contains a class for the command line options,
version number, file/directory names, default values and funtion
prototypes.

Unless otherwise stated at the beginning of each member function,
all functions return standard error status: 1 on fail, 0 on success.
------------------------------------------------------------
*/

#ifndef _TRTAB_H
#define _TRTAB_H

#include <stdio.h>
#include <string.h>
#include <iostream.h>

#include <string.h>
#include <map.h>

#include <truth.h>
#include <readln.h>

#include <bool.h>

#define LINE_SIZE 80
#define FN_MAX 150

#define VERSION "v1.2 (Nov 15, 1999)"
#define USAGE "
usage: trtab [ -e, --equation equation ] [ -w, --width width ]
             [ -b, --batchfile filename ] [ -d, --dir directory ]
             [ -q, --quiet ] [ -h, --help ] [ -v, --version ]
"
#define DEFAULT_DIR ".trtab/"
#define DEFAULT_OPT "trtab_options"
#define DEFAULT_HIS "trtab_history"

#include <cmdop.h>

class trtabOp : public ZCmdop
{
public:
  trtabOp(char **argv);
  bool quiet;
  int width;
  string equation, batchFn, dirN, historyFn, optionsFn;
  char operators[80], prompt[50];

private:
  const string help, ver;
};

void printUsage(int ecode, char *msg = 0, bool showIntro = true);
void printWarranty();
void printHelp();
void printIntro(FILE *std = stdout);
int doEquation(char *equationPtr, char *ops, const trtabOp *op);
int readOptions(char *filename, trtabOp *op);
int generateOpFile(char *filename);
void copyVar(char *cstring, string str);
char *setupFiles(trtabOp *op);
int executeFile(const char *filename, const char *usroperators,
		const trtabOp *op);

#endif
