/*
------------------------------------------------------------
Header file: strmanip.h
Written by Paul Landes (landes@jove.acs.unt.edu)
on Sat 10/4/97 19:05:42

Copyright (C) 1997 by Paul Landes. This code/program is free 
software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software 
Foundation; either version 2 of the License, or (at your option) any 
later version. 

This header file contains 

Unless otherwise stated at the beginning of each member function,
all functions return standard error status: 1 on fail, 0 on success.
------------------------------------------------------------
*/

#ifndef _STRMANIP_H
#define _STRMANIP_H

#include <erralloc.h>

void deleteChar(char *&oldString, int pos);
void insertChar(char *&oldString, char insertChar, int pos);
int findChar(char const *string, char const character, int const pos);
int findString(char const *string, char const *lookfor, int pos);
int checkNumeric(char e);
char *extractValChar(char const *e, int &pos);
int extractInt(char *str, int &pos);
int checkAlphaN(char const character);
int checkAlpha(char const character);
void replaceBlock(char *&oldString,
  char const *toReplace, int startPos, int endPos);
void replaceBlock(char *&oldString, char toReplace, 
		  int startPos, int endPos);
void removeWhiteSpace(char *&oldString);

#endif
