/*
------------------------------------------------------------
Header file: stringn.h
Written by Paul Landes (landes@jove.acs.unt.edu)
on Sat 10/4/97 19:19:22

Copyright (C) 1997 by Paul Landes. This code/program is free 
software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software 
Foundation; either version 2 of the License, or (at your option) any 
later version. 

This header file contains prototypes for the string object.

Unless otherwise stated at the beginning of each member function,
all functions return standard error status: 1 on fail, 0 on success.
------------------------------------------------------------
*/

#ifndef _STRINGN_H
#define _STRINGN_H

#include <erralloc.h>

int computeNumDigits(const long num);
char *int2str(long i);
int appendString(char *&appendTo, const char *toCopy);

//___________________________class StringNode__________________________
//this class is a data object of an array of type char.  Overloaded
//operators input and output with stream extraction/insertion operators
class StringNode
{
  //overloaded friend function operators
  friend StringNode &operator<<(StringNode &, StringNode const &);
  friend ostream &operator<<(ostream &, StringNode &);
  //friend istream &operator>>(istream &, StringNode &);
  friend ostream &operator<<(ostream &, StringNode *);

public:
  StringNode(const char * = 0);
  virtual ~StringNode();

  char *getString() const;	//returns a pointer to a copy of the string
  int stringExists() { return !String ? 0 : 1; }

  //static string manipulation on passed strings only
  char *doStrcpy(char *toCpy) const { return strcpy(toCpy, String); }
  char *doStrcat(char *toCat) const { return strcat(toCat, String); }

  //returns the length of the string
  size_t doStrlen() { return strlen(String); }

  //overloaded member function operators
  //enables strType = ["string" | *string;]
  StringNode &operator=(char const *newString);
  //enables StringNode << [long | int] << ...
  StringNode &operator<<(const long number);
  StringNode &operator<<(const int number){ return *this << (long)number; }
  //enables StringNode = [long | int] = ...
  StringNode &operator=(const long number);
  StringNode &operator=(const int number){ return *this = (long)number; }
  //member to member of object StringNode copy
  StringNode &operator=(StringNode const &);
  //overloaded operators for string insertion char array and char
  StringNode &operator<<(char const *);
  StringNode &operator<<(char const);

  //next pointer for external availability to make linked lists
  StringNode *next;

protected:
  //utilitie functions called by overloaded operators
  //used by = operator
  void setString(char const *);
  void setString(char const);
  //used by << operators
  void appendStringNode(const char *);
  void appendStringNode(const char);

  char *String;		//pointer to main character array
};

/*StringNode::StringNode(const char *beginString);
StringNode::~StringNode();
void StringNode::setString(char const *newString);
void StringNode::setString(const char toCopy);
char *StringNode::getString() const;
void StringNode::appendStringNode(const char toCopy);
StringNode &StringNode::operator<<(char const *addString);
StringNode &StringNode::operator<<(char const addString);
StringNode &StringNode::operator=(StringNode const &toCopyFrom);

StringNode &StringNode::operator=(const char *newString);
StringNode &StringNode::operator=(const long number);
StringNode &StringNode::operator<<(const long number);
StringNode &operator<<(StringNode &appendTo, StringNode const
		       &copyFrom);
ostream &operator<<(ostream &coutObject, StringNode &outStringNode);
ostream &operator<<(ostream &coutObject, StringNode *outStringNode);*/

#endif
