/*
STACK.C (Stack with template implemented as a class) 05-08-96

This is a stack object implemented using templates.

A stack is a data structure that operates like a stack of plates.
You can put data (push) on to the stack, but you must get data off
the stack (with pop) in the reverse order it was put on.  This is the
called a first in first out method (FIFO).

*/

#ifndef _STACK_H
#define _STACK_H

#include <erralloc.h>

//class Stack works like a stack that
//can push and pop any type of data

//____________________________class Stack___________________________
template<class T>
class Stack
{
public:
  Stack(int = 10);  //constructor
  ~Stack();         //destructor
  void push(T const &);      //push element on stack
  int pop(T &);     //pop element off stack
  int getCount();
  Stack<T> &operator=(Stack<T> const &);

private:
  void reAlloc();

  int limit;        //max number of elements in stack
  int stackPointer; //index into stack
  int dataChunks;
  T *elementPtr;    //pointer for array
};


//constructor sets up array
template<class T>
Stack<T>::Stack(int dataChunksP)
{
	dataChunks = dataChunksP;

	//if ( (dataChunks < 0) || (dataChunks > 1000) ) size = 10;  //reasonable size
	stackPointer = 0; //index begins at the front
	limit = dataChunks;     //max number of elements
	//dynamically allocate array elements to number
	if (!(elementPtr = new T[dataChunks])) fatalErr();
}

//contructor sets up array
template<class T>
Stack<T>::~Stack()
{
	delete [] elementPtr;
}

//push element onstack. This procedure sets the array element
//at offset stackPointer to 'newElement'.
//if run out of space, create more and put on stack.
template<class T>
void Stack<T>::push(T const &newElement)
{
	if (stackPointer >= limit) reAlloc();

	elementPtr[stackPointer++] = newElement;
}

//pop uses call by reference to return the passed value.
//this procedure returns 1 on success, 0 if fail
template<class T>
int Stack<T>::pop(T &oldElement)
{
	if (stackPointer != 0) {     //make sure not past limit
		oldElement = elementPtr[--stackPointer];
		//stackPointer = stackPointer - 1; //decrement index
		return 1;  //if not empty, exit success
	}

	else return 0;						  //else return failure
}

//returns number of elements pushed on the stack so far.
template<class T>
int Stack<T>::getCount()
{
	return stackPointer;
}

//overloaded= function sets Stack = Stack.  This is for the
//most part a memberwise copy.
template<class T>
Stack<T> &Stack<T>::operator=(Stack<T> const &copyFrom)
{
	int i;

	if (elementPtr) delete [] elementPtr;		//delete *this data
	//new it and if there is a alloc problem, halt program
	if ( !(elementPtr = new T[copyFrom.limit]) ) fatalErr();

	//set *this data to copyFrom data
	limit = copyFrom.limit;
	stackPointer = copyFrom.stackPointer;

	//copy over stack data
	for (i = 0; i < stackPointer; i++)
		elementPtr[i] = copyFrom.elementPtr[i];

	return *this;				//for concatenation purposes
}

//this private member function creates more space for push when
//there is no more room (# of elements pushed >= space allocated for it)
template<class T>
void Stack<T>::reAlloc()
{
	T *newArray;
	int i;

	//define new limit by adding a dataChunk # of elements
	limit += dataChunks;

	//new it and exit on error
	if (!(newArray = new T[limit] )) fatalErr();

	//copy over data
	for (i = 0; i < stackPointer; i++)
		newArray[i] = elementPtr[i];

	//delete old memory allocated and update pointer
	delete [] elementPtr;
	elementPtr = newArray;

}

#endif
