/*
------------------------------------------------------------
Header file: readln.h
Written by Paul Landes (landes@jove.acs.unt.edu)
on Wed 10/15/97 20:18:50

Copyright (C) 1997 by Paul Landes. This code/program is free 
software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software 
Foundation; either version 2 of the License, or (at your option) any 
later version. 

This header file contains 

Unless otherwise stated at the beginning of each member function,
all functions return standard error status: 1 on fail, 0 on success.
------------------------------------------------------------
*/

#ifndef _READLN_H
#define _READLN_H

#include <stdio.h>

#ifdef __READLN
#include <readline/readline.h>
#include <readline/history.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

char *getEqus(char *prompt);
void add_historyAlias(char *equationPtr);
int write_historyAlias(char *filename);
int read_historyAlias(char *filename);

#ifdef __cplusplus
	} /* extern "C" */
#endif


#endif
