//MATRIX.H  (Matrix Class)
//by Paul Landes (landes@jove.acs.unt.edu)
//6-8-96

//This class dynamically creates a matrix of any type (T).  There are get
//and set functions that allow manipulation of data in the object.

#ifndef _MATRIX_H		//if not defined yet, define it.
#define _MATRIX_H

//___________________________class Matrix_________________________________
template <class T>
class Matrix
{
public:
  Matrix(int const, int const);
  ~Matrix();

  //set a element in matrix
  int setElement(int const, int const, T const);
  //get an elemenet, parameters: row and col element, return val is type T
  int getElement(int const rowP, int const colP, T &result) const
    {
      if ( (rowP >= row) || (colP >= col) ) return 1;
      result = element[rowP][colP];
      return 0;
    }

  //get coordinate functions
  int getRow() const { return row; }
  int getCol() const { return col; }

  //overloaded operator for Matrix = Matrix
  Matrix &operator=(Matrix<T> &);

  Matrix *next;		//self-referencial pointer for linked lists

private:
  T **element;		//double pointer allows 2d arrays
  int row, col;		//coordinates in matrix
};

//constructor allocates memeory with 'new' and sets all elements to 0
//(if includeing a class, you have to have overloaded = for this to work
template <class T>
Matrix<T>::Matrix (int const rowP, int const colP)
{
	int i, j;

	row = rowP;
	col = colP;

	element = new T * [row]; 			//allocate space for row type T pointers

  //fill each row of cols
	for (i = 0; i < row; i++) {
		element[i] = new T [col];		//allocate array of type T to each row
		for (j = 0; j < col; j++) element[i][j] = 0;
	}

  next = 0;
}

//destructor first deletes all memory in cols for each row,
//then it deletes the pointer array
template <class T>
Matrix<T>::~Matrix()
{
	int i;
	for (i = 0; i < row; i++) delete [] element[i];
	delete [] element;
}

//set an element, if the row or col values are out of range, return
//exit failure.  Return: 0 on exit success, 1 on exit failure
template <class T>
int Matrix<T>::setElement(const int rowP, const int colP, const T value)
{
	if ( (rowP < row) && (colP < col) ) {
		element[rowP][colP] = value;
		return 0;
	}
	else return 1;
}


//overloaded= copies one matrix to another.  Since the matrix
//class is dynamic and uses pointers, a memberwise copy won't work

//if THIS matrix is smaller that 'copyFrom' then the function will copy
//what THIS has space for in rows and cols (superimpose the matrix)
//if THIS matrix is larger, then the function will copy everthing
//and leave the rest of the matrix untouched
template <class T>
Matrix<T> &Matrix<T>::operator=(Matrix<T> &copyFrom)
{
	int i, j, rowmax, colmax;

  //chose row and col length variables by which ever are smaller
	if (copyFrom.getRow() > row) rowmax = row;
	else rowmax = copyFrom.getRow();

	if (copyFrom.getCol() > col) colmax = col;
	else colmax = copyFrom.getCol();

  //cell by cell copy
  //NOTE: Overload your = operator for user defined object here
	for (i = 0; i < rowmax; i++)
		for (j = 0; j < colmax; j++)
			copyFrom.getElement(i, j, element[i][j]);

	return *this;  //enables concatenation
}

//this function that prints out a matrix
//CAUTION: this function prints row by row, col by col with cout so
//object passed must have cout << overloaded.  NO formating is used!
template <class T>
void printMatrix(Matrix<T> const &prMatrix)
{
	int rowcount = prMatrix.getRow();
	int colcount = prMatrix.getCol();
	int i, j;
	T tmpVar;

  //cell by cell print using cout
	for (i = 0; i < rowcount; i++) {
		for (j = 0; j < colcount; j++)
    {
    	prMatrix.getElement(i, j ,tmpVar);
			cout << tmpVar;
    }
		cout << endl;
	}
}

#endif	//__MATRIX_H
