/*
------------------------------------------------------------
Header file: evalhelp.h
Written by Paul Landes (landes@jove.acs.unt.edu)
on Sat 10/4/97 19:59:39

Copyright (C) 1997 by Paul Landes. This code/program is free 
software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software 
Foundation; either version 2 of the License, or (at your option) any 
later version. 

This header file contains prototypes of code that helps out with
evaluation of equations.

Unless otherwise stated at the beginning of each member function,
all functions return standard error status: 1 on fail, 0 on success.
------------------------------------------------------------
*/

#ifndef _EVALHELP_H
#define _EVALHELP_H

#include <stringn.h>
#include <strmanip.h>

int findChar(char const *e, char const *order, int const pos);
int checkAlphaNExt(const char character);
int checkBracket(char const strMemeber);
char *extractAlpha(char const *extractIt);
char *extractVariables(char const *extractV);
int findEndPar(char const *oldString, int pos, int const direction);
char *extractP(char const *oldString, int pos);
void putPar(char *&e, int &pos, int justForward);
char *replaceOperators(char *&e, char const *order, char const
		       *usrDefOp);
char *preInfix(char const *e, char const *originalE, char const
	       *order);
void infix(char *&e, const char *order);
void postfix(char *&e, const char *order);


#endif
