/*
------------------------------------------------------------
Header file: erralloc.h
Written by Paul Landes (landes@jove.acs.unt.edu)
on Sat 10/4/97 19:14:40

Copyright (C) 1997 by Paul Landes. This code/program is free 
software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software 
Foundation; either version 2 of the License, or (at your option) any 
later version. 

This header file contains prototypes for simple memory allocation
procedures and simple error functions.

Unless otherwise stated at the beginning of each member function,
all functions return standard error status: 1 on fail, 0 on success.
------------------------------------------------------------
*/

#ifndef _ERRALLOC_H
#define _ERRALLOC_H

#include <iostream.h>
#include <string.h>
#include <stdlib.h>

void fatalErr(char *message = 0);
char *nonFatalErr(char const *message, char const *exp, int const pos);
char *newStringAlloc(const int size);
char *newStringCopy(const char *toCopy);


//This is a handy procedure to new a object and catch 'out of memory' errors
//DANGER: if size is not 1 (your creating an array of objects) the
//constructors will be invoked.
template <class T>
void newObjectAlloc(T *&passObject)
{
  if (!(passObject = new T))
    fatalErr("Not enough memory to instantiate object.");
}

#endif
