/*
------------------------------------------------------------
Header file: cmdop.h
Written by Paul Landes <landes@unt.edu>
on Sat 5/16/98 21:15:36

Copyright (C) 1998 by Paul Landes. This code/program is free 
software; you can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software 
Foundation; either version 2 of the License, or (at your option) any 
later version. 
------------------------------------------------------------
*/

#ifndef _CMDOP_H
#define _CMDOP_H

#include <string>
#include <vector.h>
#include <bool.h>

//This is a class that parses command line options.  The only way to
//use this class is to inherit it.  To use this class:
//  1. Inherit this class
//  2. In the inherited class, add all command line parameters with
//     the add function using varibles in the inherited class
//  3. Set all variables to the default value.
//  4. Call parse() to get all command line varibles

//After the parse(), any command line options that alter a varible are
//done.  There are two kinds of command line options: ones that take
//arguments and ones that do not.  If the option takes an argument,
//then the varible that will be set when the command is found is sent
//to the add() function as a void pointer, therefore a varible that is
//set must be an int, double, string or boolean variable.  If the type
//is a boolean variable, then no parameter is expected
class ZCmdop
{
public:
  //type of varible to be set in assign()
  enum type_t { TINT, TDOUBLE, TSTRING, TBOOL, TPRINTEXIT };
  //a varible command line option node
  typedef struct {
    char shortop;
    string longop;
    type_t type;
    void *data;
  } CmdNode;
  //vector of command line options
  typedef vector<CmdNode> cmdvector;

public:
  ZCmdop() {}
  virtual ~ZCmdop() {}

protected:
  //add a command line entry node
  void add(const char shortop, const string &longop, 
	   const type_t type, const void *data);
  int parse(char **argv, string &error);

private:
  CmdNode *getIdx(const char letter);
  CmdNode *getIdx(const char *str);
  void assign(CmdNode *node, const char *op);

private:
  //vector of the command line options
  cmdvector mCmdVec;
};


#endif
