//return 0 (sometimes -1 for int, float etc) is exit failure for
//value return.
//return 0 is return success for error reporting functions.

#include "stringn.h"
#include "strmanip.h"

//this function finds an operator (*e) in *order
//the function returns the 'order' position
int findChar(char const *e, char const *order, int const pos)
{
  int i = 0, orderNum = 0;

  while ( (order[i] != 0) && (order[i] != e[pos]) ) {
    if (order[i] == '`') orderNum++;
    i++;
  }

  if (order[i] == 0) return -1;
  else return orderNum;
}

//this function returns a 1 if the char passed is a number,
//letter or part of the extended IBM char set (char < 0)
//this function is specifically for EquSolveNum child
int checkAlphaNExt(const char character)
{
  if ( ( checkAlphaN(character) ) || (character < 0) ) return 1;
  else return 0;
}

//this function returns a 0 if the char passed is not a parenthasis,
//or 1 or -1 if it is.
int checkBracket(char const strMemeber)
{
  if (strMemeber == '(') return 1;
  else if (strMemeber == ')') return -1;
  else return 0;
}

//This function returns a pointer to a NEWed string with all alphabetic
//letters found in *extractIt or NULL on fail.
char *extractAlpha(char const *extractIt)
{
  int i, countLetters = 0;
  char *newString;

  //count number of letters to the end of extractIt
  for (i = 0; extractIt[i] != 0; i++)
    countLetters += checkAlpha(extractIt[i]);

  if (countLetters == 0) return 0;  //exit fail if no alpha was found

  //make space for new string
  newString = newStringAlloc(countLetters);
  countLetters = 0;

  //copy in letters
  for (i = 0; extractIt[i] != 0; i++)
    if (checkAlpha(extractIt[i]))
      {
	newString[countLetters] = extractIt[i];
	countLetters++;
      }

  //add terminating null character
  newString[countLetters] = 0;
  return newString;
}

//This function returns a pointer to a NEWed string of alphabet letters
//from a string much like extract alpha, but no repeating letters are appear.
char *extractVariables(char const *extractV)
{
	int i, j, count = 0;
	char *returnString, *newString;

	newString = extractAlpha(extractV);

	//return a 0 if no letters were passed in *extractV
	if (!newString) return 0;

	//first pass, count all letters only once such that
	//no repeating letters counted
	for (i = 0; newString[i] != 0; i++) {
		for (j = 0; (newString[i] != newString[j]) && j <= i; j++);
		if (i == j) count++;
	}

  //new the string with the count
	returnString = newStringAlloc(count);
	count = 0;

	//second pass, copy all no repeating letters into new string
	for (i = 0; newString[i] != 0; i++) {
		for (j = 0; (newString[i] != newString[j]) && j <= i; j++);
		if (i == j) {
			returnString[count] = newString[i];
			count++;
		}
	}

	returnString[count] = 0;	//set null terminating char at end
	delete [] newString;			//free space up

	return returnString;
}

//This function returns the position in *oldString of where the last
//parathesis of a scope in an equation (i.e. b+(a*(b+g)) <-- last)
//starting position does not have to be on a '('.  The function looks
//forward or backward depending on direction (1 or -1).  Returns -1 on fail.
int findEndPar(char const *oldString, int pos, int const direction)
{
  int inside_num_bracket = 0, tmpValue;

  //catch run-time programmer's error
  if ((direction != -1) && (direction != 1))
    fatalErr("Error, direction must be 1 or -1 for 'findEndPar' function");

  while (oldString[pos] != 0)
    {
      tmpValue = checkBracket(oldString[pos]);  //tmpValue will get 0, -1 or 1
      //counts or decrements scopes
      inside_num_bracket += tmpValue;

      //when we have come out of a scope and the last () was the opposite
      //direction we are going, that is the last ().
      if ((inside_num_bracket == 0) && (tmpValue == -1 * direction)) break;
      pos += direction;	//traverse either forward or backward
    }

  if (!oldString[pos]) return -1;  	//exit failure

  return pos;
}

//Function returns a NEWed string to the contents in a () scope.  exit
//NULL on failure
char *extractP(char const *oldString, int pos)
{
  int oldPos = pos, i, maxLen;
  char *newString;

  //find the length of the new string to be made
  pos = findEndPar(oldString, pos, 1);
  if (pos == -1) return 0;	   	//if end () not found, return NULL
  maxLen = pos - oldPos;

  //new it and copy over data
  newString = newStringAlloc(maxLen);
  for (i = 0; i < maxLen - 1; i++)
    newString[i] = oldString[oldPos + i + 1];

  newString[maxLen - 1] = 0;		//add null terminating char

  return newString;							//exit success
}

//Function inserts parenthesis around two variables.  A () scope is
//considered a variable. (i.e.  a+b => (a+b); (f+g) - f => ((f+g) - f)
//) parameters: *e = equation to be modified with NEWed string, pos =
//position in e that is an operator char; justForward = special case
//for unirary ops.  CAUTION: ONLY use this function with string
//pointers that CAN be deleted!
void putPar(char *&e, int &pos, int justForward)
{
  int startPos, endPos;

  if (justForward != 1) {  			//regular () putting
    if (e[pos - 1] != ')') startPos = pos - 1;
    else startPos = findEndPar(e, pos, -1);

    if (e[pos + 1] != '(') endPos = pos + 2;
    else endPos = findEndPar(e, pos, 1);
  }

  else { 												//special case only for _ or ~ (not)
    if (e[pos + 1] != '(') endPos = pos + 2;
    else endPos = findEndPar(e, pos, 1);
    startPos = pos;
  }

  //Insert ()'s ONLY if necessary (not around the whole expression
  //and not around another scope that already has parenthesis).
  if ( !( (startPos == 0) && ((size_t)endPos == strlen(e)) ) &&
       ((e[startPos - 1] != '(') || (e[endPos + 1] != ')')) ) {

    insertChar(e, ')', endPos);
    insertChar(e, '(', startPos);
    pos = endPos + 2;
  }
  //if did not insert ()'s update position to end of current scope
  else pos = endPos;

}

//This function replaces user defined operators with operators used by
//EquSolve::solveEquation for solving the equation.  parameters: *e =
//equation to be modified; *order = order definitions for equation
//solver; userDefOp = userdefined order Function returns an NEWed
//error message on fail, or 0 on success.  CAUTION: ONLY use this
//function with string pointers that CAN be deleted!
char *replaceOperators(char *&e, char const *order, char const *usrDefOp)
{
  char *getOp, *ptrOp, *errString;
  int pos, orderPos, countOp, countOr, i, errPos = 0;
  unsigned char replacedOperator = 0;

  pos = countOp = countOr = 0;

  //check to see if there are a matching number of operators in order defs.
  for (i = 0; usrDefOp[i] != 0; i++) if (usrDefOp[i] == '`') countOp++;
  for (i = 0; order[i] != 0; i++) if (order[i] == '`') countOr++;

  //if not, return an error message
  if (countOp != countOr)
    return newStringCopy
      ("User operator definition does not match true operators");

  //in case an error occurs, we have original string for error message
  errString = newStringCopy(e);

  //Main loop replaces a char one at a time.  Each char is compared with
  //user operator strings, if non are found, position is incremented.
  while (e[pos] != 0)
    {
      //setup token traversing strings, etc.
      //we must new this every time because strtok inserts NULL chars
      ptrOp = newStringCopy(usrDefOp);
      getOp = strtok(ptrOp, "`");
      orderPos = 0;

      while (getOp) 
	{

	  if ( (e[pos] == getOp[0]) && (findString(e, getOp, pos) == pos) )
	    {
	      //for efficiency, if the operator to replace is the same as
	      //the operator being replaced, don't call replaceBlock().
	      if ( !((getOp[1] == 0) && (order[orderPos] == e[pos])) )
		{
		  int tmpInt = strlen(getOp) - 1;
		  errPos += tmpInt;
		  replaceBlock(e, order[orderPos], pos, pos + tmpInt);
		}
	      replacedOperator = 1;
	      break;
	    }

	  orderPos++;
	  if (order[orderPos] == '`') orderPos++;

	  getOp = strtok(0, "`");
	}

      //if did not replace operators and current char is operator, return err.
      if ( (!replacedOperator) && (findChar(e, order, pos) != -1) )
	{
	  delete [] ptrOp;
	  return nonFatalErr("Un-identified or incorrectly placed operator.",
			     errString, pos + errPos);
	}

      replacedOperator = 0;	  //reset replace operator checker
      pos++;                    //update position
      delete [] ptrOp;	  //delete token string to be newed again
    }

  delete [] errString;
  return 0;
}

//Error checking function for equations.  Parameters: *e = equation string
//that will be modified, order = equations solver's order of operations
char *preInfix(char const *e, char const *originalE, char const *order)
{
  int countPars = 0, i, pos;

  if (strlen(e) > 100) 		//string to big
    return
      newStringCopy("String cannot be longer than 100 characters.");

  for (i = 0; e[i] != 0; i++)
    countPars += checkBracket(e[i]);

  if (countPars != 0)  		//parse error
    return nonFatalErr
      ("Parse Error (Unbalanced Parenthesis).", originalE, strlen(e));;

  pos = findString(e, ")(", 0);
  if (pos != -1)  	//no operator between parenthesis
    return nonFatalErr("Missing operator.", originalE, pos + 1);

  pos = findString(e, "()", 0);
  if (pos != -1) 	//no operator between parenthesis
    return nonFatalErr("Empty Parenthesis.", originalE, pos + 1);

  for (pos = 0; e[pos] != 0; pos++)
    {
      if ( !checkAlphaNExt(e[pos]) && (checkBracket(e[pos]) == 0)
	   && (findChar(e, order, pos) == -1) ) {
	return nonFatalErr("Un-identified symbol.", originalE, pos);
      }
    }

  pos = 1;
  i = strlen(e) - 1;

  //check beginning and end casses
  //ok if end symbol is a ')' or a letter
  if ( !( (e[i] == ')') || ( checkAlphaNExt(e[i]) ) ) || 
       (e[i - 1] == ')' && e[i] != ')') )
    return nonFatalErr("Missing operator or operand.", originalE, i);

  //ok if starting out with (, a variable letter, or a unirary operator
  //but error if "a(f+g)"
  if ( !( (e[0] == '(') || ( checkAlphaNExt(e[0])
			     || (findChar(e, order, 0) == 0) ) )  
       || ( (e[1] == '(') && (e[0] != '(') 
	    && (findChar(e, order, 0) != 0) ) )
    return nonFatalErr("Missing operator or operand.", originalE, 1);

  //Main while loop checks each character and compares it to the
  //surrounding characters.  Each place is a letter variable, binary and
  //unirary operator.  Conditions for these are in Sum of Product form (SOP).
  while (e[pos+1] != 0)
    {
      if (checkAlphaNExt(e[pos]))								//letter variable SOP
	{
	  if (!( ( (e[pos - 1] == '(') && (findChar(e, order, pos + 1) >= 0) )
		 || ( (findChar(e, order, pos - 1) >= 0) && (e[pos + 1] == ')') )
		 || ( (e[pos - 1] == '(') && (e[pos + 1] == ')') )
		 || ( (findChar(e, order, pos - 1) >= 0)
		      && (findChar(e, order, pos + 1) >= 0)) )) {
	    return nonFatalErr("Missing operator.", originalE, pos);
	  }
	}
      else if (findChar(e, order, pos) > 0)		//operator (non-unirary) SOP
	{
	  if (!( ( (e[pos - 1] == ')') && (checkAlphaNExt(e[pos + 1])) )
		 || ( (checkAlphaNExt(e[pos - 1])) && (e[pos + 1] == '(') )
		 || ( (e[pos - 1] == ')') && (e[pos + 1] == '(') )
		 || ( (checkAlphaNExt(e[pos - 1])) && (checkAlphaNExt(e[pos + 1])) )
		 || (findChar(e, order, pos + 1) == 0) )) {
	    return nonFatalErr("Missing operand.", originalE, pos);
	  }
	}
      else if (findChar(e, order, pos) == 0)	//operator (unirary) SOP
	if ( checkAlpha(e[pos - 1]) )
	  return nonFatalErr("Missing operator.", originalE, pos - 1);

      pos++;	//update position
    }

  return 0;  //exit success
}

//Function places parenthesis according to the order of operation recursively
//parameters: e = expression; order = order of operations
//CAUTION: ONLY use this function with string pointers that CAN be deleted!
void infix(char *&e, const char *order)
{
  int pos = 0, pos2;

  //main loop cycles until the end of the string
  while (e[pos] != 0) {
    //look for a open parenthesis
    pos2 = findChar(e, '(', pos);
    if (pos2 != -1)									//if a parenthesis is found, recurse
      {
	char *newString;
	int endPos;

	//get next scope (the expression inside ()'s ) and pass it to infix
	//this recursion will continue until there are no more ()'s
	endPos = findEndPar(e, pos2, 1);
	newString = extractP(e, pos2);
	infix(newString, order);

	//after scope has been parenthasised, replace old scope in THIS ()
	//with the new expression returned from infix.
	replaceBlock(e, newString, pos2, endPos);

	delete [] newString;					//free up space
	pos = findEndPar(e, pos2, 1);	//advance position to the next ()'s
      } //end if
    else {		//if there are no more ()'s
      int orderNum = 0, i;
      char *ptrOp, *getOp;

      ptrOp = newStringCopy(order);
      getOp = strtok(ptrOp, "`");

      //insert ()'s according to the order of operations set in '*order'.
      while(getOp) {
	pos = 0;

	//insert ()'s.  Check each char one by one for
				//current order of operation (in getOp)
	while (e[pos] != 0) {
	  //check to see if current char is an operator
	  i = findChar(e, getOp, pos);

	  if (i != -1)	//if found an operator
	    {
	      //if we are currently looking for unirary operators, place ()'s
	      //only after and not around operator.
	      if (orderNum == 0) putPar(e, pos, 1);
	      else putPar(e, pos, -1);								//else a binary operator
	    }
	  //other wise, if a ()'s, scan to the end of () scope.
	  else if (e[pos] == '(') pos = findEndPar(e, pos, 1) + 1;
	  else pos++;	//if not a ()'s then it is a variable, inc position
	}

	orderNum++;							//inc order of operation count
	getOp = strtok(0, "`");	//get next token
      } //end while

      delete [] ptrOp;

      //if there are no ()'s surounding the whole expression, add them
      if (findEndPar(e, 0, 1) != (int)strlen(e) - 1)
	{
	  insertChar(e, '(', 0);
	  insertChar(e, ')', strlen(e));
	}
      //other wise, delete surounding ()'s until there
      //is only one set surounding the expression
      else {
	while ((e[0] == '(') && (e[findEndPar(e, 0, 1)] == (int)strlen(e) - 1) )
	  {
	    deleteChar(e, 0);
	    deleteChar(e, strlen(e) - 1);
	  }
      }

      break; //break out of while loop after all ()'s are inserted
    }
  }
}


void postfix(char *&e, const char *order)
{
  int pos = 0, pos2;

  while (e[pos] != 0)
    {
      if (e[pos] == '(') deleteChar(e, pos);
      else if (findChar(e, order, pos) != -1)  //if e[pos] is not an operator
	{
	  //if found a () scope, recurse
	  if (e[pos + 1] == '(')
	    {
	      char *newString;
	      int endPos;

	      //fix up a string to recurse with that contains () scope
	      endPos = findEndPar(e, pos, 1);
	      newString = extractP(e, pos + 1);

	      //insert a ) at the end for the replace of an operator
	      insertChar(newString, ')', strlen(newString));

	      //recurse next () scope
	      postfix(newString, order);

	      //replace with modified scope
	      replaceBlock(e, newString, pos + 1, endPos);

	      delete [] newString;
	    }
	  else	//otherwise, string has not ()'s to worry about
	    {
	      pos2 = findChar(e, ')', pos);	//find the last )
	      deleteChar(e, pos2);					//delete the last )
	      insertChar(e, e[pos], pos2);	//copy/insert operator where ) was
	      deleteChar(e, pos);						//delete operator
	      pos = pos2;										//increment position where ) was
	    }

	}
      //if e[pos] is not a '(' or an operator,
      //hopefully it is a variable letter, so skip
      else pos++;

    }
}
