#include"erralloc.h"

//This function is the last resort error handler function.  It exits
//failure from the program.  Modify this function for other platforms
void fatalErr(char *message = 0)
{
  char defaultMessage [] = "Out of memory!";

  //if NULL passed, use out of memory default
  if (!message) message = &defaultMessage[0];

  cerr << "Fatal Error:" << message << endl
       << "Can't recover, aborting program" << endl;

  exit(1);
}

//This is an error handling function that returns a NEWed string pointer with
//(*message), AND draws an arrow pointing to a string(*exp) at parameter pos.
char *nonFatalErr(char const *message, char const *exp, int const pos)
{
  char buffer[300], *returnMessage;
  int i;

  //for programming errors--use newStringCopy for new strings
  if (!exp) fatalErr("No expression for 'exp' in nonFatalErr");

  //load the message in the first line
  strcpy(buffer, message);

  //if there is not a newline at the end of the message passed, add one
  if ( message[strlen(message) - 1] != '\n' ) strcat(buffer, "\n");

  //add the expression string and a new line
  strcat(buffer, exp);
  strcat(buffer, "\n");

  //add on the 'arrow'
  for (i = 0; i < pos; i++)  strcat(buffer, "_");
  strcat(buffer, "|\n");

  //try to new a string, copy the buffer to it
  if (!(returnMessage = new char[strlen(buffer) + 1]))
    fatalErr("Out of memory on atempt creating error message.");
  strcpy (returnMessage, buffer);

  return returnMessage;  //return a pointer to the new string
}

//This function just NEWs memory, but it catches 'out of memory' erros
char *newStringAlloc(const int size)
{
	char *tmpString;

	if (!(tmpString = new char[size + 2]))
		fatalErr("Not enough memory to make string.");

  return tmpString;		//return pointer to newly allocated memory
}

//This function returns a pointer to a NEWed string
//that has the contents of *toCopy
char *newStringCopy(const char *toCopy)
{
  char *tmpString;

  if (!toCopy) return 0;
  tmpString = newStringAlloc(strlen(toCopy));
  strcpy(tmpString, toCopy);

  return tmpString;
}
