#!/bin/sh
#
#	srecord - manipulate eprom load files
#	Copyright (C) 1998, 1999 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the unsplit filter functionality
#
here=`pwd`
if test $? -ne 0 ; then exit 2; fi
work=${TMP_DIR-/tmp}/$$

pass()
{
	cd $here
	rm -rf $work
	echo PASSED
	exit 0
}

fail()
{
	cd $here
	rm -rf $work
	echo 'FAILED test of the unsplit filter functionality'
	exit 1
}

no_result()
{
	cd $here
	rm -rf $work
	echo 'NO RESULT for test of the unsplit filter functionality'
	exit 2
}

trap "no_result" 1 2 3 15

bin=$here/${1-.}/bin
mkdir $work
if test $? -ne 0; then no_result; fi
cd $work
if test $? -ne 0; then no_result; fi

cat > test.in << 'fubar'
Hello, World!
fubar
if test $? -ne 0; then no_result; fi

cat > test.ok << 'fubar'
Hello, World!
fubar
if test $? -ne 0; then no_result; fi

$bin/srec_cat test.in -bin -split 2 0 -o test.even
if test $? -ne 0; then fail; fi

$bin/srec_cat test.in -bin -split 2 1 -o test.odd
if test $? -ne 0; then fail; fi

$bin/srec_cat test.even -unsplit 2 0 test.odd -unsplit 2 1 -o test.out -bin
if test $? -ne 0; then fail; fi

diff test.out test.ok

#
# The things tested here, worked.
# No other guarantees are made.
#
pass
