
procedure spreadsheet;

const
cmin               =  97;
cmid               =  104;
cmax               =  112;
rmin               =  1;
rmax               =  60;
cr                 =  #13;
bs                 =  #8;

type
str80              =  string[80];
str40              =  string[40];
celltype           =  record
                        s : str40;
                        v : real;
                      end;
sheettype          =  array[cmin..cmax,rmin..rmax] of celltype;
sheetptr           =  ^sheettype;

var
sheet              :  sheetptr;
filename           :  str80;
s                  :  str80;
i,ii,j,jj,
x_off,y_off,
p,errnum           :  integer;
f                  :  file of sheettype;
t                  :  text;
key                :  char;


function _re(s : str80):real;
var b : str80;
p : integer;
begin
  repeat  (* dereference cell address $xnn to values *)
  p:=pos('$',s);
  if p>0 then
  begin
    ii:=ord(s[p+1]);
    val(copy(s,p+2,2),jj,errnum);
    delete(s,p,4);
    if (ii in [cmin..cmax]) and (jj in [rmin..rmax]) and (errnum=0)
    then str(sheet^[ii,jj].v:0:2,b)
    else b:='0';
    insert(b,s,p);
  end;
  until p<1;
  _re:=re(s);
end;

procedure init;
var i,j : word;
begin
x_off := 0; y_off := 0;
for i := cmin to cmax do
  for j := 1 to rmax do
  begin
    sheet^[i,j].s := '';
    sheet^[i,j].v := 0.0;
  end;
end;

procedure calc_cell(i,j : integer);
var ii,jj : word;
begin
  sheet^[i,j].v:=0.0;
  if sheet^[i,j].s[1]<>'.' then
  begin
    if sheet^[i,j].s[1]='X' then
    begin
      if sheet^[i,j].s[2]='<' then
      begin
        sheet^[i,j].v:=99999999.9;
        for ii:=i-1 downto cmin do
          if (sheet^[ii,j].v<sheet^[i,j].v) and (sheet^[ii,j].v<>0.0) then
            sheet^[i,j].v:=sheet^[ii,j].v;
      end
      else if sheet^[i,j].s[2]='>' then
      begin
        sheet^[i,j].v:=-99999999.9;
        for ii:=i-1 downto cmin do
          if sheet^[ii,j].v>sheet^[i,j].v then sheet^[i,j].v:=sheet^[ii,j].v;
      end
      else for ii:=i-1 downto cmin do
      begin
	if sheet^[ii,j].s[1]='X' then exit;
	sheet^[i,j].v:=sheet^[i,j].v+sheet^[ii,j].v;
      end;
    end
    else if sheet^[i,j].s[1]='Y' then
    begin
      if sheet^[i,j].s[2]='<' then
      begin
        sheet^[i,j].v:=99999999.9;
        for jj:=j-1 downto rmin do
          if (sheet^[i,jj].v<sheet^[i,j].v) and (sheet^[i,jj].v<>0.0) then
            sheet^[i,j].v:=sheet^[i,jj].v;
      end
      else if sheet^[i,j].s[2]='>' then
      begin
        sheet^[i,j].v:=-99999999.9;
        for jj:=j-1 downto rmin do
          if sheet^[i,jj].v>sheet^[i,j].v then sheet^[i,j].v:=sheet^[i,jj].v;
      end
      else for jj:=j-1 downto rmin do
      begin
	if sheet^[i,jj].s[1]='Y' then exit;
	sheet^[i,j].v:=sheet^[i,j].v+sheet^[i,jj].v;
      end;
    end
    else sheet^[i,j].v := _re(sheet^[i,j].s);
  end;
end;

procedure disp_cell(i,j : integer);
begin
  gotoxy((i-cmin-x_off)*10+1,j-y_off+3); (*write('          ');*)
  if length(sheet^[i,j].s)>0 then
  begin
  gotoxy((i-cmin-x_off)*10+1,j-y_off+3);
  if sheet^[i,j].s[1]='.' then write(copy(sheet^[i,j].s,2,10):10)
			  else begin
			  calc_cell(i,j); write(sheet^[i,j].v:10:2); end;
  end;
end;

procedure display;
var i,j : word;
begin
textbackground(white);
textcolor(black);
clrscr;
for i := cmin+x_off to cmid+x_off do
  for j := 1+y_off to 20+y_off do disp_cell(i,j);
end;

procedure ins(c : char); (* c=col; r=row *)
var n,i,j : word;
    s : string;
begin
if c='c' then (* col *)
begin
  gotoxy(1,2);
  write('INS col (A=1-P=16)> ');
  readln(s); val(s,n,j); n:= n+96;
  if n in [cmin..cmax] then
  begin
    for j:= cmax-1 downto n do
      for i:= rmin to rmax do
      begin
        sheet^[j+1,i].s := sheet^[j,i].s;
        sheet^[j+1,i].v := sheet^[j,i].v;
      end;
    for i:= rmin to rmax do
    begin
      sheet^[n,i].s := '';
      sheet^[n,i].v := 0.0;
    end;
  display; display;
  end;
end
else          (* row *)
begin
  gotoxy(1,2);
  write('INS row (1-60)> ');
  readln(s); val(s,n,j);
  if n in [rmin..rmax] then
  begin
    for i:= rmax-1 downto n do
      for j:= cmin to cmax do
      begin
        sheet^[j,i+1].s := sheet^[j,i].s;
        sheet^[j,i+1].v := sheet^[j,i].v;
      end;
    for j:= cmin to cmax do
    begin
      sheet^[j,n].s := '';
      sheet^[j,n].v := 0.0;
    end;
  display; display;
  end;
end;
end;

procedure del(c : char); (* c=col; r=row *)
var n,i,j : word;
    s : string;
begin
if c='c' then (* col *)
begin
  gotoxy(1,2);
  write('DEL col (A=1-P=16)> ');
  readln(s); val(s,n,j); n:= n+96;
  if n in [cmin..cmax] then
  begin
    for j:= n to cmax-1 do
      for i:= rmin to rmax do
      begin
        sheet^[j,i].s := sheet^[j+1,i].s;
        sheet^[j,i].v := sheet^[j+1,i].v;
      end;
    for i:= rmin to rmax do
    begin
      sheet^[cmax,i].s := '';
      sheet^[cmax,i].v := 0.0;
    end;
  display; display;
  end;
end
else          (* row *)
begin
  gotoxy(1,2);
  write('DEL row (1-60)> ');
  readln(s); val(s,n,j);
  if n in [rmin..rmax] then
  begin
    for i:= n to rmax-1 do
      for j:= cmin to cmax do
      begin
        sheet^[j,i].s := sheet^[j,i+1].s;
        sheet^[j,i].v := sheet^[j,i+1].v;
      end;
    for j:= cmin to cmax do
    begin
      sheet^[j,rmax].s := '';
      sheet^[j,rmax].v := 0.0;
    end;
  display; display;
  end;
end;
end;

procedure help;
begin
  textbackground(yellow);
  textcolor(black);
  clrscr;
  gotoxy(1,3);
  writeln('Help Page:  (Access with ? or .h elp)'); writeln;
  writeln;
  writeln('cmd> ^      = scroll display up.   |  v      = scroll display down.');
  writeln('cmd> <      = scroll display left. |  >      = scroll display right.');
  writeln('cmd> .ic/r  = insert col/row.      |  .dc/r  = delete col/row.');
  writeln('cmd> .l oad = load spreadsheet.    |  .s ave = save spreadsheet.');
  writeln('cmd> .export= export to sc/unix.   |  .Export= export to CSV(;).');
  writeln('cmd> .p rint= print spreadsheet.   |  e .x it= exit program.');
  writeln('     .P rint= print for multipage. |  .c alc = calculator.');
  writeln('     (page 1= cols a-h X rows 1-60 |  page 2 = cols i-p X rows 1-60)');
  writeln;
  writeln('cmd> <cell address> = a-p1-60 -- 16 cols a-p X 60 rows 1-60');
  writeln('str> <cell string>  = 0-9 +-/* <cell ref> X/Y .text...');
  writeln('      example       = 26.12*$b02+1963      /  .this=text...');
  writeln('     <cell ref>     = $a-p01-60 (must be 4 characters long)');
  writeln('     X              = Sum of cols before cell downto a or "X"');
  writeln('     Y              = Sum of rows before cell downto 1 or "Y"');
  writeln('     X/Y</>         = <=Min Value; >=Max Value of cells downto 1');
  writeln;
  readln(s); clrscr; display;
end;

procedure print_cell(i,j : integer);
begin
  if length(sheet^[i,j].s)>0 then
  begin
  if sheet^[i,j].s[1]='.' then write(t,copy(sheet^[i,j].s,2,10):10)
			  else begin
			  calc_cell(i,j); write(t,sheet^[i,j].v:10:2); end;
  end (*else write(t,'          ');*)
end;

procedure csv_cell(i,j : integer);
begin
  if length(sheet^[i,j].s)>0 then
  begin
  if sheet^[i,j].s[1]='.' then write(t,copy(sheet^[i,j].s,2,10):10)
			  else begin
			  calc_cell(i,j); write(t,sheet^[i,j].v:10:2); end;
  end; (*else write(t,'          ');*)
  write(t,';');
end;

procedure export_cell(i,j : integer);
var cellname : string;
begin
  if length(sheet^[i,j].s)>0 then
  begin
  str(j,cellname); insert(' ',cellname,1); cellname[1]:=chr(i);
  if sheet^[i,j].s[1]='.' then writeln(t,'label ',cellname,' = "',copy(sheet^[i,j].s,2,10):10,'"')
			  else begin
			  calc_cell(i,j); writeln(t,'let ',cellname,' = ',sheet^[i,j].v:10:2); end;
  end (*else write(t,'          ');*)
end;

procedure save_cell(i,j : integer);
var cellname : string;
begin
  if length(sheet^[i,j].s)>0 then
  begin
  str(j:2,cellname); insert(' ',cellname,1); cellname[1]:=chr(i);
  if cellname[2]=' ' then cellname[2]:='0';
  writeln(t,cellname,'=',sheet^[i,j].s);
  end;
end;

procedure export;
var i,j : word;
begin
assign(t,'sc.ux');
rewrite(t);
for j := 1 to rmax do
begin
  for i := cmin to cmax do
    export_cell(i,j);
end;
close (t);
end;

procedure csv;
var i,j : word;
begin
assign(t,'sc.csv');
rewrite(t);
for j := 1 to rmax do
begin
  for i := cmin to cmax do
    csv_cell(i,j);
  writeln(t);
end;
close (t);
end;

procedure save;
var i,j : word;
begin
assign(t,filename);
rewrite(t);
for j := 1 to rmax do
begin
  for i := cmin to cmax do
    save_cell(i,j);
end;
close (t);
end;

procedure print(mp : boolean);
var i,j : word;
begin
assign(t,'sc.prn');
rewrite(t);
for j := 1 to rmax do
begin
  for i := cmin to cmid do (* Page one *)
    print_cell(i,j);
  writeln(t);
end;
if mp then for i:= 1 to 70 do writeln(t)
else writeln(t,#12); (* FF Formfeed *)
for j := 1 to rmax do
begin
  for i := 105 to cmax do (* Page two *)
    print_cell(i,j);
  writeln(t);
end;
if not mp then writeln(t,#12); (* FF Formfeed *)
close (t);
end;

procedure load;
begin
  init;
  clrscr;
  write('Filename: '); readln(filename);
  if exist(filename) then
  begin
    assign(t,filename);
    reset(t);
    while not eof(t) do
    begin
      readln(t,s);
      val(copy(s,2,2),j,i);
      if (i=0) and (j in [rmin..rmax]) then i := ord(s[1]);
      if (i in [cmin..cmax]) then (* valid cell address entered; get string *)
        sheet^[i,j].s := copy(s,5,78);
    end;
    close (t);
  end;
  display; display;
end;

procedure work;
var rows,columns : string[20];
    s : string;
begin
  repeat
    if x_off = 0 then columns:='Columns: A-H | '
    else columns:='Columns: I-P | ';
    case y_off of
       0: rows:='Rows:  1-20';
      20: rows:='Rows: 21-40';
      40: rows:='Rows: 41-60';
    end;
    textbackground(blue);
    textcolor(white);
    gotoxy(1,1); write(columns,rows); clreol; writeln;
    textbackground(cyan);
    textcolor(black);
    write('cmd> '); clreol; readln(s);
    if (length(s)=1) or (s[1]='.') then
    begin
      key:=s[1];
      case key of
      '?' : help;
      '^' : if y_off>0 then begin y_off:=y_off-20; display; end;
      'v' : if y_off<40 then begin y_off:=y_off+20;display; end;
      '<' : begin x_off:=0; display; end;
      '>' : begin x_off:=8; display; end;
      '.' : begin
            key:=s[2];
            case key of
            'i' : ins(s[3]);
            'd' : del(s[3]);
            'h',
            '?' : help;
            'l' : load;
            'c' : calc;
            'x',
            's' : save;
            'e' : export;
            'E' : csv;
            'p' : print(false);
            'P' : print(true);
            end;
            end;
      end;
    end
    else  (* only cell address valid *)
    begin
      val(copy(s,2,78),j,i);
      if (i=0) and (j in [rmin..rmax]) then i := ord(s[1]);
      if (i in [cmin..cmax]) then (* valid cell address entered; get string *)
      begin
        gotoxy(1,2);
        write('str> ');
        s:=sheet^[i,j].s;
        read_str(s,40,allchars);
        sheet^[i,j].s:=s;
        display; display; (* must be too passes *)
      end;
      key:=' ';
    end;
  until key='x';
end;

begin
new(sheet);
load;
work;
dispose(sheet);
clrscr;
end;

