program s5;

uses
dos,crt;

const
copyright = 'S5PPC (c) Peter Sieg 03-Jul-1998 All rights reserved';

(*------- begin of s5.var -----------*)
type
dateiname                =  string[12];
extension                =  string[3];
awtyp                    =  string[9];
awrec                    =  record
                              operation : string[3];
                              operand   : string[2];
                              baustein  : integer;
                              bitnr     : integer;
                            end;
t_rec                    =  record
                              einheit   : integer;
                              wert      : integer;
                            end;
z_rec                    =  record
                              wert      : integer;
                            end;

const
anzopr                   =    7;
maxoperationen           =   22;
maxaw                    =  512;
maxe                     =   31; (* Anzahl Bausteine *)
maxa                     =   31; (* Anzahl Bausteine *)
maxm                     =  127; (* Anzahl Bausteine *)
maxt                     =   63; (* Anzahl Bausteine *)
maxz                     =   63; (* Anzahl Bausteine *)
maxkt                    =  999;
maxkz                    =  999;
maxopr                   :  array[1..anzopr] of integer = (-1,-1,-1,-1,-1,-1,-1);
maxyy                    = 9999;   (* year *)
maxym                    =   12;   (* month of year *)
maxyw                    =   53;   (* week of year *)
maxyd                    =  366;   (* day of year *)
maxdn                    =   31;   (* day of month *)
maxdw                    =    7;   (* day of week *)
maxdh                    =   23;   (* hour *)
maxdm                    =   59;   (* minute *)
maxds                    =   59;
yy                       :  word = 0;   (* year *)
ym                       :  word = 0;   (* month of year *)
yw                       :  word = 0;   (* week of year *)
yd                       :  word = 0;   (* day of year *)
dn                       :  word = 0;   (* day of month *)
dw                       :  word = 0;   (* day of week *)
dh                       :  word = 0;   (* hour *)
dm                       :  word = 0;   (* minute *)
ds                       :  word = 0;   (* second *)
old_ds                   :  word = 0;   (* old second for m 127,6 *)
dd                       :  word = 0;   (* metec *)
dise                     =    3; (* Anzahl auf Bildschirm *)
disa                     =    3; (* Anzahl auf Bildschirm *)
dism                     =    9; (* Anzahl auf Bildschirm *)
dist                     =   15; (* Anzahl auf Bildschirm *)
disz                     =   15; (* Anzahl auf Bildschirm *)
disaw                    =    6;
deep                     =    6;
eins                     :  string                      =  '*';
null                     :  string                      =  ' ';
es                       :  integer                   =    2;
ez                       :  integer                   =    3;
_as                      :  integer                   =   49;
az                       :  integer                   =    3;
ms                       :  integer                   =    1;
mz                       :  integer                   =   22;
ts                       :  integer                   =    2;
tz                       :  integer                   =    5;
ti                       :  integer                   =   14;
zs                       :  integer                   =   75;
zz                       :  integer                   =    5;
zi                       :  integer                   =   63;
scrollstart              :  word                      =    1;
scrollende               :  word                      =    1;
speed                    :  word                      =  100;
delay_                   :  word                      =  500;
spstyp                   :  string[10]                =  ' S5-1XX U ';

operationen              :  array[1..maxoperationen] of string[3] =
                           ('=','S','SI','SV','SE','SS','SA',
                            'R','ZR','ZV','L',
                            'U','O','UN','ON','BE','BEB',
                            ')','U(','O(','UN(','ON(');

fehlermeldung            :  array[1..10] of string[40]=
                           ('Last 2 actual instruction ???',
                            'Too many or unbalanced ()',
                            'Operation missing',
                            'Operation unknown',
                            'Operand u/o Segm./BitNo not ok',
                            'Operand not allowable',
                            'Operand missing',
                            'Segment/BitNo wrong format',
                            'Segment or Bitnumber missing',
                            'Segment/BitNo over Maximum');

mess                     :  array[1..11] of string[40]=
                           (' Instruction list was processed...',
                            ' Simulation terminated...',
                            ' Documentation generated...',
                            ' PRINT program finished...',
                            ' EDIT program finished...',
                            ' Program not found...',
                            ' Function aborted...',
                            ' Instruction list has errors...',
                            ' Not enough memory free...',
                            ' Not enough free space on disk...',
                            ' System error...');

var
key			 :  char;
ja			 :  boolean;
wahl : integer;
line                     :  string;
meldung                  :  string[40];
bststr                   :  string[6];
bitstr                   :  string[6];
lr                       :  string[8];
ext                      :  extension;
filename                 :  string;
lst,
infile,
outfile                  :  text;
save_attr                :  byte;
newoutbyte,
oldoutbyte               :  byte;
i,ii,j,jj,
bst,bit,
status,
klammern,
anzaw,
aktaw                    :  integer;
mono,
lastausgang,
oder_von_und,
korrektur,
scroll,
upd,
sende                    :  boolean;
lastaw,
aw                       :  awtyp;
awl                      :  array[1..  maxaw] of awrec;
e_                       :  array[0..   maxe,0..7] of boolean;
a_                       :  array[0..   maxa,0..7] of boolean;
m_                       :  array[0..   maxm,0..7] of boolean;
akku                     :  t_rec;
t_                       :  array[0..   maxt] of t_rec;
z_                       :  array[0..   maxz] of z_rec;
yy_                      :  boolean;    (* year *)
ym_                      :  boolean;    (* month of year *)
yw_                      :  boolean;    (* week of year *)
yd_                      :  boolean;    (* day of year *)
dn_                      :  boolean;    (* day of month *)
dw_                      :  boolean;    (* day of week *)
dh_                      :  boolean;    (* hour *)
dm_                      :  boolean;    (* minute *)
ds_                      :  boolean;    (* second *)
ausgang                  :  array[1..   deep] of boolean;
opr                      :  array[1..   deep] of string[2];
(*------- end of s5.var -----------*)
(*------- begin of extend -----------*)
procedure readline;
begin
  line:='';
  repeat
    read(key);
    if (key<>#13) then line:=line+key;
  until (key=#13);
end;

function getkey : char;
begin
  read(key);
end;

procedure write_screen(x,y : integer; s : string);
begin  (*write_screen(43,18,'Baustein:     ');*)
  gotoxy(x,y); write(s);
end;

function read_int(b : boolean; l,v,u,o : integer) : integer;
var i,j : integer;
begin  (*bst := read_int(false,3,0,0,999);*)
  readline;
  val(line,i,j);
  read_int:=i;
end;

function int_to_str(i,l : integer) : string;
var s : string;
begin  (*write_screen(53,10,int_to_str(baustein,3));*)
  str(i:l,s);
  int_to_str:=s;
end;

procedure message(s : string);
begin
  gotoxy(1,25); write(s); getkey;
end;

function upstring(s : string) : string;
var i : integer;
    l : string;
begin
  l:='';
  for i := 1 to length(s) do l:=l+upcase(s[i]);
  upstring:=l;
end;

procedure printout(c : char);
begin
  write(lst,c);
end;

procedure outlpr_upd;
const
power2             :  array[0..7] of byte = (1,2,4,8,16,32,64,128);
begin
  newoutbyte       := 0;
  for i            := 0 to 7 do
  begin
    if a_[0,i] = true then
      newoutbyte   := newoutbyte + power2[i];
  end;
  if newoutbyte <> oldoutbyte then
  begin
    oldoutbyte     := newoutbyte;
    PrintOut(char(newoutbyte));
  end;
end;
(*------- end of extend -----------*)
(*------- begin of s5.inc -----------*)
procedure syntax_check (s : awtyp);

var
oende,
pende,
zende,
bitwert,
bstadr                   :  boolean;
max                      :  word;
operationstr,
operandstr,
bststr,
bitstr                   :  awtyp;


procedure p_oende;

begin
  if not pende then
  begin
    oende                := true;
    operandstr           := operandstr  + s[i];
  end
  else
    bststr               := bststr      + s[i];
end;


begin
  oende                  := false;
  pende                  := false;
  sende                  := false;
  zende                  := false;
  bitwert                := true;
  bstadr                 := true;
  status                 := 0;
  operationstr           := '';
  operandstr             := '';
  bststr                 := '';
  bitstr                 := '';

  for i                  := 1 to length(s) do
  begin
    case s[i] of
      'M','K','T',
      'Y','D','J','I'    :  p_oende;
      'A'                :  if ((i = 2) and (operationstr[1] = 'S') and (s[i+1] = 'T')) then
                            begin
                              operationstr   := operationstr+ s[i]
                            end
                            else
                              p_oende;
      'E'                :  if ((i = 2) and (operationstr[1] in ['B','S'])) then
                            begin
                              operationstr   := operationstr+ s[i]
                            end
                            else
                              p_oende;
      'Z'                :  if (i > 1) then
                              p_oende
                            else
                              operationstr   := operationstr+ s[i];

      '.'                :  bstadr           := false;

      '0'..'9'           :  if bstadr then
                            begin
                              pende          := true;
                              bststr         := bststr      + s[i];
                            end
                            else
                              bitstr         := bitstr      + s[i];
    else
      if not oende then
        operationstr     := operationstr + s[i]
      else
        if not pende then
          operandstr     := operandstr   + s[i]
        else
          if bstadr then
            bststr       := bststr       + s[i]
          else
            bitstr       := bitstr       + s[i];
    end;
  end;

  if (length(operationstr) = 0) then
    status               := -3;

  if (status = 0) then
  begin
    j                    := 0;
    for i                := 1 to maxoperationen do
      if (operationstr = operationen[i]) then
        j                := i;
    if (j = 0) then
      status             := -4
    else if ((j in [3..7]) and (operandstr <> 'T')) then
      status             := -6
    else
      status             := 0;
    if (j < 11) then
      sende              := true;      (* Strompfadende *)
    if (j > 15) then
      zende              := true;      (* Bausteinende/Klammern *)

    if (j = 18) then                   (* KLammer Zu *)
      klammern           := pred(klammern);
    if (j > 18) then                   (* Operation+Klammer Auf *)
      klammern           := succ(klammern);

  end;

  if (status = 0) then
  begin
    if zende and ((length(operandstr) > 0) or (length(bststr) > 0)) then
      status             := -5;
    if not zende then
      if (length(operandstr) = 0) then
        status           := -7
      else
        if (length(bststr) = 0) then
          status         := -9;
  end;

  if (status = 0) and not zende then
    if (length(operandstr)=1) and (operandstr[1] in ['E','A','M','T','Z']) then
      status             := 0
    else
      if ((length(operandstr)=2) and (operandstr[1] = 'K') and (operandstr[2] in ['T','Z'])) then
        status           := 0          (* L KT/Z ... *)
      else
      if ((length(operandstr)=2) and (operandstr[1] = 'Y') and (operandstr[2] in ['Y','M','W','D'])) then
        status           := 0          (* Y/YMWD ... *)
      else
      if ((length(operandstr)=2) and (operandstr[1] = 'D') and (operandstr[2] in ['N','M','W','H','S','D'])) then
        status           := 0          (* D/NWHMSD ... *)
      else
      if ((length(operandstr)=2) and (operandstr[1] = 'J') and (operandstr[2] in ['X','Y'])) then
        status           := 0          (* J/XY ... *)
      else
      if ((length(operandstr)=2) and (operandstr[1] = 'I') and (operandstr[2] in ['A'..'F'])) then
        status           := 0          (* I/A-F ... *)
      else
        status           := -6;

  if ((operandstr[1] in ['T','Z','Y','D']) or  ((operandstr[1] = 'K') and (operandstr[2] = 'Z'))) then
    bitwert              := false;

  if (status = 0) and not zende then
  begin
    status               := -8;
    val(bststr,bst,ii);
    val(bitstr,bit,jj);

    if ((ii = 0) and ((jj = 0) and (bit in [0..7])) or not bitwert) then
    begin
        status           := -10;
        case operandstr[1] of
          'E'            :  if (bst <= maxe) then
                            begin
                              status   := 0;
                              if (maxopr[1] < bst) then
                                maxopr[1]:= bst;
                            end;
          'A'            :  if (bst <= maxa) then
                            begin
                              status   := 0;
                              if (maxopr[2] < bst) then
                                maxopr[2]:= bst;
                            end;
          'M'            :  if (bst <= maxm) then
                            begin
                              status   := 0;
                              if (maxopr[3] < bst) then
                                maxopr[3]:= bst;
                            end;
          'T'            :  if (bst <= maxt) then
                            begin
                              status   := 0;
                              if (maxopr[4] < bst) then
                                maxopr[4]:= bst;
                            end;
          'Z'            :  if (bst <= maxz) then
                            begin
                              status   := 0;
                              if (maxopr[5] < bst) then
                                maxopr[5]:= bst;
                            end;
        end;
        case operandstr[2] of
          'T'            :  if (bst <= maxkt) and (bit in [0..3]) then max := maxkt;
          'Z'            :  if (bst <= maxkz) then max := maxkz;
          'D'            :  if (operandstr[1] = 'Y') then
                            if (bst <= maxyd) then max := maxyd;
          'H'            :  if (bst <= maxdh) then max := maxdh;
          'S'            :  if (bst <= maxds) then max := maxds;
          'N'            :  if (bst <= maxdn) then max := maxdn;
          'M'            :  if (operandstr[1] = 'Y') then max := maxym
                                                     else max := maxdm;
          'W'            :  if (operandstr[1] = 'Y') then max := maxyw
                                                     else max := maxdw;
        end;
        if (bst <= max) then status := 0;
    end;
  end;

  (* Oder von Und *)
  if ((operationstr = 'O') and (operandstr = '')) then
  begin
    zende                := true;
    status               := 0;
  end;

  if (status = 0) then
  begin
    with awl[anzaw] do
    begin
      operation          := operationstr;
      if zende then
      begin
        operand          := '';
        baustein         := -1;
        bitnr            := -1;
      end
      else
      begin
        operand          := operandstr;
        baustein         := bst;
        if bitwert then
          bitnr          := bit
        else
          bitnr          := -1;
      end;
    end;
    if (operationstr = 'BE') then
      status             := 1;
  end;
  gotoxy (17, 4);
  write  (' - ',operationstr,' ',operandstr,' ',bststr,'.',bitstr,' ');
end;

procedure fehlerbehandlung;
begin
  gotoxy ( 2, 6);
  write  ('Error detected   - ');
  writeln(fehlermeldung[abs(status)]);

  if (status < -2) then
  begin
    gotoxy ( 2, 8);
    write  ('New Instruction: ');
    readln (aw);
    if (aw > ' ') then
    begin
      status             := 2;
      anzaw              := pred(anzaw);
      korrektur          := true;
      gotoxy ( 1, 6);
      clreol;
      gotoxy ( 1, 8);
      clreol;
    end;
  end;
end;
(*------- end of s5.inc -----------*)
(*------- begin of s5.sim -----------*)
procedure get_bst_bit;
begin
  write_screen(43,18,'Segment :     ');
  gotoxy(53,18);
  bst              := read_int(false,3,0,0,999);
  write_screen(43,18,'Bit     :     ');
  gotoxy(53,18);
  bit              := read_int(false,3,0,0,7);
  write_screen(43,18,'    X=Exit    ');
  gotoxy (46,18);
end;

procedure led(_on : boolean; max,bst,bit,offsp,offz : integer);
begin
  if (bst <= max) then
  begin
    textcolor(14);
    if _on then
      write_screen(bst*8+bit+offsp,offz,eins)
    else
      write_screen(bst*8+bit+offsp,offz,null);
    normvideo;
  end;
end;

procedure ti_upd( bst,w : integer; b : boolean);
begin
  if b then
    t_[bst].wert   := t_[bst].wert + w
  else
    t_[bst].wert   := w;

  if (t_[bst].wert < 0) then
    t_[bst].wert   := 0;
  if (t_[bst].wert > maxkt) then
    t_[bst].wert   := maxkt;

  write_screen(ti,bst+tz,int_to_str(t_[bst].wert,5));
  if not b then
    write_screen(ts,bst+tz,int_to_str(t_[bst].wert,3)+'.'+int_to_str(t_[bst].einheit,1));
end;

procedure zi_upd( bst,w : integer; b : boolean);
begin
  if b then
    z_[bst].wert   := z_[bst].wert + w
  else
    z_[bst].wert   := w;

  if (z_[bst].wert < 0) then
    z_[bst].wert   := 0;
  if (z_[bst].wert > maxkz) then
    z_[bst].wert   := maxkz;

  write_screen(zi,bst+zz,int_to_str(z_[bst].wert,5));
  if not b then
    write_screen(zs,bst+zz,int_to_str(z_[bst].wert,5));
end;

procedure time_upd;
var
dummy : word;
begin
  gettime(dh,dm,ds,dummy);
  if (ds <> old_ds) then
  begin
    m_[127,6]      := not m_[127,6]; (* Toggle pro Sekunde *)
    old_ds         := ds;
  end;
  getdate(yy,ym,yd,dn);
  write_screen(49,4,int_to_str(yy,4));
  write_screen(54,4,int_to_str(ym,2));
  write_screen(57,4,int_to_str(yd,2));
  write_screen(23,4,int_to_str(dn,1));
  write_screen(25,4,int_to_str(dh,2));
  write_screen(28,4,int_to_str(dm,2));
  write_screen(31,4,int_to_str(ds,2));
end;

procedure speed_upd( w : integer );
begin
  speed                  := speed + w;
  if (speed < 1) then
    speed                := 100
  else if (speed > 100) then
    speed                := 1;
  write_screen(42,4,int_to_str(speed,3));
end;

procedure akku_upd( w,e : integer );
begin
  akku.einheit           := e;
  akku.wert              := w;
  write_screen(42,21,int_to_str(akku.wert,3));
  if (akku.einheit > -1) then
    write_screen(45,21,'.'+int_to_str(akku.einheit,1))
  else
    write_screen(45,21,'  ');
end;

procedure displ_upd;
var
i,j                      :  integer;
begin
  for j                  := scrollstart to scrollende do
  begin
    i                    := j - scrollstart;
    with awl[j] do
    begin
      write_screen(23,disaw+i,int_to_str(j,4));
      write_screen(28,disaw+i,'          ');
      write_screen(28,disaw+i,operation);
      write_screen(31,disaw+i,operand);
      if (baustein >= 0) then
      begin
        write_screen(33,disaw+i,int_to_str(baustein,3));
        if (bitnr >= 0) then
          write_screen(36,disaw+i,'.'+int_to_str(bitnr,1));
      end;
      write_screen(39,disaw+i,null);
      write_screen(41,disaw+i,null);
    end;
  end;
end;

procedure sim_untermenue;
begin
  write_screen(43, 8,'    E=Input     ');
  write_screen(43,10,'    A=Output    ');
  write_screen(43,12,'    M=Marker    ');
  write_screen(43,14,'                ');
  write_screen(43,16,'                ');
  write_screen(43,18,'    X=Exit      ');
  gotoxy (43,18);
  repeat
    getkey;
    case upcase(key) of
      'E'                :  begin
                              get_bst_bit;
                              if (bst <= maxe) then
                              begin
                                e_[bst,bit]  := not e_[bst,bit];
                                led(e_[bst,bit],dise,bst,bit,es,ez);
                              end;
                            end;
      'A'                :  begin
                              get_bst_bit;
                              if (bst <= maxa) then
                              begin
                                a_[bst,bit]  := not a_[bst,bit];
                                led(a_[bst,bit],disa,bst,bit,_as,az);
                              end;
                            end;
      'M'                :  begin
                              get_bst_bit;
                              if (bst <= maxm) then
                              begin
                                m_[bst,bit]  := not m_[bst,bit];
                                led(m_[bst,bit],dism,bst,bit,ms,mz);
                              end;
                            end;
    end;
    gotoxy (43,18);
  until (upcase(key) = 'X');
end;

procedure sim_anweisung;
var
dis_ja,
dis_aus                  :  boolean;
xoperation               :  awtyp;

begin
  with awl[aktaw] do
  begin
    if (operation[1] = 'B') then
    begin
      fillchar(ausgang,deep,#255);
      if (operation = 'BE') or lastausgang then
      begin
        aktaw            := 1;
        lastausgang      := false; (* ??? *)
        oder_von_und     := false;
        m_[127,7]        := not m_[127,7]; (* Toggle Merker pro Durchlauf *)
        if random(2)>0 then m_[127,5] := true else m_[127,5] := false;
        if m_[127,2] then
        begin            (* Exit immediately from Program *)
          halt;
        end;
        if m_[127,0] then outlpr_upd;
        if m_[126,7] then write(#7);
      end;
    end;
  end;
  if (aktaw = 1) then
  begin
    time_upd;
  end;
  with awl[aktaw] do
  begin
    xoperation           := operation;
    dis_ja               := false;
    dis_aus              := false;

    if (operand[1] = 'T') then ti_upd(baustein,-1,true); (* Pseudo Timer *)

    if (operand[1] in ['E','A','M','T','Z']) THEN
    begin
      case operand[1] of
        'E'              :  ja         := e_[baustein,bitnr];
        'A'              :  ja         := a_[baustein,bitnr];
        'M'              :  ja         := m_[baustein,bitnr];
        'T'              :  ja         := (t_[baustein].wert = 0);
        'Z'              :  ja         := (z_[baustein].wert = 0);
      end;
      dis_ja             := ja;
    end;
    if (operand[1] = 'Y') THEN
    begin
      case operand[2] of
        'Y'              :  ja         := (baustein < yy);
        'M'              :  ja         := (baustein < ym);
        'W'              :  ja         := (baustein < yw);
        'D'              :  ja         := (baustein < yd);
      end;
      dis_ja             := ja;
    end;
    if (operand[1] = 'D') THEN
    begin
      case operand[2] of
        'N'              :  ja         := (baustein < dn);
        'W'              :  ja         := (baustein < dw);
        'H'              :  ja         := (baustein < dh);
        'M'              :  ja         := (baustein < dm);
        'S'              :  ja         := (baustein < ds);
      end;
      dis_ja             := ja;
    end;

    if (xoperation = ')') then
    begin
      ja                 := ausgang[klammern];
      xoperation         := opr[klammern];
      klammern           := pred(klammern);
    end;
    if (xoperation = 'U') then
      ausgang[klammern]  := (ausgang[klammern] and ja)
    else if (xoperation = 'O') then
      ausgang[klammern]  := (ausgang[klammern] or  ja)
    else if (xoperation = 'UN') then
      ausgang[klammern]  := (ausgang[klammern] and not ja)
    else if (xoperation = 'ON') then
      ausgang[klammern]  := (ausgang[klammern] or  not ja);

    i                    := pos('(',operation);
    if (i > 1) then
    begin
      klammern           := succ(klammern);
      opr[klammern]      := copy(operation,1,i-1);
    end;

    if ((operation <> '=') and (operation[1] <> 'S') and (operation <> 'R')) then
      dis_aus            := ausgang[klammern];

    if (operation = '=') then
    begin
      dis_ja             := false;
      dis_aus            := (dis_aus or lastausgang or oder_von_und);
      case operand[1] of
        'E'              :  begin
                              e_[baustein,bitnr] := dis_aus;
                              led(e_[baustein,bitnr],dise,baustein,bitnr,es,ez);
                            end;
        'A'              :  begin
                              a_[baustein,bitnr] := dis_aus;
                              led(a_[baustein,bitnr],disa,baustein,bitnr,_as,az);
                            end;
        'M'              :  begin
                              m_[baustein,bitnr] := dis_aus;
                              led(m_[baustein,bitnr],dism,baustein,bitnr,ms,mz);
                            end;
      end;
      fillchar(ausgang,deep,#255);
      oder_von_und       := false;
    end;

    if ((operation[1] = 'S') or (operation = 'R')) then
    begin
      dis_ja             := false;
      dis_aus            := (dis_aus or lastausgang or oder_von_und);
      if dis_aus then
      begin
      case operand[1] of
        'E'              :  begin
                              if (operation = 'S') then
                                e_[baustein,bitnr] := true
                              else
                                e_[baustein,bitnr] := false;
                              led(e_[baustein,bitnr],dise,baustein,bitnr,es,ez);
                            end;
        'A'              :  begin
                              if (operation = 'S') then
                                a_[baustein,bitnr] := true
                              else
                                a_[baustein,bitnr] := false;
                              led(a_[baustein,bitnr],disa,baustein,bitnr,_as,az);
                            end;
        'M'              :  begin
                              if (operation = 'S') then
                                m_[baustein,bitnr] := true
                              else
                                m_[baustein,bitnr] := false;
                              led(m_[baustein,bitnr],dism,baustein,bitnr,ms,mz);
                            end;
        'T'              :  begin
                              if (operation[1] = 'S') then
                              begin
                                t_[baustein].einheit := akku.einheit;
                                ti_upd(baustein,akku.wert,false);
                              end
                              else
                                ti_upd(baustein,0,false);
                            end;
        'Z'              :  begin
                              if (operation[1] = 'S') then
                                zi_upd(baustein,akku.wert,false)
                              else
                                zi_upd(baustein,0,false);
                            end;
      end;
      end;
      fillchar(ausgang,deep,#255);
      oder_von_und       := false;
    end;

    if ((operation = 'L') and (operand[1] = 'K')) then
    begin
      dis_ja             := false;
      dis_aus            := (dis_aus or lastausgang);
      if dis_aus then       (* ??? *)
      akku_upd(baustein,bitnr);
    end;

    if (operation[1] = 'Z') then
    begin
      dis_ja             := false;
      dis_aus            := (dis_aus or lastausgang or oder_von_und);
      if dis_aus then
      begin
      case operation[2] of
        'R'              :  begin
                              zi_upd(baustein,-1,true);
                            end;
        'V'              :  begin
                              zi_upd(baustein,+1,true);
                            end;
      end;
      end;
      fillchar(ausgang,deep,#255);
      oder_von_und       := false;
    end;

    lastausgang          := dis_aus;

    (* if (aktaw in [scrollstart..scrollende]) then *)
    if (aktaw >= scrollstart) and (aktaw <= scrollende) then
    begin
      j                  := disaw + (aktaw - scrollstart);
      led(dis_ja ,80,0,0,39,j);
      led(dis_aus,80,0,0,41,j);
    end;
    write_screen(44,10,int_to_str(aktaw,3));
    write_screen(48,10,operation + '        ');
    write_screen(51,10,operand + '       ');
    if (baustein >= 0) then
    begin
      write_screen(53,10,int_to_str(baustein,3));
      if (bitnr >= 0) then
        write_screen(56,10,'.'+int_to_str(bitnr,1));
    end;
  end;

  aktaw                  := succ(aktaw);

  for i                  := speed to 100 do
    for j                := 1 to delay_ do;
end;

procedure change_e(bst,bit : integer);
begin
  e_[bst,bit]  := not e_[bst,bit];
  led(e_[bst,bit],dise,bst,bit,es,ez);
end;

procedure ftaste;
begin
  case ord(key) of
   49.. 59 (* '1'-'0' *) :  change_e(0,ord(key)-49);
    65                   :  if (scroll and (scrollstart > 1)) then
                            begin
                              dec(scrollstart);
                              dec(scrollende);
                              displ_upd;
                            end;
    66                   :  if (scroll and (scrollende < anzaw)) then
                            begin
                              inc(scrollstart);
                              inc(scrollende);
                              displ_upd;
                            end;
    67                   :  speed_upd(1);
    68                   :  speed_upd(-1);
  end;
end;

procedure sim_hauptmenue;
var
i,j                      :  integer;
begin
  write_screen(43, 8,'   V=Modify     ');
  write_screen(43,10,'[   ]           ');
  write_screen(43,12,'   E=Single Step');
  write_screen(43,14,'   S=Start Prg. ');
  write_screen(43,16,'   S=Stop  Prg. ');
  write_screen(43,18,'   Q=Quit  Prg. ');
  displ_upd;
  m_[127,7]        := false; (* Init Toggle Merker pro Durchlauf *)
  repeat
    gotoxy (43,18);
    getkey;
    ftaste;
      case upcase(key) of
        'E'              :  sim_anweisung;
        'S'              :  repeat
                              while ((aktaw <= anzaw) and not keypressed) do
                                sim_anweisung;
                              if keypressed then
                                key  := upcase(readkey);
                            until (key = 'S');
      end;
  until ((upcase(key) = 'Q') or (upcase(key) = 'V'));
end;


procedure sim_init;
begin
  for j            := 0 to maxe do
    for i          := 0 to 7 do
      e_[j,i]      := false;
  for j            := 0 to maxa do
    for i          := 0 to 7 do
      a_[j,i]      := false;
  for j            := 0 to maxm do
    for i          := 0 to 7 do
      m_[j,i]      := false;
  for j            := 0 to maxt do
  begin
    t_[j].wert     := 0; (* ??? *)
    t_[j].einheit  := 0;
  end;
  for j            := 0 to maxz do
    z_[j].wert     := 0; (* ??? *)

  fillchar(ausgang,deep,#255);
  lastausgang            := false;
  oder_von_und           := false;
  aktaw                  := 1;
  klammern               := 1;
  scrollstart            := 1;
  if (anzaw < 15) then
  begin
    scroll               := false;
    scrollende           := anzaw;
  end
  else
  begin
    scroll               := true;
    scrollende           := 14;
  end;
  clrscr;
  textbackground(2);
  write_screen(1,1, 'E00000000111111112222222233333333');
  normvideo;
  write_screen(34,1,'     S5ppc    ');
  textbackground(4);
  write_screen(48,1,'A00000000111111112222222233333333');
  (*normvideo;*)
  textbackground(2);
  write_screen(1,2, 'E01234567012345670123456701234567');
  normvideo;
  write_screen(34,2,'  (c) P.Sieg  ');
  textbackground(4);
  write_screen(48,2,'A01234567012345670123456701234567');
  normvideo;

  write_screen(1, 4,' Target     Actual                                            Actual     Target ');
  write_screen(1, 5,'[-----] T 0 [-----] +-----+----------+-+-+-----------------+ [-----] Z 0 [-----]');
  write_screen(1, 6,'[-----] T 1 [-----] |     |          | | |                 | [-----] Z 1 [-----]');
  write_screen(1, 7,'[-----] T 2 [-----] |     |          | | |                 | [-----] Z 2 [-----]');
  write_screen(1, 8,'[-----] T 3 [-----] |     |          | | |                 | [-----] Z 3 [-----]');
  write_screen(1, 9,'[-----] T 4 [-----] |     |          | | |                 | [-----] Z 4 [-----]');
  write_screen(1,10,'[-----] T 5 [-----] |     |          | | |                 | [-----] Z 5 [-----]');
  write_screen(1,11,'[-----] T 6 [-----] |     |          | | |                 | [-----] Z 6 [-----]');
  write_screen(1,12,'[-----] T 7 [-----] |     |          | | |                 | [-----] Z 7 [-----]');
  write_screen(1,13,'[-----] T 8 [-----] |     |          | | |                 | [-----] Z 8 [-----]');
  write_screen(1,14,'[-----] T 9 [-----] |     |          | | |                 | [-----] Z 9 [-----]');
  write_screen(1,15,'[-----] T10 [-----] |     |          | | |                 | [-----] Z10 [-----]');
  write_screen(1,16,'[-----] T11 [-----] |     |          | | |                 | [-----] Z11 [-----]');
  write_screen(1,17,'[-----] T12 [-----] |     |          | | |                 | [-----] Z12 [-----]');
  write_screen(1,18,'[-----] T13 [-----] |     |          | | |                 | [-----] Z13 [-----]');
  write_screen(1,19,'[-----] T14 [-----] |     |          | | |                 | [-----] Z14 [-----]');
  write_screen(1,20,'[-----] T15 [-----] +-----+----------+-+-+-----------------+ [-----] Z15 [-----]');
  write_screen(1,21,'       Timer                                                       Counter      ');

  textbackground(1);
  write_screen(1,23,'00000000111111112222222233333333444444445555555566666666777777778888888899999999');
  write_screen(1,24,'01234567012345670123456701234567012345670123456701234567012345670123456701234567');
  normvideo;
end;


procedure simulation;
begin
  sim_init;
  repeat
    sim_hauptmenue;
    if (upcase(key) = 'V') then
    begin
      sim_untermenue;
    end;
  until (upcase(key) = 'Q');
  message(mess[2])
end;
(*------- end of s5.sim -----------*)

procedure einlesen;
begin
  anzaw                  := 0;
  klammern               := 0;
  status                 := 0;
  lastaw                 := '';
  while ((status >= 0) and not eof(infile)) do
  begin
    readln (infile,aw);
    repeat
      gotoxy ( 1, 4);
      clreol;
      anzaw              := succ(anzaw);
      write  (' [',anzaw:4,'] ',aw);
      syntax_check(aw);
      if (lastaw = aw) and not (aw = ')') then
        status           := -1;
      if (pos('(',lastaw) > 0) and (aw = ')') then
        status           := -1;
      if (klammern > deep) then
        status           := -2;
      if (status = 0) and sende then
        if (klammern <> 0) then
          status         := -2;
      if (status = 0) then
        lastaw           := aw;
      if (status < 0) then
        fehlerbehandlung;
    until (status <> 2);
  end;
  if (status <> 1) then
  begin
    if (status = 0) then
      message(mess[8])
    else
      message(mess[7]);
    getkey;
  end;
end;

procedure get_awl;
begin
  for i := 1 to anzopr do maxopr[i] := -1;
  status                 := 0;
  korrektur              := false;
  clrscr;
  write('Filename : '); readline;
  filename:=line;
  if (filename <> '') then
  begin
  writeln(' Reading ',filename,'...');
  assign (infile,filename);
  reset  (infile);
  einlesen;
  close  (infile);
  if (status = 1) then
  begin
    if korrektur then
    begin
      rewrite(infile);
      for i            := 1 to anzaw do
      begin
        with awl[i] do
        begin
          write  (infile,operation);
          write  (infile,operand);
          if (baustein = -1) then
            writeln(infile)
          else
          begin
            write  (infile,baustein);
            if (bitnr  = -1) then
              writeln(infile)
            else
              writeln(infile,'.',bitnr);
          end;
        end;
      end;
      close  (infile);
    end;
    message(mess[1]);
  end
  else
    message(mess[8]);
  end
  else
    message(mess[7]);
end;

begin
  status                 := -1;
  speed	                 := 100;
  assign (lst,'PRN');
  append (lst);
  repeat
    randomize;
    clrscr;
    writeln('1=Read AWL');
    writeln('2=Simulation');
    writeln('3=Exit');
    readline;
    val(line,wahl,i);

    case wahl of
      1                :  get_awl;
      2                :  begin
                              if (status <> 1) then
                                get_awl;
                              if (status = 1) then
                              begin
                                simulation;
                              end;
                            end;
    end;
  until (wahl = 3);
  close (lst);
end.
