program s5;

(*$M 8192,0,90000 *)

(***
#include "child.h"
***)

uses dos,crt;

const
copyright = 'S5 (c) Peter Sieg 03-Jan-1998';

type
dateiname                =  string[12];
extension                =  string[3];
awtyp                    =  string[9];
awrec                    =  record
                              operation : string[3];
                              operand   : string[2];
                              baustein  : integer;
                              bitnr     : integer;
                            end;
t_rec                    =  record
                              einheit   : integer;
                              wert      : integer;
                            end;
z_rec                    =  record
                              wert      : integer;
                            end;

const
anzopr                   =    7;
maxoperationen           =   22;
maxaw                    =  512;
maxe                     =   31; (* Anzahl Bausteine *)
maxa                     =   31; (* Anzahl Bausteine *)
maxm                     =  127; (* Anzahl Bausteine *)
maxt                     =   63; (* Anzahl Bausteine *)
maxz                     =   63; (* Anzahl Bausteine *)
maxkt                    =  999;
maxkz                    =  999;
maxopr                   :  array[1..anzopr] of integer = (-1,-1,-1,-1,-1,-1,-1);
maxyy                    = 9999;   (* year *)
maxym                    =   12;   (* month of year *)
maxyw                    =   53;   (* week of year *)
maxyd                    =  366;   (* day of year *)
maxdn                    =   31;   (* day of month *)
maxdw                    =    7;   (* day of week *)
maxdh                    =   23;   (* hour *)
maxdm                    =   59;   (* minute *)
maxds                    =   59;
yy                       :  word = 0;   (* year *)
ym                       :  word = 0;   (* month of year *)
yw                       :  word = 0;   (* week of year *)
yd                       :  word = 0;   (* day of year *)
dn                       :  word = 0;   (* day of month *)
dw                       :  word = 0;   (* day of week *)
dh                       :  word = 0;   (* hour *)
dm                       :  word = 0;   (* minute *)
ds                       :  word = 0;   (* second *)
old_ds                   :  word = 0;   (* old second for m 127,6 *)
dd                       :  word = 0;   (* metec *)
dise                     =    3; (* Anzahl auf Bildschirm *)
disa                     =    3; (* Anzahl auf Bildschirm *)
dism                     =    9; (* Anzahl auf Bildschirm *)
dist                     =   15; (* Anzahl auf Bildschirm *)
disz                     =   15; (* Anzahl auf Bildschirm *)
disaw                    =    6;
deep                     =    6;
eins                     :  string                      =  '*';
null                     :  string                      =  ' ';
es                       :  integer                   =    2;
ez                       :  integer                   =    3;
as                       :  integer                   =   49;
az                       :  integer                   =    3;
ms                       :  integer                   =    1;
mz                       :  integer                   =   22;
ts                       :  integer                   =    2;
tz                       :  integer                   =    5;
ti                       :  integer                   =   14;
zs                       :  integer                   =   75;
zz                       :  integer                   =    5;
zi                       :  integer                   =   63;
scrollstart              :  word                      =    1;
scrollende               :  word                      =    1;
speed                    :  word                      =  100;
delay_                   :  word                      =  50000;
spstyp                   :  string[10]                =  ' S5-1XX U ';

operationen              :  array[1..maxoperationen] of string[3] =
                           ('=','S','SI','SV','SE','SS','SA',
                            'R','ZR','ZV','L',
                            'U','O','UN','ON','BE','BEB',
                            ')','U(','O(','UN(','ON(');

fehlermeldung            :  array[1..10] of string[40]=
                           ('Last 2 actual instruction ???',
                            'Too many or unbalanced ()',
                            'Operation missing',
                            'Operation unknown',
                            'Operand or Segm./BitNo not ok',
                            'Operand not allowable',
                            'Operand missing',
                            'Segment/BitNo wrong format',
                            'Segment or Bitnumber missing',
                            'Segment/BitNo over Maximum');

mess                     :  array[1..11] of string[40]=
                           (' Instruction list was processed...',
                            ' Simulation terminated...',
                            ' Documentation generated...',
                            ' PRINT program finished...',
                            ' EDIT program finished...',
                            ' Program not found...',
                            ' Function aborted...',
                            ' Instruction list has errors...',
                            ' Not enough memory free...',
                            ' Not enough free space on disk...',
                            ' System error...');

var
childpid                 :  integer;
read_from,write_to       :  file;
key			 :  char;
ja			 :  boolean;
wahl : integer;
line,s                   :  string;
meldung                  :  string[40];
bststr                   :  string[6];
bitstr                   :  string[6];
lr                       :  string[8];
ext                      :  extension;
filename                 :  string;
lst,
infile,
outfile                  :  text;
save_attr                :  byte;
newoutbyte,
oldoutbyte               :  byte;
i,ii,j,jj,
bst,bit,
status,
klammern,
anzaw,
aktaw                    :  integer;
wish,
lastausgang,
oder_von_und,
korrektur,
scroll,
upd,
sende                    :  boolean;
lastaw,
aw                       :  awtyp;
awl                      :  array[1..  maxaw] of awrec;
e_                       :  array[0..   maxe,0..7] of boolean;
a_                       :  array[0..   maxa,0..7] of boolean;
m_                       :  array[0..   maxm,0..7] of boolean;
akku                     :  t_rec;
t_                       :  array[0..   maxt] of t_rec;
z_                       :  array[0..   maxz] of z_rec;
yy_                      :  boolean;    (* year *)
ym_                      :  boolean;    (* month of year *)
yw_                      :  boolean;    (* week of year *)
yd_                      :  boolean;    (* day of year *)
dn_                      :  boolean;    (* day of month *)
dw_                      :  boolean;    (* day of week *)
dh_                      :  boolean;    (* hour *)
dm_                      :  boolean;    (* minute *)
ds_                      :  boolean;    (* second *)
ausgang                  :  array[1..   deep] of boolean;
opr                      :  array[1..   deep] of string[2];
nodisplay                :  boolean;

function keypressed : boolean;
begin
  keypressed:=true;
end;

function readkey : char;
begin
  readkey:=#13;
end;

function _randint : boolean;
begin
  _randint:=false;
end;

procedure randomize;
begin
end;

procedure outlpr_upd;
const
power2             :  array[0..7] of byte = (1,2,4,8,16,32,64,128);
begin
  newoutbyte       := 0;
  for i            := 0 to 7 do
  begin
    if a_[0,i] = true then
      newoutbyte   := newoutbyte + power2[i];
  end;
  if newoutbyte <> oldoutbyte then
  begin
    oldoutbyte     := newoutbyte;
    if m_[127,0] then
    begin
      write(lst,char(newoutbyte));
      fflush(lst);
    end;
  end;
end;

procedure clrscr;
begin
  write(#27,'[2J');
  write(#27,'[1;1H');
end;

function read_int(b : boolean; l,v,u,o : integer) : integer;
var i : integer;
begin  (*bst := read_int(false,3,0,0,999);*)
  readln(i);
  read_int:=i;
end;

function int_to_str(i,l : integer) : string;
var s : string;
begin  (*write_screen(53,10,int_to_str(baustein,3));*)
  str(i:l,s);
  int_to_str:=s;
end;

procedure message(s : string);
begin
  if wish then
  begin
    writeln(write_to,'set msg "',s,'"');
    fflush(write_to);
  end
  else begin writeln; write(s); readln; end; 
end;

function upstring(s : string) : string;
var i : integer;
    l : string;
begin
  l:='';
  for i := 1 to length(s) do l:=l+upcase(s[i]);
  upstring:=l;
end;

procedure gettime(var dh,dm,ds,dummy : word);
begin  (*gettime(dh,dm,ds,dummy);*)
(*decodetime(now,dh,dm,ds,dummy);*)
  dh:=17;
  dm:=30;
  ds:=45;
  dummy:=0;
end;

procedure getdate(var yy,ym,yd,dn : word);
begin  (*getdate(yy,ym,yd,dn);*)
  yy:=1963;
  ym:=12;
  yd:=26;
  dn:=0;
end;

function getkey : char;
var wahl : string;
begin
  readln(wahl);
  getkey:=wahl[1];
end;

procedure syntax_check (s : awtyp);
var
oende,
pende,
zende,
bitwert,
bstadr                   :  boolean;
max                      :  word;
operationstr,
operandstr,
bststr,
bitstr                   :  awtyp;

procedure p_oende;
begin
  if not pende then
  begin
    oende                := true;
    operandstr           := operandstr  + s[i];
  end
  else
    bststr               := bststr      + s[i];
end;

begin
  oende                  := false;
  pende                  := false;
  sende                  := false;
  zende                  := false;
  bitwert                := true;
  bstadr                 := true;
  status                 := 0;
  operationstr           := '';
  operandstr             := '';
  bststr                 := '';
  bitstr                 := '';

  for i                  := 1 to length(s) do
  begin
    case s[i] of
      'M','K','T',
      'Y','D','J','I'    :  p_oende;
      'A'                :  if ((i = 2) and (operationstr[1] = 'S') and (s[i+1] = 'T')) then
                            begin
                              operationstr   := operationstr+ s[i]
                            end
                            else
                              p_oende;
      'E'                :  if ((i = 2) and (operationstr[1] in ['B','S'])) then
                            begin
                              operationstr   := operationstr+ s[i]
                            end
                            else
                              p_oende;
      'Z'                :  if (i > 1) then
                              p_oende
                            else
                              operationstr   := operationstr+ s[i];

      '.'                :  bstadr           := false;

      '0'..'9'           :  if bstadr then
                            begin
                              pende          := true;
                              bststr         := bststr      + s[i];
                            end
                            else
                              bitstr         := bitstr      + s[i];
    else
      if not oende then
        operationstr     := operationstr + s[i]
      else
        if not pende then
          operandstr     := operandstr   + s[i]
        else
          if bstadr then
            bststr       := bststr       + s[i]
          else
            bitstr       := bitstr       + s[i];
    end;
  end;

  if (length(operationstr) = 0) then
    status               := -3;

  if (status = 0) then
  begin
    j                    := 0;
    for i                := 1 to maxoperationen do
      if (operationstr = operationen[i]) then
        j                := i;
    if (j = 0) then
      status             := -4
    else if ((j in [3..7]) and (operandstr <> 'T')) then
      status             := -6
    else
      status             := 0;
    if (j < 11) then
      sende              := true;      (* Strompfadende *)
    if (j > 15) then
      zende              := true;      (* Bausteinende/Klammern *)

    if (j = 18) then                   (* KLammer Zu *)
      klammern           := pred(klammern);
    if (j > 18) then                   (* Operation+Klammer Auf *)
      klammern           := succ(klammern);

  end;

  if (status = 0) then
  begin
    if zende and ((length(operandstr) > 0) or (length(bststr) > 0)) then
      status             := -5;
    if not zende then
      if (length(operandstr) = 0) then
        status           := -7
      else
        if (length(bststr) = 0) then
          status         := -9;
  end;

  if (status = 0) and not zende then
    if (length(operandstr)=1) and (operandstr[1] in ['E','A','M','T','Z']) then
      status             := 0
    else
      if ((length(operandstr)=2) and (operandstr[1] = 'K') and (operandstr[2] in ['T','Z'])) then
        status           := 0          (* L KT/Z ... *)
      else
      if ((length(operandstr)=2) and (operandstr[1] = 'Y') and (operandstr[2] in ['Y','M','W','D'])) then
        status           := 0          (* Y/YMWD ... *)
      else
      if ((length(operandstr)=2) and (operandstr[1] = 'D') and (operandstr[2] in ['N','M','W','H','S','D'])) then
        status           := 0          (* D/NWHMSD ... *)
      else
      if ((length(operandstr)=2) and (operandstr[1] = 'J') and (operandstr[2] in ['X','Y'])) then
        status           := 0          (* J/XY ... *)
      else
      if ((length(operandstr)=2) and (operandstr[1] = 'I') and (operandstr[2] in ['A'..'F'])) then
        status           := 0          (* I/A-F ... *)
      else
        status           := -6;

  if ((operandstr[1] in ['T','Z','Y','D']) or  ((operandstr[1] = 'K') and (operandstr[2] = 'Z'))) then
    bitwert              := false;

  if (status = 0) and not zende then
  begin
    status               := -8;
    val(bststr,bst,ii);
    val(bitstr,bit,jj);

    if ((ii = 0) and ((jj = 0) and (bit in [0..7])) or not bitwert) then
    begin
        status           := -10;
        case operandstr[1] of
          'E'            :  if (bst <= maxe) then
                            begin
                              status   := 0;
                              if (maxopr[1] < bst) then
                                maxopr[1]:= bst;
                            end;
          'A'            :  if (bst <= maxa) then
                            begin
                              status   := 0;
                              if (maxopr[2] < bst) then
                                maxopr[2]:= bst;
                            end;
          'M'            :  if (bst <= maxm) then
                            begin
                              status   := 0;
                              if (maxopr[3] < bst) then
                                maxopr[3]:= bst;
                            end;
          'T'            :  if (bst <= maxt) then
                            begin
                              status   := 0;
                              if (maxopr[4] < bst) then
                                maxopr[4]:= bst;
                            end;
          'Z'            :  if (bst <= maxz) then
                            begin
                              status   := 0;
                              if (maxopr[5] < bst) then
                                maxopr[5]:= bst;
                            end;
        end;
        case operandstr[2] of
          'T'            :  if (bst <= maxkt) and (bit in [0..3]) then max := maxkt;
          'Z'            :  if (bst <= maxkz) then max := maxkz;
          'D'            :  if (operandstr[1] = 'Y') then
                            if (bst <= maxyd) then max := maxyd;
          'H'            :  if (bst <= maxdh) then max := maxdh;
          'S'            :  if (bst <= maxds) then max := maxds;
          'N'            :  if (bst <= maxdn) then max := maxdn;
          'M'            :  if (operandstr[1] = 'Y') then max := maxym
                                                     else max := maxdm;
          'W'            :  if (operandstr[1] = 'Y') then max := maxyw
                                                     else max := maxdw;
        end;
        if (bst <= max) then status := 0;
    end;
  end;

  (* Oder von Und *)
  if ((operationstr = 'O') and (operandstr = '')) then
  begin
    zende                := true;
    status               := 0;
  end;

  if (status = 0) then
  begin
    with awl[anzaw] do
    begin
      operation          := operationstr;
      if zende then
      begin
        operand          := '';
        baustein         := -1;
        bitnr            := -1;
      end
      else
      begin
        operand          := operandstr;
        baustein         := bst;
        if bitwert then
          bitnr          := bit
        else
          bitnr          := -1;
      end;
    end;
    if (operationstr = 'BE') then
      status             := 1;
  end;
  writeln  (' - ',operationstr:3,' ',operandstr:3,' ',bststr:3,'.',bitstr:1,' ');
end;

procedure fehlerbehandlung;
begin
  write  ('Error detected   - ');
  writeln(fehlermeldung[abs(status)]);

  if (status < -2) then
  begin
    write  ('New Instruction: ');
    readln (aw);
    if (aw > ' ') then
    begin
      status             := 2;
      anzaw              := pred(anzaw);
      korrektur          := true;
    end;
  end;
end;

procedure get_bst_bit;
begin
  write('Segment : ');
  bst              := read_int(false,3,0,0,999);
  write('Bit     : ');
  bit              := read_int(false,3,0,0,7);
end;

procedure get_bst_value;
begin
  write('Segment : ');
  bst              := read_int(false,3,0,0,999);
  write('Value   : ');
  bit              := read_int(false,3,0,0,999);
end;

procedure ti_upd( bst,w : integer; b : boolean);
begin
  if b then
    t_[bst].wert   := t_[bst].wert + w
  else
    t_[bst].wert   := w;

  if (t_[bst].wert < 0) then
    t_[bst].wert   := 0;
  if (t_[bst].wert > maxkt) then
    t_[bst].wert   := maxkt;
  if wish and (bst<4) then 
  begin
    writeln(write_to,'set t',bst,' ',t_[bst].wert);
    fflush(write_to);
  end;
end;

procedure zi_upd( bst,w : integer; b : boolean);
begin
  if b then
    z_[bst].wert   := z_[bst].wert + w
  else
    z_[bst].wert   := w;

  if (z_[bst].wert < 0) then
    z_[bst].wert   := 0;
  if (z_[bst].wert > maxkz) then
    z_[bst].wert   := maxkz;
  if wish and (bst<4) then 
  begin
    writeln(write_to,'set c',bst,' ',z_[bst].wert);
    fflush(write_to);
  end;
end;

procedure time_upd;
var
dummy : word;
begin
  gettime(dh,dm,ds,dummy);
  if (ds <> old_ds) then
  begin
    m_[127,6]      := not m_[127,6]; (* Toggle pro Sekunde *)
    old_ds         := ds;
  end;
  getdate(yy,ym,yd,dn);
end;

procedure speed_upd( w : integer );
begin
  speed                  := speed + w;
  if (speed < 1) then
    speed                := 100
  else if (speed > 100) then
    speed                := 1;
  if wish then 
  begin
    writeln(write_to,'set speed ',speed);
    fflush(write_to);
  end;
end;

procedure akku_upd( w,e : integer );
begin
  akku.einheit           := e;
  akku.wert              := w;
  if wish then 
  begin
    writeln(write_to,'set accu ',akku.wert);
    fflush(write_to);
  end;
end;

procedure upd_e(bst,bit : integer; b : boolean);
begin
  if wish and (bst=0) then
  begin
    if b then
      writeln(write_to,'.e.e0',bit,' configure -background green')
    else 
      writeln(write_to,'.e.e0',bit,' configure -background white');
  end;
  if wish and (bst=1) then
  begin
    if b then
      writeln(write_to,'.e.e1',bit,' configure -background green')
    else 
      writeln(write_to,'.e.e1',bit,' configure -background white');
  end;
end;

procedure upd_m(bst,bit : integer; b : boolean);
begin
  if wish and (bst=0) then
  begin
    if b then
      writeln(write_to,'.m.m0',bit,' configure -background yellow')
    else 
      writeln(write_to,'.m.m0',bit,' configure -background white');
  end;
  if wish and (bst=1) then
  begin
    if b then
      writeln(write_to,'.m.m1',bit,' configure -background yellow')
    else 
      writeln(write_to,'.m.m1',bit,' configure -background white');
  end;
end;

procedure upd_a(bst,bit : integer; b : boolean);
begin
  if wish and (bst=0) then
  begin
    if b then
      writeln(write_to,'.a.a0',bit,' configure -background red')
    else 
      writeln(write_to,'.a.a0',bit,' configure -background white');
  end;
  if wish and (bst=1) then
  begin
    if b then
      writeln(write_to,'.a.a1',bit,' configure -background red')
    else 
      writeln(write_to,'.a.a1',bit,' configure -background white');
  end;
end;

procedure sim_untermenue;
begin
  clrscr;
  repeat
  writeln('1=Input     ');
  writeln('2=Output    ');
  writeln('3=Marker    ');
  writeln('4=Counter   ');
  writeln('5=Timer     ');
  writeln('0=Exit      ');
    readln(wahl);
    case (wahl) of
      1                  :  begin
                              get_bst_bit;
                              if (bst <= maxe) then
                              begin
                                e_[bst,bit]  := not e_[bst,bit];
                                writeln('E ',bst:3,'.',bit,' is now ',e_[bst,bit]);
                                upd_e(bst,bit,e_[bst,bit]);
                              end;
                            end;
      2                  :  begin
                              get_bst_bit;
                              if (bst <= maxa) then
                              begin
                                a_[bst,bit]  := not a_[bst,bit];
                                writeln('A ',bst:3,'.',bit,' is now ',a_[bst,bit]);
                                upd_a(bst,bit,a_[bst,bit]);
                              end;
                            end;
      3                  :  begin
                              get_bst_bit;
                              if (bst <= maxm) then
                              begin
                                m_[bst,bit]  := not m_[bst,bit];
                                writeln('M ',bst:3,'.',bit,' is now ',m_[bst,bit]);
                                upd_m(bst,bit,m_[bst,bit]);
                              end;
                            end;
      4                  :  begin
                              get_bst_value;
                              if (bst <= maxz) then
                              begin
                                zi_upd(bst,bit,false);
                                writeln('Z ',bst:3,' is now ',z_[bst].wert);
                              end;
                            end;
      5                  :  begin
                              get_bst_value;
                              if (bst <= maxt) then
                              begin
                                ti_upd(bst,bit,false);
                                writeln('T ',bst:3,' is now ',t_[bst].wert);
                              end;
                            end;
    end;
  until (wahl=0);
  wahl:=1;
end;


procedure sim_anweisung;
var
dis_ja,
dis_aus                  :  boolean;
xoperation               :  awtyp;
begin
  with awl[aktaw] do
  begin
    if (operation[1] = 'B') then
    begin
      if (not wish) and (not nodisplay) then
      begin
      write('E0.0-7=');
      for i:=0 to 7 do
        if e_[0,i] then write('* ') else write('- '); 
      writeln;
      write('M0.0-7=');
      for i:=0 to 7 do
        if m_[0,i] then write('* ') else write('- '); 
      writeln;
      write('A0.0-7=');
      for i:=0 to 7 do
        if a_[0,i] then write('* ') else write('- '); 
      writeln(oldoutbyte:3,'|',char(oldoutbyte));
      end;
      fillchar(ausgang,deep,#255);
      if (operation = 'BE') or lastausgang then
      begin
        aktaw            := 1;
        lastausgang      := false; (* ??? *)
        oder_von_und     := false;
        m_[127,7]        := not m_[127,7]; (* Toggle Merker pro Durchlauf *)
        if random(2)>0 then m_[127,5] := true else m_[127,5] := false;
        if m_[127,2] then
        begin            (* Exit immediately from Program *)
          halt;
        end;
        if m_[126,7] then write(#7);
        outlpr_upd;
      end;
    end;
  end;
  if (aktaw = 1) then
  begin
    time_upd;
  end;
  with awl[aktaw] do
  begin
    xoperation           := operation;
    dis_ja               := false;
    dis_aus              := false;

    if (operand[1] = 'T') then ti_upd(baustein,-1,true); (* Pseudo Timer *)

    if (operand[1] in ['E','A','M','T','Z']) THEN
    begin
      case operand[1] of
        'E'              :  ja         := e_[baustein,bitnr];
        'A'              :  ja         := a_[baustein,bitnr];
        'M'              :  ja         := m_[baustein,bitnr];
        'T'              :  ja         := (t_[baustein].wert = 0);
        'Z'              :  ja         := (z_[baustein].wert = 0);
      end;
      dis_ja             := ja;
    end;
    if (operand[1] = 'Y') THEN
    begin
      case operand[2] of
        'Y'              :  ja         := (baustein < yy);
        'M'              :  ja         := (baustein < ym);
        'W'              :  ja         := (baustein < yw);
        'D'              :  ja         := (baustein < yd);
      end;
      dis_ja             := ja;
    end;
    if (operand[1] = 'D') THEN
    begin
      case operand[2] of
        'N'              :  ja         := (baustein < dn);
        'W'              :  ja         := (baustein < dw);
        'H'              :  ja         := (baustein < dh);
        'M'              :  ja         := (baustein < dm);
        'S'              :  ja         := (baustein < ds);
      end;
      dis_ja             := ja;
    end;

    if (xoperation = ')') then
    begin
      ja                 := ausgang[klammern];
      xoperation         := opr[klammern];
      klammern           := pred(klammern);
    end;
    if (xoperation = 'U') then
      ausgang[klammern]  := (ausgang[klammern] and ja)
    else if (xoperation = 'O') then
      ausgang[klammern]  := (ausgang[klammern] or  ja)
    else if (xoperation = 'UN') then
      ausgang[klammern]  := (ausgang[klammern] and not ja)
    else if (xoperation = 'ON') then
      ausgang[klammern]  := (ausgang[klammern] or  not ja);

    i                    := pos('(',operation);
    if (i > 1) then
    begin
      klammern           := succ(klammern);
      opr[klammern]      := copy(operation,1,i-1);
    end;

    if ((operation <> '=') and (operation[1] <> 'S') and (operation <> 'R')) then
      dis_aus            := ausgang[klammern];

    if (operation = '=') then
    begin
      dis_ja             := false;
      dis_aus            := (dis_aus or lastausgang or oder_von_und);
      case operand[1] of
        'E'              :  begin
                              e_[baustein,bitnr] := dis_aus;
                              upd_e(baustein,bitnr,e_[baustein,bitnr]);
                            end;
        'A'              :  begin
                              a_[baustein,bitnr] := dis_aus;
                              upd_a(baustein,bitnr,a_[baustein,bitnr]);
                            end;
        'M'              :  begin
                              m_[baustein,bitnr] := dis_aus;
                              upd_m(baustein,bitnr,m_[baustein,bitnr]);
                            end;
      end;
      fillchar(ausgang,deep,#255);
      oder_von_und       := false;
    end;

    if ((operation[1] = 'S') or (operation = 'R')) then
    begin
      dis_ja             := false;
      dis_aus            := (dis_aus or lastausgang or oder_von_und);
      if dis_aus then
      begin
      case operand[1] of
        'E'              :  begin
                              if (operation = 'S') then
                                e_[baustein,bitnr] := true
                              else
                                e_[baustein,bitnr] := false;
                              upd_e(baustein,bitnr,e_[baustein,bitnr]);
                            end;
        'A'              :  begin
                              if (operation = 'S') then
                                a_[baustein,bitnr] := true
                              else
                                a_[baustein,bitnr] := false;
                              upd_a(baustein,bitnr,a_[baustein,bitnr]);
                            end;
        'M'              :  begin
                              if (operation = 'S') then
                                m_[baustein,bitnr] := true
                              else
                                m_[baustein,bitnr] := false;
                              upd_m(baustein,bitnr,m_[baustein,bitnr]);
                            end;
        'T'              :  begin
                              if (operation[1] = 'S') then
                              begin
                                t_[baustein].einheit := akku.einheit;
                                ti_upd(baustein,akku.wert,false);
                              end
                              else
                                ti_upd(baustein,0,false);
                            end;
        'Z'              :  begin
                              if (operation[1] = 'S') then
                                zi_upd(baustein,akku.wert,false)
                              else
                                zi_upd(baustein,0,false);
                            end;
      end;
      end;
      fillchar(ausgang,deep,#255);
      oder_von_und       := false;
    end;

    if ((operation = 'L') and (operand[1] = 'K')) then
    begin
      dis_ja             := false;
      dis_aus            := (dis_aus or lastausgang);
      if dis_aus then       (* ??? *)
      akku_upd(baustein,bitnr);
    end;

    if (operation[1] = 'Z') then
    begin
      dis_ja             := false;
      dis_aus            := (dis_aus or lastausgang or oder_von_und);
      if dis_aus then
      begin
      case operation[2] of
        'R'              :  begin
                              zi_upd(baustein,-1,true);
                            end;
        'V'              :  begin
                              zi_upd(baustein,+1,true);
                            end;
      end;
      end;
      fillchar(ausgang,deep,#255);
      oder_von_und       := false;
    end;

    lastausgang          := dis_aus;
 
    if wish then
    begin
    if (baustein >= 0) then
    begin
      if (bitnr >= 0) then
        s:=int_to_str(baustein,3)+'.'+int_to_str(bitnr,1)
      else s:=int_to_str(baustein,3)+'  ';
    end
    else s:='     ';
    writeln(write_to,'set aw "',aktaw:3,': ',operation:4,'  ',operand:2,'  ',s,' >',dis_ja:5,' >>',dis_aus:5,'"');
    fflush(write_to);
    end
    else if not nodisplay then
    begin
    write('[',int_to_str(aktaw,3),']: ');
    write(operation:4,'  ');
    write(operand:2,'  ');
    if (baustein >= 0) then
    begin
      write(int_to_str(baustein,3));
      if (bitnr >= 0) then
        write('.'+int_to_str(bitnr,1))
      else write('  ');
    end
    else write('     ');
    writeln(' >',dis_ja:5,' >>',dis_aus:5);
    end;
  end;

  aktaw                  := succ(aktaw);

  for i                  := speed to 100 do
    for j                := 1 to delay_ do;
end;


procedure change_e(bst,bit : integer);
begin
  e_[bst,bit]  := not e_[bst,bit];
end;


procedure sim_init;
begin
  for j            := 0 to maxe do
    for i          := 0 to 7 do
      e_[j,i]      := false;
  for j            := 0 to maxa do
    for i          := 0 to 7 do
      a_[j,i]      := false;
  for j            := 0 to maxm do
    for i          := 0 to 7 do
      m_[j,i]      := false;
  for j            := 0 to maxt do
  begin
    t_[j].wert     := 0; (* ??? *)
    t_[j].einheit  := 0;
  end;
  for j            := 0 to maxz do
    z_[j].wert     := 0; (* ??? *)

  fillchar(ausgang,deep,#255);
  lastausgang            := false;
  oder_von_und           := false;
  aktaw                  := 1;
  klammern               := 1;
end;

procedure einlesen;
begin
  anzaw                  := 0;
  klammern               := 0;
  status                 := 0;
  lastaw                 := '';
  while ((status >= 0) and not eof(infile)) do
  begin
    readln (infile,aw);
    repeat
      anzaw              := succ(anzaw);
      write  (' [',anzaw:4,'] ',aw:8);
      syntax_check(aw);
      if (lastaw = aw) and not (aw = ')') then
        status           := -1;
      if (pos('(',lastaw) > 0) and (aw = ')') then
        status           := -1;
      if (klammern > deep) then
        status           := -2;
      if (status = 0) and sende then
        if (klammern <> 0) then
          status         := -2;
      if (status = 0) then
        lastaw           := aw;
      if (status < 0) then
        fehlerbehandlung;
    until (status <> 2);
  end;
  if (status <> 1) then
  begin
    if (status = 0) then
      message(mess[8])
    else
      message(mess[7]);
    readln;
  end;
end;

procedure get_awl;
begin
  for i := 1 to anzopr do maxopr[i] := -1;
  status                 := 0;
  korrektur              := false;
  clrscr;
  write('Filename : '); readln(filename);
  if (filename <> '') then
  begin
  if wish then
  begin
    writeln(write_to,'set file "',filename,'"');
    fflush(write_to);
  end;
  writeln(' Reading ',filename,'...');
  assign (infile,filename);
  reset  (infile);
  einlesen;
  close  (infile);
  sim_init;
  if (status = 1) then
  begin
    if korrektur then
    begin
      rewrite(infile);
      for i            := 1 to anzaw do
      begin
        with awl[i] do
        begin
          write  (infile,operation);
          write  (infile,operand);
          if (baustein = -1) then
            writeln(infile)
          else
          begin
            write  (infile,baustein);
            if (bitnr  = -1) then
              writeln(infile)
            else
              writeln(infile,'.',bitnr);
          end;
        end;
      end;
      close  (infile);
    end;
    message(mess[1]);
  end
  else
    message(mess[8]);
  end
  else
    message(mess[7]);
end;

procedure open_wish;
begin
  wish := true;
(***
  childpid = start_child("wish",&read_from,&write_to);
***)
  writeln(write_to,'source s5wish.tcl');
  fflush(write_to);
end;

procedure close_wish;
begin
  if wish then
  begin
    writeln(write_to,'exit');
    fflush(write_to);
  end;
end;

procedure help;
begin
  writeln('./s5 -wish		opens wish visualisation');
  writeln('     -autoload	asks immidiately for awl to load');
  writeln('     -help 		this help');
  writeln;
  writeln('Please read the file readme.s5...');
end;

begin
(*  assign(lst,'/dev/printer');
  append(lst);*)
  wish                   := false;
  nodisplay              := false;
  status                 := -1;
  speed	                 := 100;
  randomize;
  if paramcount>0 then
  begin
    for i:= 1 to paramcount do
    begin
      if paramstr(i)='-wish' then open_wish;
      if paramstr(i)='-autoload' then get_awl;
      if paramstr(i)='-help' then help;
      if paramstr(i)='-nodisplay' then nodisplay:=true;
    end;
  end;
  repeat
    if wish then
    begin
      readln(read_from,line);
      (* writeln(write_to,'set msg "',line,'"'); *)
      fflush(write_to);
      val(line,wahl,i);
    end
    else
    begin
    if (wahl<>3) then clrscr;
    writeln('1 =Read AWL');
    writeln('2 =Modify I/O/M/C/T');
    writeln('3 =Single Step ');
    writeln('4 =Start Prg.  ');
    writeln('5 =Run Prg. until CTRL-C');
    writeln('8 =Open wish');
    writeln('9 =Close wish');
    writeln('11=Decrease Speed');
    writeln('12=Increase Speed');
    writeln('0 =Exit');
    readln(wahl);
    end;

    case wahl of
      1                :  get_awl;
      2                :  sim_untermenue;
      3                :  begin
                              if (status <> 1) then get_awl;
                              if (status = 1) then
                              begin
                                sim_anweisung;
                              end;
                          end;
      4                :  begin
                              if (status <> 1) then get_awl;
                              if (status = 1) then
                              begin
                                repeat
                                  sim_anweisung;
				  readln(line);
				until(line<>"");
			      end;
                          end;
      5                :  begin
                              if (status <> 1) then get_awl;
                              if (status = 1) then
                              begin
                                inst_break;
                                repeat
                                  sim_anweisung;
                                until (is_break()=1);
                              end;
                          end;
      8                :  open_wish;
      9                :  close_wish;
      11               :  speed_upd(-1);
      12               :  speed_upd(1);
    end;
  until (wahl=0);
(*  close (lst);*)
  close_wish;
end.
