/* Output from p2c, the Pascal-to-C translator */
/* From input file "s5.p" */


#include <p2c/p2c.h>


/*$M 8192,0,90000 */


#include "child.h"



#define copyright       "S5 (c) Peter Sieg 03-Jan-1998"


typedef Char dateiname[13];

typedef Char extension[4];

typedef Char awtyp[10];

typedef struct awrec {
  Char operation[4];
  Char operand[3];
  short baustein, bitnr;
} awrec;

typedef struct t_rec {
  short einheit, wert;
} t_rec;

typedef struct z_rec {
  short wert;
} z_rec;


#define anzopr          7
#define maxoperationen  22
#define maxaw           512
#define maxe            31   /* Anzahl Bausteine */
#define maxa            31   /* Anzahl Bausteine */
#define maxm            127   /* Anzahl Bausteine */
#define maxt            63   /* Anzahl Bausteine */
#define maxz            63   /* Anzahl Bausteine */
#define maxkt           999
#define maxkz           999
#define maxyy           9999   /* year */
#define maxym           12   /* month of year */
#define maxyw           53   /* week of year */
#define maxyd           366   /* day of year */
#define maxdn           31   /* day of month */
#define maxdw           7   /* day of week */
#define maxdh           23   /* hour */
#define maxdm           59   /* minute */
#define maxds           59
#define dise            3   /* Anzahl auf Bildschirm */
#define disa            3   /* Anzahl auf Bildschirm */
#define dism            9   /* Anzahl auf Bildschirm */
#define dist            15   /* Anzahl auf Bildschirm */
#define disz            15   /* Anzahl auf Bildschirm */
#define disaw           6
#define deep            6


Static short maxopr[anzopr] = {
  -1, -1, -1, -1, -1, -1, -1
};

Static unsigned short yy = 0;   /* year */
Static unsigned short ym = 0;   /* month of year */
Static unsigned short yw = 0;   /* week of year */
Static unsigned short yd = 0;   /* day of year */
Static unsigned short dn = 0;   /* day of month */
Static unsigned short dw = 0;   /* day of week */
Static unsigned short dh = 0;   /* hour */
Static unsigned short dm = 0;   /* minute */
Static unsigned short ds = 0;   /* second */
Static unsigned short old_ds = 0;   /* old second for m 127,6 */
Static unsigned short dd = 0;   /* metec */
Static Char eins[256] = "*";
Static Char null_[256] = " ";
Static short es = 2, ez = 3, as = 49, az = 3, ms = 1, mz = 22, ts = 2, tz = 5,
	     ti = 14, zs = 75, zz = 5, zi = 63;
Static unsigned short scrollstart = 1, scrollende = 1, speed = 100,
		      delay_ = 50000L;
Static Char spstyp[11] = " S5-1XX U ";

Static Char operationen[maxoperationen][4] = {
  "=", "S", "SI", "SV", "SE", "SS", "SA", "R", "ZR", "ZV", "L", "U", "O",
  "UN", "ON", "BE", "BEB", ")", "U(", "O(", "UN(", "ON("
};

Static Char fehlermeldung[10][41] = {
  "Last 2 actual instruction ???", "Too many or unbalanced ()",
  "Operation missing", "Operation unknown", "Operand or Segm./BitNo not ok",
  "Operand not allowable", "Operand missing", "Segment/BitNo wrong format",
  "Segment or Bitnumber missing", "Segment/BitNo over Maximum"
};

Static Char mess[11][41] = {
  " Instruction list was processed...", " Simulation terminated...",
  " Documentation generated...", " PRINT program finished...",
  " EDIT program finished...", " Program not found...",
  " Function aborted...", " Instruction list has errors...",
  " Not enough memory free...", " Not enough free space on disk...",
  " System error..."
};

Static short childpid;
Static FILE *read_from, *write_to;
Static Char key;
Static boolean ja;
Static short wahl;
Static Char line[256], s[256];
Static Char meldung[41];
Static Char bststr[7];
Static Char bitstr[7];
Static Char lr[9];
Static extension ext;
Static Char filename[256];
Static FILE *lst_, *infile, *outfile;
Static uchar save_attr, newoutbyte, oldoutbyte;
Static short i, ii, j, jj, bst, bit, status, klammern, anzaw, aktaw;
Static boolean wish, lastausgang, oder_von_und, korrektur, scroll, upd, sende;
Static awtyp lastaw, aw;
Static awrec awl[maxaw];
Static boolean e_[maxe + 1][8];
Static boolean a_[maxa + 1][8];
Static boolean m_[maxm + 1][8];
Static t_rec akku;
Static t_rec t_[maxt + 1];
Static z_rec z_[maxz + 1];
Static boolean yy_;   /* year */
Static boolean ym_;   /* month of year */
Static boolean yw_;   /* week of year */
Static boolean yd_;   /* day of year */
Static boolean dn_;   /* day of month */
Static boolean dw_;   /* day of week */
Static boolean dh_;   /* hour */
Static boolean dm_;   /* minute */
Static boolean ds_;   /* second */
Static boolean ausgang[deep];
Static Char opr[deep][3];
Static boolean nodisplay;
Static Char read_from_NAME[_FNSIZE];
Static Char write_to_NAME[_FNSIZE];
Static Char lst__NAME[_FNSIZE];
Static Char infile_NAME[_FNSIZE];
Static Char outfile_NAME[_FNSIZE];


Static boolean keypressed()
{
  return true;
}


Static Char readkey()
{
  return '\015';
}


Static boolean _randint()
{
  return false;
}


Static Void randomize()
{
}


Static Void outlpr_upd()
{
  static uchar power2[8] = {
    1, 2, 4, 8, 16, 32, 64, 128
  };

  newoutbyte = 0;
  for (i = 0; i <= 7; i++) {
    if (a_[0][i] == true)
      newoutbyte += power2[i];
  }
  if (newoutbyte == oldoutbyte)
    return;
  oldoutbyte = newoutbyte;
  if (m_[127][0]) {
    putc(newoutbyte, lst_);
    fflush(lst_);
/* p2c: s5.p, line 211: Warning: Symbol 'FFLUSH' is not defined [221] */
  }
}


Static Void clrscr()
{
  printf("\033[2J");
  printf("\033[1;1H");
}


Static short read_int(b, l, v, u, o)
boolean b;
short l, v, u, o;
{  /*bst := read_int(false,3,0,0,999);*/
  short i;

  scanf("%hd%*[^\n]", &i);
  getchar();
  return i;
}


Static Char *int_to_str(Result, i, l)
Char *Result;
short i, l;
{  /*write_screen(53,10,int_to_str(baustein,3));*/
  Char s[256];

  sprintf(s, "%*d", l, i);
  return strcpy(Result, s);
}


Static Void message(s)
Char *s;
{
  if (wish) {
    fprintf(write_to, "set msg \"%s\"\n", s);
    fflush(write_to);
/* p2c: s5.p, line 241: Warning: Symbol 'FFLUSH' is not defined [221] */
    return;
  }
  printf("\n%s", s);
  scanf("%*[^\n]");
  getchar();
}


Static Char *upstring(Result, s)
Char *Result;
Char *s;
{
  short i;
  Char l[256];
  short FORLIM;

  *l = '\0';
  FORLIM = strlen(s);
  for (i = 0; i < FORLIM; i++)
    sprintf(l + strlen(l), "%c", toupper(s[i]));
  return strcpy(Result, l);
}


Static Void gettime(dh, dm, ds, dummy)
unsigned short *dh, *dm, *ds, *dummy;
{  /*gettime(dh,dm,ds,dummy);*/
  /*decodetime(now,dh,dm,ds,dummy);*/
  *dh = 17;
  *dm = 30;
  *ds = 45;
  *dummy = 0;
}


Static Void getdate(yy, ym, yd, dn)
unsigned short *yy, *ym, *yd, *dn;
{  /*getdate(yy,ym,yd,dn);*/
  *yy = 1963;
  *ym = 12;
  *yd = 26;
  *dn = 0;
}


Static Char getkey()
{
  Char wahl[256];

  gets(wahl);
  return (wahl[0]);
}


/* Local variables for syntax_check: */
struct LOC_syntax_check {
  awtyp s;
  boolean oende, pende;
  awtyp operandstr, bststr;
} ;

Local Void p_oende(LINK)
struct LOC_syntax_check *LINK;
{
  if (!LINK->pende) {
    LINK->oende = true;
    sprintf(LINK->operandstr + strlen(LINK->operandstr), "%c", LINK->s[i - 1]);
/* p2c: s5.p, line 297:
 * Note: Possible string truncation in assignment [145] */
  } else {
    sprintf(LINK->bststr + strlen(LINK->bststr), "%c", LINK->s[i - 1]);
/* p2c: s5.p, line 300:
 * Note: Possible string truncation in assignment [145] */
  }
}


Static Void syntax_check(s_)
Char *s_;
{
  struct LOC_syntax_check V;
  boolean zende, bitwert, bstadr;
  unsigned short max;
  awtyp operationstr, bitstr;
  short FORLIM;
  awrec *WITH;

  strcpy(V.s, s_);
  V.oende = false;
  V.pende = false;
  sende = false;
  zende = false;
  bitwert = true;
  bstadr = true;
  status = 0;
  *operationstr = '\0';
  *V.operandstr = '\0';
  *V.bststr = '\0';
  *bitstr = '\0';

  FORLIM = strlen(V.s);
  for (i = 1; i <= FORLIM; i++) {
    switch (V.s[i - 1]) {

    case 'M':
    case 'K':
    case 'T':
    case 'Y':
    case 'D':
    case 'J':
    case 'I':
      p_oende(&V);
      break;

    case 'A':
      if (i == 2 && operationstr[0] == 'S' && V.s[i] == 'T') {
	sprintf(operationstr + strlen(operationstr), "%c", V.s[i - 1]);
/* p2c: s5.p, line 324:
 * Note: Possible string truncation in assignment [145] */
      } else
	p_oende(&V);
      break;

    case 'E':
      if (i == 2 && (operationstr[0] == 'S' || operationstr[0] == 'B')) {
	sprintf(operationstr + strlen(operationstr), "%c", V.s[i - 1]);
/* p2c: s5.p, line 330:
 * Note: Possible string truncation in assignment [145] */
      } else
	p_oende(&V);
      break;

    case 'Z':
      if (i > 1)
	p_oende(&V);
      else {
	sprintf(operationstr + strlen(operationstr), "%c", V.s[i - 1]);
/* p2c: s5.p, line 336:
 * Note: Possible string truncation in assignment [145] */
      }
      break;

    case '.':
      bstadr = false;
      break;

    default:
      if (isdigit(V.s[i - 1])) {
	if (bstadr) {
	  V.pende = true;
	  sprintf(V.bststr + strlen(V.bststr), "%c", V.s[i - 1]);
/* p2c: s5.p, line 343:
 * Note: Possible string truncation in assignment [145] */
	} else {
	  sprintf(bitstr + strlen(bitstr), "%c", V.s[i - 1]);
/* p2c: s5.p, line 346:
 * Note: Possible string truncation in assignment [145] */
	}
      } else {
	if (!V.oende) {
	  sprintf(operationstr + strlen(operationstr), "%c", V.s[i - 1]);
/* p2c: s5.p, line 350:
 * Note: Possible string truncation in assignment [145] */
	} else {
	  if (!V.pende) {
	    sprintf(V.operandstr + strlen(V.operandstr), "%c", V.s[i - 1]);
/* p2c: s5.p, line 353:
 * Note: Possible string truncation in assignment [145] */
	  } else {
	    if (bstadr) {
	      sprintf(V.bststr + strlen(V.bststr), "%c", V.s[i - 1]);
/* p2c: s5.p, line 356:
 * Note: Possible string truncation in assignment [145] */
	    } else {
	      sprintf(bitstr + strlen(bitstr), "%c", V.s[i - 1]);
/* p2c: s5.p, line 357:
 * Note: Possible string truncation in assignment [145] */
	    }
	  }
	}
      }
      break;
    }
  }

  if (*operationstr == '\0')
    status = -3;

  if (status == 0) {
    j = 0;
    for (i = 1; i <= maxoperationen; i++) {
      if (!strcmp(operationstr, operationen[i - 1]))
	j = i;
    }
    if (j == 0)
      status = -4;
    else if ((unsigned)j < 32 && ((1L << j) & 0xf8) != 0 &&
	     strcmp(V.operandstr, "T"))
      status = -6;
    else
      status = 0;
    if (j < 11)   /* Strompfadende */
      sende = true;
    if (j > 15)   /* Bausteinende/Klammern */
      zende = true;

    if (j == 18)   /* KLammer Zu */
      klammern--;
    if (j > 18)   /* Operation+Klammer Auf */
      klammern++;

  }

  if (status == 0) {
    if (zende && (*V.operandstr != '\0' || *V.bststr != '\0'))
      status = -5;
    if (!zende) {
      if (*V.operandstr == '\0')
	status = -7;
      else {
	if (*V.bststr == '\0')
	  status = -9;
      }
    }
  }

  if (status == 0 && !zende) {
    if (strlen(V.operandstr) == 1 &&
	(V.operandstr[0] == 'Z' || V.operandstr[0] == 'T' ||
	 V.operandstr[0] == 'M' || V.operandstr[0] == 'A' ||
	 V.operandstr[0] == 'E'))
      status = 0;
    else {
      if (strlen(V.operandstr) == 2 && V.operandstr[0] == 'K' &&
	  (V.operandstr[1] == 'Z' || V.operandstr[1] == 'T'))
	status = 0;   /* L KT/Z ... */
      else {
	if (strlen(V.operandstr) == 2 && V.operandstr[0] == 'Y' &&
	    (V.operandstr[1] == 'D' || V.operandstr[1] == 'W' ||
	     V.operandstr[1] == 'M' || V.operandstr[1] == 'Y'))
	  status = 0;   /* Y/YMWD ... */
	else {
	  if (strlen(V.operandstr) == 2 && V.operandstr[0] == 'D' &&
	      (V.operandstr[1] == 'D' || V.operandstr[1] == 'S' ||
	       V.operandstr[1] == 'H' || V.operandstr[1] == 'W' ||
	       V.operandstr[1] == 'M' || V.operandstr[1] == 'N'))
	    status = 0;   /* D/NWHMSD ... */
	  else {
	    if (strlen(V.operandstr) == 2 && V.operandstr[0] == 'J' &&
		(V.operandstr[1] == 'Y' || V.operandstr[1] == 'X'))
	      status = 0;   /* J/XY ... */
	    else {
	      if (strlen(V.operandstr) == 2 && V.operandstr[0] == 'I' &&
		  V.operandstr[1] >= 'A' && V.operandstr[1] <= 'F')
		status = 0;   /* I/A-F ... */
	      else
		status = -6;
	    }
	  }
	}
      }
    }
  }

  if (V.operandstr[0] == 'D' || V.operandstr[0] == 'Y' ||
      V.operandstr[0] == 'Z' || V.operandstr[0] == 'T' ||
      V.operandstr[0] == 'K' && V.operandstr[1] == 'Z')
    bitwert = false;

  if (status == 0 && !zende) {
    status = -8;
    ii = (sscanf(V.bststr, "%d", &bst) == 0);
    jj = (sscanf(bitstr, "%d", &bit) == 0);

    if (ii == 0 && jj == 0 && (unsigned)bit < 32 && ((1L << bit) & 0xff) != 0 ||
	!bitwert) {
      status = -10;
      switch (V.operandstr[0]) {

      case 'E':
	if (bst <= maxe) {
	  status = 0;
	  if (maxopr[0] < bst)
	    maxopr[0] = bst;
	}
	break;

      case 'A':
	if (bst <= maxa) {
	  status = 0;
	  if (maxopr[1] < bst)
	    maxopr[1] = bst;
	}
	break;

      case 'M':
	if (bst <= maxm) {
	  status = 0;
	  if (maxopr[2] < bst)
	    maxopr[2] = bst;
	}
	break;

      case 'T':
	if (bst <= maxt) {
	  status = 0;
	  if (maxopr[3] < bst)
	    maxopr[3] = bst;
	}
	break;

      case 'Z':
	if (bst <= maxz) {
	  status = 0;
	  if (maxopr[4] < bst)
	    maxopr[4] = bst;
	}
	break;
      }
      switch (V.operandstr[1]) {

      case 'T':
	if (bst <= maxkt && (unsigned)bit < 32 && ((1L << bit) & 0xf) != 0)
	  max = maxkt;
	break;

      case 'Z':
	if (bst <= maxkz)
	  max = maxkz;
	break;

      case 'D':
	if (V.operandstr[0] == 'Y') {
	  if (bst <= maxyd)
	    max = maxyd;
	}
	break;

      case 'H':
	if (bst <= maxdh)
	  max = maxdh;
	break;

      case 'S':
	if (bst <= maxds)
	  max = maxds;
	break;

      case 'N':
	if (bst <= maxdn)
	  max = maxdn;
	break;

      case 'M':
	if (V.operandstr[0] == 'Y')
	  max = maxym;
	else
	  max = maxdm;
	break;

      case 'W':
	if (V.operandstr[0] == 'Y')
	  max = maxyw;
	else
	  max = maxdw;
	break;
      }
      if (bst <= max)
	status = 0;
    }
  }

  /* Oder von Und */
  if (!strcmp(operationstr, "O") && *V.operandstr == '\0') {
    zende = true;
    status = 0;
  }

  if (status == 0) {
    WITH = &awl[anzaw - 1];
    strcpy(WITH->operation, operationstr);
/* p2c: s5.p, line 493:
 * Note: Possible string truncation in assignment [145] */
    if (zende) {
      *WITH->operand = '\0';
      WITH->baustein = -1;
      WITH->bitnr = -1;
    } else {
      strcpy(WITH->operand, V.operandstr);
/* p2c: s5.p, line 502:
 * Note: Possible string truncation in assignment [145] */
      WITH->baustein = bst;
      if (bitwert)
	WITH->bitnr = bit;
      else
	WITH->bitnr = -1;
    }
    if (!strcmp(operationstr, "BE"))
      status = 1;
  }
  printf(" - %3s %3s %3s.%1s \n",
	 operationstr, V.operandstr, V.bststr, bitstr);
}


Static Void fehlerbehandlung()
{
  Char *TEMP;

  printf("Error detected   - ");
  puts(fehlermeldung[abs(status) - 1]);

  if (status >= -2)
    return;
  printf("New Instruction: ");
  fgets(aw, 10, stdin);
  TEMP = strchr(aw, '\n');
  if (TEMP != NULL)
    *TEMP = 0;
  if (strcmp(aw, " ") <= 0)
    return;
  status = 2;
  anzaw--;
  korrektur = true;
}


Static Void get_bst_bit()
{
  printf("Segment : ");
  bst = read_int(false, 3, 0, 0, 999);
  printf("Bit     : ");
  bit = read_int(false, 3, 0, 0, 7);
}


Static Void get_bst_value()
{
  printf("Segment : ");
  bst = read_int(false, 3, 0, 0, 999);
  printf("Value   : ");
  bit = read_int(false, 3, 0, 0, 999);
}


Static Void ti_upd(bst, w, b)
short bst, w;
boolean b;
{
  if (b)
    t_[bst].wert += w;
  else
    t_[bst].wert = w;

  if (t_[bst].wert < 0)
    t_[bst].wert = 0;
  if (t_[bst].wert > maxkt)
    t_[bst].wert = maxkt;
  if (wish && bst < 4) {
    fprintf(write_to, "set t%d %d\n", bst, t_[bst].wert);
    fflush(write_to);
/* p2c: s5.p, line 564: Warning: Symbol 'FFLUSH' is not defined [221] */
  }
}


Static Void zi_upd(bst, w, b)
short bst, w;
boolean b;
{
  if (b)
    z_[bst].wert += w;
  else
    z_[bst].wert = w;

  if (z_[bst].wert < 0)
    z_[bst].wert = 0;
  if (z_[bst].wert > maxkz)
    z_[bst].wert = maxkz;
  if (wish && bst < 4) {
    fprintf(write_to, "set c%d %d\n", bst, z_[bst].wert);
    fflush(write_to);
/* p2c: s5.p, line 582: Warning: Symbol 'FFLUSH' is not defined [221] */
  }
}


Static Void time_upd()
{
  unsigned short dummy;

  gettime(&dh, &dm, &ds, &dummy);
  if (ds != old_ds) {
    m_[127][6] = !m_[127][6];   /* Toggle pro Sekunde */
    old_ds = ds;
  }
  getdate(&yy, &ym, &yd, &dn);
}


Static Void speed_upd(w)
short w;
{
  speed += w;
  if (speed < 1)
    speed = 100;
  else if (speed > 100)
    speed = 1;
  if (wish) {
    fprintf(write_to, "set speed %u\n", speed);
    fflush(write_to);
/* p2c: s5.p, line 609: Warning: Symbol 'FFLUSH' is not defined [221] */
  }
}


Static Void akku_upd(w, e)
short w, e;
{
  akku.einheit = e;
  akku.wert = w;
  if (wish) {
    fprintf(write_to, "set accu %d\n", akku.wert);
    fflush(write_to);
/* p2c: s5.p, line 620: Warning: Symbol 'FFLUSH' is not defined [221] */
  }
}


Static Void upd_e(bst, bit, b)
short bst, bit;
boolean b;
{
  if (wish && bst == 0) {
    if (b)
      fprintf(write_to, ".e.e0%d configure -background green\n", bit);
    else
      fprintf(write_to, ".e.e0%d configure -background white\n", bit);
  }
  if (!(wish && bst == 1))
    return;
  if (b)
    fprintf(write_to, ".e.e1%d configure -background green\n", bit);
  else
    fprintf(write_to, ".e.e1%d configure -background white\n", bit);
}


Static Void upd_m(bst, bit, b)
short bst, bit;
boolean b;
{
  if (wish && bst == 0) {
    if (b)
      fprintf(write_to, ".m.m0%d configure -background yellow\n", bit);
    else
      fprintf(write_to, ".m.m0%d configure -background white\n", bit);
  }
  if (!(wish && bst == 1))
    return;
  if (b)
    fprintf(write_to, ".m.m1%d configure -background yellow\n", bit);
  else
    fprintf(write_to, ".m.m1%d configure -background white\n", bit);
}


Static Void upd_a(bst, bit, b)
short bst, bit;
boolean b;
{
  if (wish && bst == 0) {
    if (b)
      fprintf(write_to, ".a.a0%d configure -background red\n", bit);
    else
      fprintf(write_to, ".a.a0%d configure -background white\n", bit);
  }
  if (!(wish && bst == 1))
    return;
  if (b)
    fprintf(write_to, ".a.a1%d configure -background red\n", bit);
  else
    fprintf(write_to, ".a.a1%d configure -background white\n", bit);
}


Static Void sim_untermenue()
{
  clrscr();
  do {
    printf("1=Input     \n");
    printf("2=Output    \n");
    printf("3=Marker    \n");
    printf("4=Counter   \n");
    printf("5=Timer     \n");
    printf("0=Exit      \n");
    scanf("%hd%*[^\n]", &wahl);
    getchar();
    switch (wahl) {

    case 1:
      get_bst_bit();
      if (bst <= maxe) {
	e_[bst][bit] = !e_[bst][bit];
	printf("E %3d.%d is now %s\n",
	       bst, bit, e_[bst][bit] ? " TRUE" : "FALSE");
	upd_e(bst, bit, e_[bst][bit]);
      }
      break;

    case 2:
      get_bst_bit();
      if (bst <= maxa) {
	a_[bst][bit] = !a_[bst][bit];
	printf("A %3d.%d is now %s\n",
	       bst, bit, a_[bst][bit] ? " TRUE" : "FALSE");
	upd_a(bst, bit, a_[bst][bit]);
      }
      break;

    case 3:
      get_bst_bit();
      if (bst <= maxm) {
	m_[bst][bit] = !m_[bst][bit];
	printf("M %3d.%d is now %s\n",
	       bst, bit, m_[bst][bit] ? " TRUE" : "FALSE");
	upd_m(bst, bit, m_[bst][bit]);
      }
      break;

    case 4:
      get_bst_value();
      if (bst <= maxz) {
	zi_upd(bst, bit, false);
	printf("Z %3d is now %d\n", bst, z_[bst].wert);
      }
      break;

    case 5:
      get_bst_value();
      if (bst <= maxt) {
	ti_upd(bst, bit, false);
	printf("T %3d is now %d\n", bst, t_[bst].wert);
      }
      break;
    }
  } while (wahl != 0);
  wahl = 1;
}


Static Void sim_anweisung()
{
  boolean dis_ja, dis_aus;
  awtyp xoperation;
  awrec *WITH;
  Char STR2[256], STR3[256];
  short FORLIM1;

  WITH = &awl[aktaw - 1];
  if (WITH->operation[0] == 'B') {
    if (!wish && !nodisplay) {
      printf("E0.0-7=");
      for (i = 0; i <= 7; i++) {
	if (e_[0][i])
	  printf("* ");
	else
	  printf("- ");
      }
      printf("\nM0.0-7=");
      for (i = 0; i <= 7; i++) {
	if (m_[0][i])
	  printf("* ");
	else
	  printf("- ");
      }
      printf("\nA0.0-7=");
      for (i = 0; i <= 7; i++) {
	if (a_[0][i])
	  printf("* ");
	else
	  printf("- ");
      }
      printf("%3d|%c\n", oldoutbyte, oldoutbyte);
    }
/* p2c: s5.p, line 764: Note: Character >= 128 encountered [281] */
    memset((Anyptr)ausgang, 255, (long)deep);
    if (!strcmp(WITH->operation, "BE") || lastausgang) {
      aktaw = 1;
      lastausgang = false;   /* ??? */
      oder_von_und = false;
      m_[127][7] = !m_[127][7];   /* Toggle Merker pro Durchlauf */
      if (_randint(2L) > 0)
	m_[127][5] = true;
      else
	m_[127][5] = false;
      if (m_[127][2])  /* Exit immediately from Program */
	_Escape(0);
      if (m_[126][7])
	putchar('\007');
      outlpr_upd();
    }
  }
  if (aktaw == 1)
    time_upd();
  WITH = &awl[aktaw - 1];

  strcpy(xoperation, WITH->operation);
  dis_ja = false;
  dis_aus = false;

  if (WITH->operand[0] == 'T')   /* Pseudo Timer */
    ti_upd(WITH->baustein, -1, true);

  if (WITH->operand[0] == 'Z' || WITH->operand[0] == 'T' ||
      WITH->operand[0] == 'M' ||
      WITH->operand[0] == 'A' || WITH->operand[0] == 'E') {
    switch (WITH->operand[0]) {

    case 'E':
      ja = e_[WITH->baustein][WITH->bitnr];
      break;

    case 'A':
      ja = a_[WITH->baustein][WITH->bitnr];
      break;

    case 'M':
      ja = m_[WITH->baustein][WITH->bitnr];
      break;

    case 'T':
      ja = (t_[WITH->baustein].wert == 0);
      break;

    case 'Z':
      ja = (z_[WITH->baustein].wert == 0);
      break;
    }
    dis_ja = ja;
  }
  if (WITH->operand[0] == 'Y') {
    switch (WITH->operand[1]) {

    case 'Y':
      ja = (WITH->baustein < yy);
      break;

    case 'M':
      ja = (WITH->baustein < ym);
      break;

    case 'W':
      ja = (WITH->baustein < yw);
      break;

    case 'D':
      ja = (WITH->baustein < yd);
      break;
    }
    dis_ja = ja;
  }
  if (WITH->operand[0] == 'D') {
    switch (WITH->operand[1]) {

    case 'N':
      ja = (WITH->baustein < dn);
      break;

    case 'W':
      ja = (WITH->baustein < dw);
      break;

    case 'H':
      ja = (WITH->baustein < dh);
      break;

    case 'M':
      ja = (WITH->baustein < dm);
      break;

    case 'S':
      ja = (WITH->baustein < ds);
      break;
    }
    dis_ja = ja;
  }

  if (!strcmp(xoperation, ")")) {
    ja = ausgang[klammern - 1];
    strcpy(xoperation, opr[klammern - 1]);
    klammern--;
  }
  if (!strcmp(xoperation, "U"))
    ausgang[klammern - 1] = (ausgang[klammern - 1] && ja);
  else if (!strcmp(xoperation, "O"))
    ausgang[klammern - 1] = (ausgang[klammern - 1] || ja);
  else if (!strcmp(xoperation, "UN"))
    ausgang[klammern - 1] = (ausgang[klammern - 1] && !ja);
  else if (!strcmp(xoperation, "ON"))
    ausgang[klammern - 1] = (ausgang[klammern - 1] || !ja);

  i = strpos2(WITH->operation, "(", 1);
  if (i > 1) {
    klammern++;
    sprintf(opr[klammern - 1], "%.*s", i - 1, WITH->operation);
/* p2c: s5.p, line 845:
 * Note: Possible string truncation in assignment [145] */
  }

  if (strcmp(WITH->operation, "=") && WITH->operation[0] != 'S' &&
      strcmp(WITH->operation, "R"))
    dis_aus = ausgang[klammern - 1];

  if (!strcmp(WITH->operation, "=")) {
    dis_ja = false;
    dis_aus = (dis_aus || lastausgang || oder_von_und);
    switch (WITH->operand[0]) {

    case 'E':
      e_[WITH->baustein][WITH->bitnr] = dis_aus;
      upd_e(WITH->baustein, WITH->bitnr, e_[WITH->baustein][WITH->bitnr]);
      break;

    case 'A':
      a_[WITH->baustein][WITH->bitnr] = dis_aus;
      upd_a(WITH->baustein, WITH->bitnr, a_[WITH->baustein][WITH->bitnr]);
      break;

    case 'M':
      m_[WITH->baustein][WITH->bitnr] = dis_aus;
      upd_m(WITH->baustein, WITH->bitnr, m_[WITH->baustein][WITH->bitnr]);
      break;
    }
/* p2c: s5.p, line 869: Note: Character >= 128 encountered [281] */
    memset((Anyptr)ausgang, 255, (long)deep);
    oder_von_und = false;
  }

  if (WITH->operation[0] == 'S' || !strcmp(WITH->operation, "R")) {
    dis_ja = false;
    dis_aus = (dis_aus || lastausgang || oder_von_und);
    if (dis_aus) {
      switch (WITH->operand[0]) {

      case 'E':
	if (!strcmp(WITH->operation, "S"))
	  e_[WITH->baustein][WITH->bitnr] = true;
	else
	  e_[WITH->baustein][WITH->bitnr] = false;
	upd_e(WITH->baustein, WITH->bitnr, e_[WITH->baustein][WITH->bitnr]);
	break;

      case 'A':
	if (!strcmp(WITH->operation, "S"))
	  a_[WITH->baustein][WITH->bitnr] = true;
	else
	  a_[WITH->baustein][WITH->bitnr] = false;
	upd_a(WITH->baustein, WITH->bitnr, a_[WITH->baustein][WITH->bitnr]);
	break;

      case 'M':
	if (!strcmp(WITH->operation, "S"))
	  m_[WITH->baustein][WITH->bitnr] = true;
	else
	  m_[WITH->baustein][WITH->bitnr] = false;
	upd_m(WITH->baustein, WITH->bitnr, m_[WITH->baustein][WITH->bitnr]);
	break;

      case 'T':
	if (WITH->operation[0] == 'S') {
	  t_[WITH->baustein].einheit = akku.einheit;
	  ti_upd(WITH->baustein, akku.wert, false);
	} else
	  ti_upd(WITH->baustein, 0, false);
	break;

      case 'Z':
	if (WITH->operation[0] == 'S')
	  zi_upd(WITH->baustein, akku.wert, false);
	else
	  zi_upd(WITH->baustein, 0, false);
	break;
      }
    }
/* p2c: s5.p, line 918: Note: Character >= 128 encountered [281] */
    memset((Anyptr)ausgang, 255, (long)deep);
    oder_von_und = false;
  }

  if (!strcmp(WITH->operation, "L") && WITH->operand[0] == 'K') {
    dis_ja = false;
    dis_aus = (dis_aus || lastausgang);
    if (dis_aus)   /* ??? */
      akku_upd(WITH->baustein, WITH->bitnr);
  }

  if (WITH->operation[0] == 'Z') {
    dis_ja = false;
    dis_aus = (dis_aus || lastausgang || oder_von_und);
    if (dis_aus) {
      switch (WITH->operation[1]) {

      case 'R':
	zi_upd(WITH->baustein, -1, true);
	break;

      case 'V':
	zi_upd(WITH->baustein, 1, true);
	break;
      }
    }
/* p2c: s5.p, line 945: Note: Character >= 128 encountered [281] */
    memset((Anyptr)ausgang, 255, (long)deep);
    oder_von_und = false;
  }

  lastausgang = dis_aus;

  if (wish) {
    if (WITH->baustein >= 0) {
      if (WITH->bitnr >= 0)
	sprintf(s, "%s.%s",
		int_to_str(STR2, WITH->baustein, 3),
		int_to_str(STR3, WITH->bitnr, 1));
      else
	sprintf(s, "%s  ", int_to_str(STR2, WITH->baustein, 3));
    } else
      strcpy(s, "     ");
    fprintf(write_to, "set aw \"%3d: %4s  %2s  %s >%5s >>%5s\"\n",
	    aktaw, WITH->operation, WITH->operand, s,
	    dis_ja ? "TRUE" : "FALSE", dis_aus ? "TRUE" : "FALSE");
    fflush(write_to);
/* p2c: s5.p, line 961: Warning: Symbol 'FFLUSH' is not defined [221] */
  } else if (!nodisplay) {
    printf("[%s]: ", int_to_str(STR2, aktaw, 3));
    printf("%4s  ", WITH->operation);
    printf("%2s  ", WITH->operand);
    if (WITH->baustein >= 0) {
      fputs(int_to_str(STR2, WITH->baustein, 3), stdout);
      if (WITH->bitnr >= 0)
	printf(".%s", int_to_str(STR2, WITH->bitnr, 1));
      else
	printf("  ");
    } else
      printf("     ");
    printf(" >%5s >>%5s\n",
	   dis_ja ? "TRUE" : "FALSE", dis_aus ? "TRUE" : "FALSE");
  }
  aktaw++;

  for (i = speed; i <= 100; i++) {
    FORLIM1 = delay_;
    for (j = 1; j <= FORLIM1; j++) ;
  }
}


Static Void change_e(bst, bit)
short bst, bit;
{
  e_[bst][bit] = !e_[bst][bit];
}


Static Void sim_init()
{
  for (j = 0; j <= maxe; j++) {
    for (i = 0; i <= 7; i++)
      e_[j][i] = false;
  }
  for (j = 0; j <= maxa; j++) {
    for (i = 0; i <= 7; i++)
      a_[j][i] = false;
  }
  for (j = 0; j <= maxm; j++) {
    for (i = 0; i <= 7; i++)
      m_[j][i] = false;
  }
  for (j = 0; j <= maxt; j++) {
    t_[j].wert = 0;   /* ??? */
    t_[j].einheit = 0;
  }
  for (j = 0; j <= maxz; j++)   /* ??? */
    z_[j].wert = 0;

/* p2c: s5.p, line 1012: Note: Character >= 128 encountered [281] */
  memset((Anyptr)ausgang, 255, (long)deep);
  lastausgang = false;
  oder_von_und = false;
  aktaw = 1;
  klammern = 1;
}


Static Void einlesen()
{
  Char *TEMP;

  anzaw = 0;
  klammern = 0;
  status = 0;
  *lastaw = '\0';
  while (status >= 0 && !P_eof(infile)) {
    fgets(aw, 10, infile);
    TEMP = strchr(aw, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    do {
      anzaw++;
      printf(" [%4d] %8s", anzaw, aw);
      syntax_check(aw);
      if (!strcmp(lastaw, aw) && strcmp(aw, ")"))
	status = -1;
      if (strpos2(lastaw, "(", 1) > 0 && !strcmp(aw, ")"))
	status = -1;
      if (klammern > deep)
	status = -2;
      if (status == 0 && sende) {
	if (klammern != 0)
	  status = -2;
      }
      if (status == 0)
	strcpy(lastaw, aw);
      if (status < 0)
	fehlerbehandlung();
    } while (status == 2);
  }
  if (status == 1)
    return;
  if (status == 0)
    message(mess[7]);
  else
    message(mess[6]);
  scanf("%*[^\n]");
  getchar();
}


Static Void get_awl()
{
  short FORLIM;
  awrec *WITH;

  for (i = 1; i <= anzopr; i++)
    maxopr[i - 1] = -1;
  status = 0;
  korrektur = false;
  clrscr();
  printf("Filename : ");
  gets(filename);
  if (*filename == '\0') {
    message(mess[6]);
    return;
  }
  if (wish) {
    fprintf(write_to, "set file \"%s\"\n", filename);
    fflush(write_to);
/* p2c: s5.p, line 1069: Warning: Symbol 'FFLUSH' is not defined [221] */
  }
  printf(" Reading %s...\n", filename);
  strcpy(infile_NAME, filename);
  if (infile != NULL)
    infile = freopen(infile_NAME, "r", infile);
  else
    infile = fopen(infile_NAME, "r");
  if (infile == NULL)
    _EscIO(FileNotFound);
  einlesen();
  if (infile != NULL)
    fclose(infile);
  infile = NULL;
  sim_init();
  if (status != 1) {
    message(mess[7]);
    return;
  }
  if (korrektur) {
    if (infile != NULL)
      infile = freopen(infile_NAME, "w", infile);
    else
      infile = fopen(infile_NAME, "w");
    if (infile == NULL)
      _EscIO(FileNotFound);
    FORLIM = anzaw;
    for (i = 1; i <= FORLIM; i++) {
      WITH = &awl[i - 1];
      fputs(WITH->operation, infile);
      fputs(WITH->operand, infile);
      if (WITH->baustein == -1)
	putc('\n', infile);
      else {
	fprintf(infile, "%d", WITH->baustein);
	if (WITH->bitnr == -1)
	  putc('\n', infile);
	else
	  fprintf(infile, ".%d\n", WITH->bitnr);
      }
    }
    if (infile != NULL)
      fclose(infile);
    infile = NULL;
  }
  message(mess[0]);
}


Static Void open_wish()
{
  wish = true;
  
    childpid = start_child("wish",&read_from,&write_to);

  fprintf(write_to, "source s5wish.tcl\n");
  fflush(write_to);
/* p2c: s5.p, line 1118: Warning: Symbol 'FFLUSH' is not defined [221] */
}


Static Void close_wish()
{
  if (wish) {
    fprintf(write_to, "exit\n");
    fflush(write_to);
/* p2c: s5.p, line 1126: Warning: Symbol 'FFLUSH' is not defined [221] */
  }
}


Static Void help()
{
  printf("./s5 -wish\t\topens wish visualisation\n");
  printf("     -autoload\tasks immidiately for awl to load\n");
  printf("     -help \t\tthis help\n\n");
  printf("Please read the file readme.s5...\n");
}


main(argc, argv)
int argc;
Char *argv[];
{
  Char STR1[256];
  Char *TEMP;

  PASCAL_MAIN(argc, argv);
  outfile = NULL;
  infile = NULL;
  lst_ = NULL;
  write_to = NULL;
  read_from = NULL;
  /*  assign(lst,'/dev/printer');
    append(lst);*/
  wish = false;
  nodisplay = false;
  status = -1;
  speed = 100;
  randomize();
  if (P_argc > 1) {
    for (i = 1; i < P_argc; i++) {
      if (!strcmp(strcpy(STR1, P_argv[i]), "-wish"))
	open_wish();
      if (!strcmp(strcpy(STR1, P_argv[i]), "-autoload"))
	get_awl();
      if (!strcmp(strcpy(STR1, P_argv[i]), "-help"))
	help();
      if (!strcmp(strcpy(STR1, P_argv[i]), "-nodisplay"))
	nodisplay = true;
    }
  }
  do {
    if (wish) {
      fgets(line, 256, read_from);
      TEMP = strchr(line, '\n');
      if (TEMP != NULL)
	*TEMP = 0;
      /* writeln(write_to,'set msg "',line,'"'); */
      fflush(write_to);
/* p2c: s5.p, line 1162: Warning: Symbol 'FFLUSH' is not defined [221] */
      i = (sscanf(line, "%d", &wahl) == 0);
    } else {
      if (wahl != 3)
	clrscr();
      printf("1 =Read AWL\n");
      printf("2 =Modify I/O/M/C/T\n");
      printf("3 =Single Step \n");
      printf("4 =Start Prg.  \n");
      printf("5 =Run Prg. until CTRL-C\n");
      printf("8 =Open wish\n");
      printf("9 =Close wish\n");
      printf("11=Decrease Speed\n");
      printf("12=Increase Speed\n");
      printf("0 =Exit\n");
      scanf("%hd%*[^\n]", &wahl);
      getchar();
    }

    switch (wahl) {

    case 1:
      get_awl();
      break;

    case 2:
      sim_untermenue();
      break;

    case 3:
      if (status != 1)
	get_awl();
      if (status == 1)
	sim_anweisung();
      break;

    case 4:
      if (status != 1)
	get_awl();
      if (status == 1) {
	do {
	  sim_anweisung();
	  gets(line);
	} while (*line == '\0');
      }
      break;

    case 5:
      if (status != 1)
	get_awl();
      if (status == 1) {
	inst_break();
/* p2c: s5.p, line 1205:
 * Warning: Symbol 'INST_BREAK' is not defined [221] */
	do {
	  sim_anweisung();
/* p2c: s5.p, line 1208:
 * Warning: Expected an expression, found a ')' [227] */
/* p2c: s5.p, line 1208: Warning: Symbol 'IS_BREAK' is not defined [221] */
	} while (is_break(0) != 1);
      }
      break;

    case 8:
      open_wish();
      break;

    case 9:
      close_wish();
      break;

    case 11:
      speed_upd(-1);
      break;

    case 12:
      speed_upd(1);
      break;
    }
  } while (wahl != 0);
  /*  close (lst);*/
  close_wish();
  if (read_from != NULL)
    fclose(read_from);
  if (write_to != NULL)
    fclose(write_to);
  if (lst_ != NULL)
    fclose(lst_);
  if (infile != NULL)
    fclose(infile);
  if (outfile != NULL)
    fclose(outfile);
  exit(EXIT_SUCCESS);
}



/* End. */
