//Filename: util.h
//Purpose: Header file for util.c
//$Id: util.h,v 1.4 1997/07/29 21:11:14 rkirkpat Exp $

/*
 * Copyright (c) 1996-1997 by Ryan Kirkpatrick (rkirkpat@nag.cs.colorado.edu). 
 *   All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#ifndef FUNCTPROTO
	#include <stdlib.h>
	#include <math.h>
#endif

int bin2dec (char *bin);
//PRE: bin points to a eight or less character string.
//POST: FCTVAL == decimal equivalent of bin. Missing leading places in bin 
//        filled with zeros before conversion. Then LSB was in bin[7], and 
//        MSB was in bin[0].

char* dec2bin (int dec);
//PRE: dec is less than 256 and greater than zero.
//POST: FCTVAL == string of one and zeros representing the 8bit binary 
//        equivlent of dec. LSB is in FCTVAL[7], MSB is in FCTVAL[0].

int moddec (int dec, int pos);
//PRE: dec is less than 256, pos is less than 8 (both greater than zero).
//POST: The pos(th) bit of dec has been toggled. ie: 10d => 1010b => 1011b
//        => 11d if pos was 0.

int setdec (int dec, int pos, int state);
//PRE: dec is less than 256, pos is less than 8, state is less than 2, and
//       all are greater than zero.
//POST: The pos(th) bit of dec has been set to state. ie: 10d => 1010b
//        => 1000b => 8d if pos was 2 and state was 0.

int dec2bcd (int dec);
//PRE: dec is less than 100 and greater than zero
//POST: FCTVAL is a decimal, that when broken down into binary, seperated at
//        between bits 4 and 5, represents two _B_inary _C_oded _D_ecimals.

//EOF
