//Filename: interface.h
//Purpose: The header file for interface.c
//$Id: interface.h,v 1.6 1997/07/29 21:12:11 rkirkpat Exp $

/*
 * Copyright (c) 1996-1997 by Ryan Kirkpatrick (rkirkpat@nag.cs.colorado.edu). 
 *   All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#ifndef FUNCTPROTO
  #include <ncurses.h>
  #define FUNCTPROTO
    #include "util.h"
  #undef FUNCTPROTO
  #define RCS
    #include "ppc.h"
  #undef RCS
#endif

//Function Prototypes

void InitScreen();
//POST: Screen and Ncurses have been initialized.

void Redraw(unsigned short base);
//POST: Screen has been redrawn.

void RedrawMenu();
//POST: Everything below the 14th row has been erased from the screen and
//        the menu has been redrawn.

void UpdateStatus (int data);
//PRE: data contains a integer less than 255, that describes the state of
//      the status port.
//POST: The on-screen display for the status bits has been updated.

void UpdateData (int data);
//PRE: data contains a integer less than 255, that describes the state of
//      the data port.
//POST: The on-screen display for the data bits has been updated.

void UpdateControl (int data);
//PRE: data contains a integer less than 255, that describes the state of
//      the control port.
//POST: The onscreen display for the control bits has been updated.

void UserHerlp();
//POST: User help has been displayed.

//EOF
