/*************************************************************************

    progutil - utility to program PIC Micros with picprog

    Version 0.1 			   

    File: progutil.cpp -- main file
    Begin: 11. Nov 1999

    Copyright (C) 1999, 2000 by Raffael Stocker
    E-mail: raffael.stocker@stud.fh-deggendorf.de

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
    02111-1307, USA.

*************************************************************************/
    
#include "mainclass.h"
#include "progutil.h"
#include <stdexcept>

char *
copydata (char *dest, const char *src, int size)
{
  if (!src) return 0; 
  delete [] dest;
  try
    {
      dest = new char[size];
    }
  catch (bad_alloc &e)
    {
      cerr << ERRSTR << "Memory exhausted" << endl;
      exit (1);
    }
  dest = (char*)memcpy ((void*)dest, (const void*)src, size);
  return dest;
}

int
main(int argc, char *argv[])
{
  Mainclass m(argc, argv);
  
  return m.exec();
}
