#ifndef PROGRAMMER_H
#define PROGRAMMER_H

/*************************************************************************

    progutil - utility to program PIC Micros with picprog

    Version 0.1
    
    File: programmer.h -- Programmer class
    Begin: 11. Nov 1999

    Copyright (C) 1999, 2000 by Raffael Stocker
    E-mail: raffael.stocker@stud.fh-deggendorf.de

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
    02111-1307, USA.

*************************************************************************/

#include <string>
#include <stdexcept>

#define CONFIG    1
#define PROGRAM   2
#define DATA      4

class Programmer
{
 public:
  // Exception-class for programmer related errors
  class ProgrammerFailure: public runtime_error
    {
    public:
      ProgrammerFailure (const string &what_string) : runtime_error (what_string) {}
    };
  Programmer(string);
  ~Programmer();
  void erase(int);
  void program(int);
  void read(int);
  void disablecp();

  const char *prgdata () { return (const char*)prgmem; }
  const char *dmdata () { return (const char*)dmmem; }
  const char *cfgdata () { return (const char*)cfgmem; }
  void setprgdata (const char*);
  void setdmdata (const char*);
  void setcfgdata (const char*);
 private:
  char *prgmem;
  char *dmmem;
  char *cfgmem;
  string device;
  int fd;
};

#endif /* PROGRAMMER_H */
