/* 
    picprog - a development programmer driver

    Copyright (C) 1999, 2000 raffael.stocker@stud.fh-deggendorf.de (Raffael Stocker)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


    13. Jul 1999   -   started coding
    22. Jul 1999  0.1  initial release
    19. Feb 2000  0.2  new release
*/


#ifndef __PICPROG
#define __PICPROG


#include <linux/ioctl.h>



#define PICMEMSIZE 0x3FF
#define PICDATASIZE 0x3F

#ifdef __KERNEL__

/* module-defines */

#define min(a,b)   (a < b) ? a : b;

#define PICPROG_MAJOR    0     /* set default major here (0 = dynamic) */

#define PICPROG_NAME     "picprog"
#define PICPROG_VERSION  "V0.2"

#define PICPROG_PRINT(fmt, args...) printk(KERN_NOTICE "picprog: " fmt, ## args)


typedef struct {
  int port;                 /* parallel port for device */ 
  int num;                  /* minor number of device */
  char *data;               /* data for programming */
  char *rp, *wp, *end;      /* pointers for read, write  and buffer end */
  int progstate;            /* programming or erasing??? */
  int temp;                 /* we keep last written word for verifying here */
  struct wait_queue *wr_queue;  /* wait queue for writing task */
} picp_t;

/* Programming commands for PIC16X84 */

#define LOAD_CONFIG  0           /* commands as defined by Microchip */
#define MAGIC_1      1           /* needed to disable Code-Protection */
#define MAGIC_2      7
#define LOAD_DATA    2
#define READ_DATA    4
#define INC_ADDR     6
#define BEGIN_PROG   8
#define LOAD_DATA_DM 3
#define READ_DATA_DM 5
#define BULK_ER_PM   9
#define BULK_ER_DM   11
#define MAX_CMD      63

/* Programmer commands */

#define RESET        64
#define PROGRAM_MODE 65
#define RUN_MODE     66

/* error definitions */

#define CMD_ERROR    -1

/* Dataline definitions */

#define DATA_OUT      0x01     /* data lines of programmer interface */
#define CLOCK         0x02
#define DATA_DIR      0x04
#define VPP_CONTR     0x08
#define MCLR_CONTR    0x10
#define CLOCK_EN      0x20
#define DATA_IN       0x40


#endif

#undef PDEBUG
#ifdef PICPROG_DEBUG
# ifdef __KERNEL__
#  define PDEBUG(fmt, args...) printk(KERN_DEBUG "picprog: " fmt, ## args)
# else
#  define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
# endif
#else
# define PDEBUG(fmt, args...)
#endif

#undef PDEBUGG
#define PDEBUGG(fmt, args...)


/* PICPROG IOCTL's */

#define PICPROG_MAGIC 'P'
#define PICPROG_IOCMAX 10

#ifdef PICPROG_DEBUG
#define PICPROG_HARDRESET _IO  (PICPROG_MAGIC, 1)  /* only for debuging */
#endif /* PICPROG_DEBUG */
#define PICPROG_BULKERPM  _IO  (PICPROG_MAGIC, 2)  /* bulk erase of program memory */
#define PICPROG_BULKERDM  _IO  (PICPROG_MAGIC, 3)  /* bulk erase of data memory */
#define PICPROG_READ_DM   _IOR (PICPROG_MAGIC, 4, char[PICDATASIZE+2])
#define PICPROG_LOAD_DM   _IOW (PICPROG_MAGIC, 5, char[PICDATASIZE+2])
#define PICPROG_LOAD_CONFIG _IOW (PICPROG_MAGIC, 6, char[11])
#define PICPROG_READ_CONFIG _IOR (PICPROG_MAGIC, 7, char[11])
#define PICPROG_DISPROT   _IO  (PICPROG_MAGIC, 8)

#endif







