#ifndef MAINCLASS_H
#define MAINCLASS_H

/*************************************************************************

    progutil - utility to program PIC Micros with picprog

    Version 0.1 			   

    File: mainclass.h -- Mainclass of progutil
    Begin: 11. Nov 1999

    Copyright (C) 1999, 2000 by Raffael Stocker
    E-mail: raffael.stocker@stud.fh-deggendorf.de

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
    02111-1307, USA.

*************************************************************************/

#include "programmer.h"
#include <string>

class Mainclass
{
public:
  Mainclass (int, char**);
  ~Mainclass ();
  int exec ();
private:
  void parseargs ();
  void print_usage();
  void print_version();

  Programmer *picprog;
  int argc;
  int erase_mask, program_mask, read_mask;
  bool disablecp;
  bool ver_wanted, help_wanted;
  char **argv;
  string datafile, outputfile, devicefile;
  string infilefmt, outfilefmt;
};

#endif /* MAINCLASS_H */

