#ifndef FILELOADER_H
#define FILELOADER_H

/*************************************************************************

    progutil - utility to program PIC Micros with picprog

    Version 0.1 			   

    File: fileloader.h -- transparent loader for files
    Begin: 19. Nov 1999

    Copyright (C) 1999, 2000 by Raffael Stocker
    E-mail: raffael.stocker@stud.fh-deggendorf.de

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
    02111-1307, USA.

*************************************************************************/

#include <string>
#include "datafile.h"

class FileLoader {
public:
  FileLoader () {}
  ~FileLoader () {}
  class LoaderException: public runtime_error
    {
    public:
      LoaderException (const string &what_string) : runtime_error (what_string) {}
    };
  DataFile *getfile (string);
  DataFile *getfile (string file, string form)
    { format = form; return getfile (file); }
  DataFile *newfile (string);
  DataFile *newfile (string file, string form)
    { format = form; return newfile (file); }

  void setformat (string form) { format = form; }
  string getformat () { return format; }
private:
  DataFile *getobj (string);
  string format;
};

#endif /* FILELOADER_H */
