/*************************************************************************

    progutil - utility to program PIC Micros with picprog

    Version 0.1 			   

    File: fileloader.cpp -- transparent loader for files
    Begin: 19. Nov 1999

    Copyright (C) 1999, 2000 by Raffael Stocker
    E-mail: raffael.stocker@stud.fh-deggendorf.de

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
    02111-1307, USA.

*************************************************************************/

#include "fileloader.h"
#include "binfile.h"
#include <string>


DataFile *
FileLoader::getfile (string filename)
{
  DataFile *file = getobj (filename);
  file->loadfile ();
  return file;
}
 
DataFile *
FileLoader::newfile (string filename)
{
  DataFile *file = getobj (filename); 
  return file;
}

DataFile *
FileLoader::getobj (string filename)
{
  DataFile *file;
  string extension;

  if (format.empty ())
    {
      string::size_type pos = filename.rfind ('.');

      if (pos != string::npos)
	extension = filename.substr (++pos);
      
      if (extension.empty ()) throw LoaderException ("Unknown file type");
    }
  else
    extension = format;

  if (extension == "bin")
    return file = new BinFile (filename); 
  // insert elseifs for other fileformats
  else
    throw LoaderException ("Unknown file type");
}
