#ifndef DATAFILE_H
#define DATAFILE_H

/*************************************************************************

    progutil - utility to program PIC Micros with picprog

    Version 0.1 			   

    File: datafile.h -- Program data abstraction
    Begin: 19. Nov 1999

    Copyright (C) 1999, 2000 by Raffael Stocker
    E-mail: raffael.stocker@stud.fh-deggendorf.de

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
    02111-1307, USA.

*************************************************************************/

#include <string>
#include <stdexcept>

class DataFile {
public:
  class FileException: public runtime_error
    {
    public:
      FileException (const string &what_string) : runtime_error (what_string) {}
    };
  virtual void loadfile () = 0;
  virtual void savefile () = 0;
  virtual const char *getident () = 0;

  const char *getprogmem () { return (const char*)progmem; }
  const char *getdatamem () { return (const char*)datamem; }
  const char *getconfmem () { return (const char*)confmem; }

  void setprogmem (const char *);
  void setdatamem (const char *);
  void setconfmem (const char *); 
protected:
  DataFile (string);
  virtual ~DataFile ();

  string filename;
  char *progmem;
  char *datamem;
  char *confmem;
};

#endif /* DATAFILE_H */
