/*************************************************************************

    progutil - utility to program PIC Micros with picprog

    Version 0.1 			   

    File: datafile.cpp -- Program data abstraction
    Begin: 19. Nov 1999

    Copyright (C) 1999, 2000 by Raffael Stocker
    E-mail: raffael.stocker@stud.fh-deggendorf.de

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
    02111-1307, USA.

*************************************************************************/

#include "datafile.h"
#include "progutil.h"
#include <cstring>

DataFile::~DataFile ()
{
  delete [] progmem;
  delete [] datamem;
  delete [] confmem;
}

DataFile::DataFile (string file)
{
  if (file.empty ()) throw invalid_argument ("No filename given");
  filename = file;
  progmem = 0;
  datamem = 0;
  confmem = 0;
}

void
DataFile::setprogmem (const char *data)
{
  progmem = copydata (progmem, data, PRGSIZE);
}

void
DataFile::setdatamem (const char *data)
{
  datamem = copydata (datamem, data, DATSIZE);
}

void
DataFile::setconfmem (const char *data)
{
  confmem = copydata (confmem, data, CFGSIZE);
}
