/*************************************************************************

    progutil - utility to program PIC Micros with picprog

    Version 0.1 			   

    File: binfile.cpp -- Binary file format implementation
    Begin: 19. Nov 1999

    Copyright (C) 1999, 2000 by Raffael Stocker
    E-mail: raffael.stocker@stud.fh-deggendorf.de

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for m ore details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place--Suite 330, Boston, MA
    02111-1307, USA.

*************************************************************************/

#include "binfile.h"
#include "progutil.h"

BinFile::BinFile (string file) : DataFile (file) {}

void
BinFile::loadfile ()
{
  ifstream infile;
  bool opened = false; 

  infile.open (filename.c_str ());
  if (infile.is_open ())
    {
      opened = true;
      progmem = loaddata (infile, PRGSIZE);

      infile.clear ();
      infile.close ();
    }

  divname (filename);

  if (!datafile.empty ()) infile.open (datafile.c_str ());
  if (infile.is_open ())
    {
      opened = true;
      datamem = loaddata (infile, DATSIZE);

      infile.clear ();
      infile.close ();
    }

  if (!cfgfile.empty ()) infile.open (cfgfile.c_str ());
  if (infile.is_open ())
    {
      opened = true;
      confmem = loaddata (infile, CFGSIZE);

      infile.close ();
    }
  if (!opened) throw FileException ("Couln't open file");
}

void
BinFile::savefile ()
{
  ofstream outfile; 

  try
    {
      if (progmem) outfile.open (filename.c_str ());
      if (outfile.is_open ())
	{
	  for (int i = 0; i < PRGSIZE; i++)
	    outfile.put (progmem[i]);

	  outfile.clear ();
	  outfile.close ();
	}

      divname (filename);

      if (datamem && !datafile.empty ()) outfile.open (datafile.c_str ());
      if (outfile.is_open ())
	{
	  for (int i = 0; i < DATSIZE; i++)
	    outfile.put (datamem[i]);

	  outfile.clear ();
	  outfile.close ();
	}

      if (confmem && !cfgfile.empty ()) outfile.open (cfgfile.c_str ());
      if (outfile.is_open ())
	{
	  for (int i = 0; i < CFGSIZE; i++)
	    outfile.put (confmem[i]);

	  outfile.clear ();
	  outfile.close ();
	}
    }
  catch (...)
    {
      throw FileException ("Couldn't save file");
    }
}

const char *
BinFile::getident ()
{
  return "Binary file loader";
}

void
BinFile::divname (string file)
{
  string::size_type pos = file.rfind ('.'); // handle given _conf and _data first?

  if (pos != string::npos)
    {
      basename = file.substr (0, pos);
      extension = file.substr (pos);
      cfgfile = basename + "_conf" + extension;
      datafile = basename + "_data" + extension;
    }
}

char *
BinFile::loaddata (ifstream &in, int count)
{
  char c;
  char *data = 0;
  try
    {
      data = new char[count];
    }
  catch (bad_alloc &e)
    {
      cerr << ERRSTR << "Memory exhausted" << endl;
      exit (1);
    }

  for (int i = 0; i < count; i++)
    {
      if (!in.get (c)) throw FileException ("Couldn't read file or false filesize");
      data[i] = c;
    }
  
  return data;
}
