/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 *  RCS: $Header: draw.h,v 2.1 94/09/28 14:26:09 nau Exp $
 */

/* prototypes for drawing routines
 */

#ifndef	__DRAW_INCLUDED__
#define	__DRAW_INCLUDED__

#include "global.h"

void	RedrawOutput(void);
void	ClearAndRedrawOutput(void);
void	SwitchDrawingWindow(int, Window);
void	RedrawCurrentLayer(void);
void	DrawVia(PinTypePtr);
void	DrawPin(PinTypePtr);
void	DrawLine(LayerTypePtr, LineTypePtr);
void	DrawText(LayerTypePtr, TextTypePtr);
void	DrawPolygon(LayerTypePtr, PolygonTypePtr);
void	DrawElement(ElementTypePtr);
void	DrawElementName(ElementTypePtr);
void	DrawElementPackage(ElementTypePtr);
void	DrawElementPins(ElementTypePtr);
void	EraseVia(PinTypePtr);
void	ErasePin(PinTypePtr);
void	EraseLine(LineTypePtr);
void	EraseText(TextTypePtr);
void	ErasePolygon(PolygonTypePtr);
void	EraseElement(ElementTypePtr);
void	EraseElementName(ElementTypePtr);
void	DrawGrid(void);

#endif
