/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994,1995 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@rz.uni-ulm.de
 *
 *  RCS: $Header: /sda4/users/nau/src/pcb/RCS/const.h,v 2.3 1994/10/29 17:30:51 nau Exp nau $
 */

/* global constants
 */

#ifndef	__CONST_INCLUDED__
#define	__CONST_INCLUDED__

#include <limits.h>
#include <X11/cursorfont.h>

/* ---------------------------------------------------------------------------
 * some file-, directory- and environment names
 */
#define	FONTFILENAME		"default_font"
#define	EMERGENCY_NAME		"/tmp/PCB.%i.save"		/* %i --> pid */
#define	BACKUP_NAME			"/tmp/PCB.%i.backup"	/* %i --> pid */

/* ---------------------------------------------------------------------------
 * the default X cursor shape for the output window
 */
#define	DEFAULT_CURSORSHAPE		XC_crosshair

/* ---------------------------------------------------------------------------
 * some limit specifications
 */
#define	MAX_LAYER				8	/* max number of layer, check source */
									/* code for more changes */
#define	MIN_LINESIZE			1	/* thickness of lines in 1/1000'' */
#define	MAX_LINESIZE			250
#define	MIN_TEXTSCALE			20	/* scaling of text objects in percent */
#define	MAX_TEXTSCALE			1000
#define	MIN_PINORVIASIZE		30	/* size of a pin or via in */
#define	MIN_PINORVIAHOLE		10	/* size of a pins or vias drilling hole */
#define	MAX_PINORVIASIZE		250
#define	MIN_PINORVIACOPPER		20	/* min difference outer-inner diameter */
#define	MIN_GRID				1	/* grid in 1/1000'' */
#define	MAX_GRID				200
#define	MIN_ZOOM				0	/* min zoom (shift operations) */
#define	MAX_ZOOM				4	/* max zoom (shift operations) */
#define	MAX_FONTPOSITION		127	/* upper limit of characters in my font */

#define	MAX_COORD				20000	/* coordinate limits */
#define	MIN_SIZE				3000/* lowest widht and height */
#define	MAX_BUFFER				5	/* number of pastebuffers */
									/* additional changes in menu.c are */
									/* also required to select more buffers */

#define	DEFAULT_DRILLINGHOLE	40	/* default inner/outer ratio for */
									/* pins/vias in percent */

#if MAX_LINESIZE > MAX_PINORVIASIZE	/* maximum size value */
#define	MAX_SIZE	MAX_LINESIZE
#else
#define	MAX_SIZE	MAX_PINORVIASIZE
#endif

#ifndef	MAXPATHLEN					/* maximum path length */
#ifdef	PATH_MAX
#define	MAXPATHLEN	PATH_MAX
#else
#define	MAXPATHLEN	2048
#endif
#endif

#define	MAX_SEARCH_POINT_DISTANCE	15	/* maximum distance when searching */
										/* polygon points */

/* ---------------------------------------------------------------------------
 * modes
 */
#define	NO_MODE					0	/* no mode selected */
#define	VIA_MODE				1	/* draw vias */
#define	LINE_MODE				2	/* draw lines */
#define	RECTANGLE_MODE			3	/* create rectangles */
#define	POLYGON_MODE			4	/* draw filled polygons */
#define	PASTEBUFFER_MODE		5	/* paste objects from buffer */
#define	TEXT_MODE				6	/* create text objects */
#define	MIRROR_MODE				101	/* move objects */
#define	ROTATE_MODE				102	/* rotate objects */
#define	REMOVE_MODE				103	/* remove objects */
#define	MOVE_MODE				104	/* move objects */
#define	COPY_MODE				105	/* copy objects */

/* ---------------------------------------------------------------------------
 * misc constants
 */
#define	DEFAULT_SIZE			"7000x5000"	/* default layout size (EURO) */
#define	DEFAULT_MEDIASIZE		"a4"		/* default output media */
#define	DEFAULT_CELLSIZE		50			/* default cell size for symbols */
#define	MARK_SIZE				50			/* size of a mark for elements */
#define	MIN_GRID_DISTANCE		4			/* minimum distance between point */
											/* to enable grid drawing */

/* ---------------------------------------------------------------------------
 * object flags
 */
#define	OBJ_FLAGS		0x4f		/* all used flags */
#define	NOFLAG			0x00
#define	PINFLAG			0x01		/* is a pin */
#define	VIAFLAG			0x02		/* is a via */
#define	FOUNDFLAG		0x04		/* was used by 'FindConnection()' */
#define	MIRRORFLAG		0x08		/* use mirroring for text */
#define	SELECTEDFLAG	0x40		/* object has been selected */

/* ---------------------------------------------------------------------------
 * PCB flags
 */
#define	PCB_FLAGS			0x01a0		/* all used flags */
#define	CANONICALFLAG		0x0020		/* display canonical element names */
#define	ABSOLUTEFLAG		0x0080		/* grid is relative to (0,0) */
#define	ALLDIRCETIONFLAG	0x0100		/* enable 'all-direction' lines */

/* ---------------------------------------------------------------------------
 * define some standard layouts for childs of a form widget
 */
#define	LAYOUT_TOP		XtNleft, XtChainLeft,	\
						XtNright, XtChainLeft,	\
						XtNtop, XtChainTop,		\
						XtNbottom, XtChainTop
#define	LAYOUT_BOTTOM	XtNleft, XtChainLeft,	\
						XtNright, XtChainLeft,	\
						XtNtop, XtChainBottom,	\
						XtNbottom, XtChainBottom
#define	LAYOUT_NORMAL	XtNleft, XtChainLeft,	\
						XtNright, XtChainRight,	\
						XtNtop, XtChainTop,		\
						XtNbottom, XtChainBottom

/* ---------------------------------------------------------------------------
 * object types
 */
#define	NO_TYPE					0x0000		/* no object */
#define	VIA_TYPE				0x0001
#define	ELEMENT_TYPE			0x0002
#define	LINE_TYPE				0x0004
#define	POLYGON_TYPE			0x0008
#define	TEXT_TYPE				0x0010

#define	PIN_TYPE				0x1000		/* objects that are part */
#define	ELEMENTNAME_TYPE		0x2000		/* of others */
#define	POLYGONPOINT_TYPE		0x4000

#define	ALL_OBJECTS				0x0fff		/* all single objects */
#define	ALL_TYPES				-1			/* all bits set */

#endif
