static char *SccsId = "@(#)xnetwork.c 4.5 (TU-Delft) 06/26/92";
/**********************************************************

Name/Version      : xsls/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 16-Feb-1987
Modified by       : A.J. van Genderen
Modification date : 16-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

int netCounter;

extern int language;
extern int tog_nodnbr;

xnetwork (ntwname, proj, imported, orig_name, submod, listnames)
char *ntwname;
DM_PROJECT *proj;
int imported;
char *orig_name;
int submod;
int listnames;
{
    struct model_info *ntw;
    struct net_ref *nets;
    struct model_info *newNetw ();

    ntw = newNetw (ntwname, proj, orig_name, submod);  
    ntw -> imported = imported;

    oprint (0, "\n");

    nameNbrReset ();

    prHead (ntw, submod);

    if (tog_nodnbr)
	ntabprint ();

    readNet (ntw, &nets);

    findNetInit (nets);

    if (language != EDIF)
	prNets (ntw, nets);

    prInst (ntw);

    if (language == EDIF)
	prNets (ntw, nets);

    if (listnames)
	ntabprint ();

    prFoot (ntw, submod);

    findNetEnd ();

    delNet (nets);
}

readNet (m, anets)     /* read the net file of model m */
struct model_info *m;
struct net_ref **anets;
{
    DM_STREAM *dsp;
    struct net_ref *nref, *nreflast;

    dsp = dmOpenStream (m -> dkey, "net", "r");

    netCounter = 1;

    *anets = NULL;
    nreflast = NULL;
    while (dmGetDesignData (dsp, CIR_NET) > 0) {
	netCounter++;
	PALLOC (nref, 1, struct net_ref);
	PALLOC ((nref -> n), 1, struct cir_net);
	structcpy ((char *)(nref -> n), (char *)&cnet, 
		   sizeof (struct cir_net));
	nref -> next = NULL;
	if (*anets == NULL)
	    *anets = nref;
	else
	    nreflast -> next = nref;
	nreflast = nref;
    }

    dmCloseStream (dsp, COMPLETE);
}

structcpy (s, t, size)
char *s;
char *t;
int size;
{
    while (size-- > 0) {
	*s++ = *t++;
    }
}

delNet (nets)
struct net_ref *nets;
{
    struct net_ref *nref;
    struct net_ref *help;

    nref = nets;
    while (nref != NULL) {
	help = nref;
	nref = nref -> next;
	cnetClean (help -> n);
	FREE (help -> n);
	FREE (help);
    }
}

cnetClean (n)
struct cir_net *n;
{
    int i;

    for (i = 0; i < n -> net_neqv; i++) {
	cnetClean (&(n -> net_eqv[i]));
    }

    FREE (n -> net_attribute);

    if (n -> net_neqv > 0)
	FREE (n -> net_eqv);

    if (n -> net_dim > 0) {
	FREE (n -> net_lower);
	FREE (n -> net_upper);
    }

    if (n -> inst_dim > 0) {
	FREE (n -> inst_lower);
	FREE (n -> inst_upper);
    }

    if (n -> ref_dim > 0) {
	FREE (n -> ref_lower);
	FREE (n -> ref_upper);
    }
}
