/* SccsId = "@(#)type.h 4.5 (TU-Delft) 06/26/92" */
/**********************************************************

Name/Version      : xsls/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 16-Feb-1987
Modified by       : A.J. van Genderen
Modification date : 16-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/

struct cir {
    char name[DM_MAXNAME + 1];
    char orig_name[DM_MAXNAME + 1];
    int imported;
    DM_PROJECT *proj;
    struct cir *next;
};

struct net_ref {
    struct cir_net *n;
    struct net_ref *next;
};

struct term_ref {
    struct cir_term *t;
    int type;
    struct term_ref *next;
};

struct model_info {
    char name[DM_MAXNAME + 1];
    char orig_name[DM_MAXNAME + 1];
    char out_name[DM_MAXNAME + 1];
    DM_CELL *dkey;
    int imported;
    DM_PROJECT *proj;
    struct term_ref *terms;
    char prefix[32];        /* for spice instance name */
    float dw;
    float dl;
    float vbulk;
    int vbulkdefined;
    int spec_dev;
    char *param;
    struct model_info *next;
};
