static char *SccsId = "@(#)findFunc.c 4.4 (TU-Delft) 06/26/92";
/**********************************************************

Name/Version      : xsls/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 16-Feb-1987
Modified by       : S. de Graaf
Modification date : 08-Dec-1987
Modification date : 25-Aug-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1988, All rights reserved
**********************************************************/
#include "incl.h"

extern int xtree;
extern int alsoImport;

struct model_info *Funcs;
static struct model_info *pdfunc;  /* predefined functions */

initFuncs ()
{
    long *up, *low;

    PALLOC (pdfunc, 1, struct model_info);
    sprintf (pdfunc -> name, "");   /* in fact this one will be variable */
    PALLOC (up, 1, long);
    PALLOC (low, 1, long);
    low[0] = 0;
    up[0] = 1; /* in fact this one will be variable */
    termstore (pdfunc, "i", 1, low, up, INPUT);
    termstore (pdfunc, "o", 0, NULL, NULL, OUTPUT);
    pdfunc -> next = NULL;
}

struct model_info *findFunc (name, imported, father_proj, ninputs)
char *name;
int imported;
DM_PROJECT *father_proj;
int ninputs;
{
    char *real_name;
    register struct model_info *fun;

    if (strcmp (name, "and") == 0    /* test for predefined function */
     || strcmp (name, "or") == 0
     || strcmp (name, "nand") == 0
     || strcmp (name, "nor") == 0
     || strcmp (name, "exor") == 0
     || strcmp (name, "invert") == 0)
    {
	fun = pdfunc;
	fun -> terms -> t -> term_upper[0] = (long)(ninputs - 1);
	strcpy (fun -> name, name);
	strcpy (fun -> out_name, name);

	return (fun);
    }

    fun = Funcs;
    while (fun != NULL && strcmp (fun -> name, name) != 0) {
	fun = fun -> next;
    }

    if (fun != NULL)
	return (fun);  /* found ! */

    /* not found, read it ! */

    PALLOC (fun, 1, struct model_info);
    fun -> next = Funcs;
    Funcs = fun;
    strcpy (fun -> name, name);
    strcpy (fun -> out_name, name);

    fun -> proj = dmFindProjKey (imported, name,
			         father_proj, &real_name, CIRCUIT);
    if (xtree && alsoImport && strcmp (name, real_name) != 0) {
	fatalErr (
	 "cannot handle aliases when also retrieving imported cells:", 
		  real_name);
    }
    strcpy (fun -> orig_name, real_name);

    readTerm (fun, 1, 1);

    return (fun);
}

prImpFunc ()
{
    prImpMod (Funcs, "functions");
}
