/* SccsId = "@(#)type.h 4.3 (TU-Delft) 05/26/92" */
/**********************************************************

Name/Version      : tecc/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
struct maskRef {
    int mask;
    struct maskRef *next;
};

struct layer {
    int mask;
    int occurrence;
};

struct layerRef {
    struct layer *lay;
    struct layerRef *next;
};

struct layerCond {
    struct layer *lay;
    int present;
};

struct layCondRef {
    struct layerCond *layC;
    struct layCondRef *next;
};

struct elemRef {
    short type;
    short no;
    int check;
    struct elemRef *next;
};

struct contact {
    char name[DM_MAXNAME + 1];
    int id;
    char sort[DM_MAXNAME + 1];
    int sortNr;
    int mask1;
    int mask2;
    double val;
    struct layCondRef *cond;
};

struct transistor {
    char name[DM_MAXNAME + 1];
    int id;
    int g;
    int ds;
    struct layCondRef *cond;
};

struct capacitance {
    char name[DM_MAXNAME + 1];
    int id;
    char sort[DM_MAXNAME + 1];
    int sortNr;
    struct layer *pLay;
    struct layer *nLay;
    long sBitPresent;
    long sBitAbsent;
    long oeBitPresent;
    long oeBitAbsent;
    double val;
    struct layCondRef *cond;
};

struct resistance {
    char name[DM_MAXNAME + 1];
    int id;
    char sort[DM_MAXNAME + 1];
    int sortNr;
    int mask;
    double val;
    struct layCondRef *cond;
};

struct vdimension {
    char name[DM_MAXNAME + 2];
    int id;
    int mask;
    double height;
    double thickness;
    struct layCondRef *cond;
};

struct shape {
    char name[2 * DM_MAXNAME + 2];
    int id;
    int type;
    int mask;
    double xb1;
    double xt1;
    double xb2;
    double xt2;
    struct layCondRef *cond;
};
