static char *SccsId = "@(#)rmRedElem.c 4.3 (TU-Delft) 05/26/92";
/**********************************************************

Name/Version      : tecc/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 10-Oct-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <dmincl.h>
#include "define.h"
#include "type.h"
#include "extern.h"

rmRedElem ()    /* remove redundant element references from keyTab   */
{               /* i.e. remove element references with same id,  in  */
    int k;      /* the same slot, and with no additional conditions. */
    int id;
    int other_id;
    struct elemRef * elref;
    struct elemRef * prev_other_elref;

    for (k = 0; k < nbrKeySlots; k++) {

	elref = keytab[k];
	while (elref != NULL) {

	    switch (elref -> type) {
		case TOR :
		    if (tors[ elref -> no ].cond == NULL) {
			id = tors[ elref -> no ].id; 
		    }
		    else id = -1;
		    break;
		case SURFCAP :
		case EDGECAP :
		case LATCAP :
		    if (caps[ elref -> no ].cond == NULL) {
			id = caps[ elref -> no ].id; 
		    }
		    else id = -1;
		    break;
		case CON :
		    if (cons[ elref -> no ].cond == NULL) {
			id = cons[ elref -> no ].id; 
		    }
		    else id = -1;
		    break;
		case RES :
		    if (ress[ elref -> no ].cond == NULL) {
			id = ress[ elref -> no ].id; 
		    }
		    else id = -1;
		    break;
		case VDIMEN :
		    if (vdms[ elref -> no ].cond == NULL) {
			id = vdms[ elref -> no ].id; 
		    }
		    else id = -1;
		    break;
		case ESHAPE :
		case CSHAPE :
		    if (shps[ elref -> no ].cond == NULL) {
			id = shps[ elref -> no ].id; 
		    }
		    else id = -1;
		    break;
	    }

            if (id < 0) {
	        elref = elref -> next;
		continue;
	    }

	    prev_other_elref = elref;
	    while (prev_other_elref -> next != NULL) {

		if (prev_other_elref -> next -> type == elref -> type) {
		    switch (elref -> type) {
		    case TOR :
			if (tors[ prev_other_elref -> next -> no].cond == NULL)
			    other_id = tors[ prev_other_elref -> next -> no].id;
			else
			    other_id = -1;
			break;
		    case SURFCAP :
		    case EDGECAP :
		    case LATCAP :
			if (caps[ prev_other_elref -> next -> no].cond == NULL)
			    other_id = caps[ prev_other_elref -> next -> no].id;
			else
			    other_id = -1;
			break;
		    case CON :
			if (cons[ prev_other_elref -> next -> no].cond == NULL)
			    other_id = cons[ prev_other_elref -> next -> no].id;
			else
			    other_id = -1;
			break;
		    case RES :
			if (ress[ prev_other_elref -> next -> no].cond == NULL)
			    other_id = ress[ prev_other_elref -> next -> no].id;
			else
			    other_id = -1;
			break;
		    case VDIMEN :
			if (vdms[ prev_other_elref -> next -> no].cond == NULL)
			    other_id = vdms[ prev_other_elref -> next -> no].id;
			else
			    other_id = -1;
			break;
		    case ESHAPE :
		    case CSHAPE :
			if (shps[ prev_other_elref -> next -> no].cond == NULL)
			    other_id = shps[ prev_other_elref -> next -> no].id;
			else
			    other_id = -1;
			break;
		    }
		}
		else
		    other_id = -1;
		
		if (id == other_id) {
		    prev_other_elref -> next = prev_other_elref -> next -> next;
		}
		else {
		    prev_other_elref = prev_other_elref -> next;
		}
	    }

	    elref = elref -> next;
	}
    }
}
