static char *SccsId = "@(#)rmRedCond.c 4.3 (TU-Delft) 05/26/92";
/**********************************************************

Name/Version      : tecc/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <dmincl.h>
#include "define.h"
#include "type.h"
#include "extern.h"

rmRedCond ()    /* remove redundant conditions */
{
    int i;

    for (i = 0; i < con_cnt; i++) {
	rmRedC (&cons[i].cond);
    }

    for (i = 0; i < tor_cnt; i++) {
	rmRedC (&tors[i].cond);
    }

    for (i = 0; i < cap_cnt; i++) {
	rmRedC (&caps[i].cond);
    }

    for (i = 0; i < res_cnt; i++) {
	rmRedC (&ress[i].cond);
    }

    for (i = 0; i < vdim_cnt; i++) {
	rmRedC (&vdms[i].cond);
    }

    for (i = 0; i < shape_cnt; i++) {
	rmRedC (&shps[i].cond);
    }
}

rmRedC (condp)
struct layCondRef **condp;
{
    struct layCondRef *c, *prevc;
    struct layerRef *k;

    c = *condp;
    prevc = NULL;

    while (c != NULL) {
	k = keylist;
	while (k != NULL) {
	    if (k -> lay -> mask == c -> layC -> lay -> mask
	    && k -> lay -> occurrence == c -> layC -> lay -> occurrence) {
		break;
	    }

	    k = k -> next;
	}

	if (k != NULL) {   /* layer is in keylist, 
			      so it is redundant and can be removed ! */

	    if (prevc == NULL)
		*condp = c -> next;
	    else
		prevc -> next = c -> next;

	}
	else 
	    prevc = c;

	c = c -> next;
    }
}
