/* SccsId = "@(#)define.h 4.3 (TU-Delft) 05/26/92" */
/**********************************************************

Name/Version      : tecc/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#define ALLOC(ptr, nel, type)      {                                           \
	if ((ptr = (type *)calloc( (unsigned)(nel), sizeof(type))) == NULL) {  \
	    fprintf (stderr, "Cannot allocate storage\n");                     \
	    die ();                                                            \
        }                                                                      }

#define REALLOC(ptr, nel, type)      {                                         \
	if ((ptr = (type *)realloc((char *)ptr,                                \
				   (unsigned)(nel) * sizeof(type))) == NULL) { \
	    fprintf (stderr, "Cannot allocate storage\n");                     \
	    die ();                                                            \
        }                                                                      }

#define FREE(ptr)                  {                                           \
	if (ptr != NULL) {                                                     \
	    cfree( (char *)ptr );                                              \
	    ptr = NULL;                                                        \
	}                                                                      }

#define OPENR(fp, fn)     {                                                    \
	if ( ( fp = fopen (fn, "r") ) == NULL) {                               \
	    fprintf (stderr, "Cannot read %s\n", fn);                          \
	    die ();                                                            \
	}                                                                      }

#define OPENW(fp, fn)           {                                              \
	if ( ( fp = fopen (fn, "w") ) == NULL) {                               \
	    fprintf (stderr, "Cannot write %s\n", fn);                         \
	    die ();                                                            \
	}                                                                      }

#define CLOSE(fp)                { fclose (fp); }

#define RES      1
#define TOR      2
#define CON      3
#define SURFCAP  4
#define EDGECAP  5
#define LATCAP   6
#define VDIMEN   7
#define ESHAPE   8
#define CSHAPE   9

#define MAXCON    40
#define MAXTOR    40
#define MAXCAP   400
#define MAXRES    40
#define MAXVDIM   80
#define MAXSHAPE 400

#define MAXRESSORT  40
#define MAXCAPSORT  40

#define SURFACE    1
#define EDGE       2
#define OTHEREDGE  3
