/* SccsId = "@(#)scan.h 4.5 (TU-Delft) 11/24/92" */
/**********************************************************

Name/Version      : space/4.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <sys/types.h>
#include <sys/times.h>

typedef struct edge {
    coor_t xl, yl, xr, yr;
    coor_t dx, dy;
    mask_t color;
    struct tile * tile;
    struct edge * fwd, * bwd;
    struct edge * bundle;
    coor_t xi, xc;
} edge_t;

struct _scanInfo {
    int xl, xr, yb, yt;
    int xpos;
    int noTiles,
	maxNoTiles;
    struct tms tms1, tms2;
    int rtime;
    int alloc;
    int srl;	/* stateruler length */
    int edges;  /* number of edges */
};

extern struct _scanInfo scanInfo;

#ifdef MANHATTAN
#define Y(e,x) (e -> yl)
#else
#define Y(e,x) \
    (e -> dy == 0 ? e -> yl : \
    (e -> dy  > 0 ? e -> yl + (x-e->xl) * (2*e->dy+1) / (2*e->dx) \
                  : e -> yl + (x-e->xl) * (2*e->dy-1) / (2*e->dx)))

#endif /* MANHATTAN */

#define Slope(e) (2*e->dy+(e->dy>0?1:-1))/(2*e->dx)

#define compareSlope(e1, op, e2) \
    (((e1) -> dy * (e2) -> dx) op ((e2) -> dy * (e1) -> dx))

/* from update.c */
extern void setXr ();
extern void tileInsertEdge ();
extern void tileDeleteEdge ();
extern void tileCrossEdge ();
extern void tileAddTerm ();
extern void tileAdvanceScan ();
extern void tileStopScan ();

/* from edge.c */
extern edge_t * createEdge ();
extern void disposeEdge ();
extern void printEdge ();
extern void edgeStatistics ();

/* from input.c */
extern void openInput ();
extern void closeInput ();
extern edge_t * fetchEdge ();
extern terminal_t * fetchTerm ();

/* from main.c */
extern int main ();
extern int dmError ();
extern void die ();
extern void quit ();
extern void verbose ();
extern void message ();

/* from tile.c */
extern tile_t * createTile ();
extern void disposeTile ();
extern void printTile ();
extern void tileStatistics ();

/* from scan.c */
extern void setContext ();
extern void catchAlarm ();
extern void whereAmI ();
extern void scan ();

/* from slant.c */
extern void testIntersection ();
extern int smallerAtX ();
extern edge_t * split ();

/* from getParam.c */
extern void getParameters ();
extern void reGetParameters ();

/* from hierarchy.c */
extern void readTid ();
extern void disposeTid ();

/* from info.c */
extern void scanPrintInfo ();

/* from determine.c */
extern bool_t existDmStream ();
extern int compareDmStreamDate ();
extern int compareGlnDate ();
extern char *cktName ();
