static char *SccsId = "@(#)plot.c 4.3 (TU-Delft) 5/1/92";
/**********************************************************

Name/Version      : mplot/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include "dmincl.h"
#include "config.h"
#include "plot.h"
#include "aux/aux.h"

#define Scale(x) (scale * (x))
static int scale = 1;

static FILE * fpPlot;

#ifndef lint
plotPass () {}
plotBbox () {}
#endif /* lint */

plotInit (key)
DM_CELL * key;
{
    DM_STREAM * info;

    /* fpPlot = cfopen (mprintf ("%s.plot", key -> cell), "w"); */
    fpPlot = cfopen ("plotfile", "w");

    info = dmOpenStream (key, "info3", "r");
    dmGetDesignData (info, GEO_INFO3);
    dmCloseStream (info, COMPLETE);

    if (ginfo3.nr_samples != 0)
	scale = ginfo3.nr_samples;
    else
	scale = SCALE;

    fprintf (fpPlot, "%s\n", key -> cell);
    fprintf (fpPlot, "min %ld %ld\n", Scale (ginfo3.bxl), Scale (ginfo3.byb));
    fprintf (fpPlot, "max %ld %ld\n", Scale (ginfo3.bxr), Scale (ginfo3.byt));
    if (scale > 1)
	fprintf (fpPlot, "*r %d\n", scale );
    fprintf (fpPlot, "*l %g\n", key -> dmproject -> lambda);
    fprintf (fpPlot, "*ol1\n"); /* enable plot option -l */
}

plotEnd ()
{
    fclose (fpPlot), fpPlot = NULL;
}

plotMask (name, color)
char * name;
int color;
{
    static int s_printed = 0;
    fprintf (fpPlot, "lay %s %d\n", name, color);
    if (!s_printed++) fprintf (fpPlot, "s 20 28\n");
}

plotTerminal (xl, xr, yb, yt, name)
long xl, xr, yb, yt;
char * name;
{
    xl = Scale (xl);
    xr = Scale (xr);
    yb = Scale (yb);
    yt = Scale (yt);

    fprintf (fpPlot, "r%ld %ld %ld %ld\n",   xl, yb, xr - xl, yt - yb);
    fprintf (fpPlot, "m%ld %ld\nd%ld %ld\n", xl, yb, xr, yt);
    fprintf (fpPlot, "m%ld %ld\nd%ld %ld\n", xr, yb, xl, yt);
}

plotContour (edge)
edge_t * edge;
{
    edge_t * e;

    for (e = edge; e != NULL; e = e -> link) {
	if (e -> yl != e -> yr) {
	    plotPolygon (edge);
	    return;
	}
    }
    plotRect (edge);
}

static plotRect (edge)
edge_t *edge;
{
    edge_t * e;
    int x0 = edge -> xr, y0 = edge -> yr;
    int x = edge -> xl, y = edge -> link -> yl;

    _dmDoput (fpPlot, "rD D D D\n", x0, y0, x - x0, y - y0);

    e = edge -> link, DISPOSE (edge), edge = e;
    while (e = edge -> link) {
	x = (edge -> xl == x) ? edge -> xr : edge -> xl;
	y = e -> yl;
	_dmDoput (fpPlot, "xD D\n", x - x0, y - y0);
	DISPOSE (edge), edge = e;
    }
    DISPOSE (edge);
}

static plotPolygon (edge)
edge_t * edge;
{
    edge_t * e;
    int x0 = edge -> xr, y0 = edge -> yr;
    int x  = edge -> xl, y  = edge -> yl;

    _dmDoput (fpPlot, "pD D\nxD D\n", x0, y0, x - x0, y - y0);

    e = edge -> link, DISPOSE (edge), edge = e;
    while (edge) {
        if (edge -> xl == x) {
	    if (edge -> yl != y) {	/* vert */
		x = edge -> xl, y = edge -> yl;
		_dmDoput (fpPlot, "xD D\n", x - x0, y - y0);
	    }
	    x = edge -> xr, y = edge -> yr;
	    if (x != x0 || y != y0)	/* do not close contour */
		_dmDoput (fpPlot, "xD D\n", x - x0, y - y0);
	}
	else {
	    ASSERT (edge -> xr == x);
	    if (edge -> yr != y) {	/* vert */
		x = edge -> xr, y = edge -> yr;
		_dmDoput (fpPlot, "xD D\n", x - x0, y - y0);
	    }
	    x = edge -> xl, y = edge -> yl;
	    if (x != x0 || y != y0)	/* do not close contour */
		_dmDoput (fpPlot, "xD D\n", x - x0, y - y0);
	}
	e = edge -> link, DISPOSE (edge), edge = e;
    }
}

printLinks (edge)	/* print contour (use when in debugger) */
edge_t * edge;
{
    while (edge) {
        printf ("%d %d %d %d\n",
	    edge -> xl, edge -> xr, edge -> yl, edge -> yr);
	edge = edge -> link;
    }
}
